/* by Peter Wirbelauer 2011 for OxygenBasic */

Type WNDCLASS
 Style         as long
 lpfnwndproc   as long
 cbClsextra    as long
 cbWndExtra    as long
 hInstance     as long
 hIcon         as long
 hCursor       as long
 hbrBackground as long
 lpszMenuName  as long
 lpszClassName as long
End Type

Type PointApi
 x as long
 y as long
End Type

Type MSG
 hwnd    as long
 message as long
 wParam  as long
 lParam  as long
 time    as long
 pt      as PointApi
End Type

Type RECT
 Left   as Long
 Top    as Long
 Right  as Long
 Bottom as Long
End Type

  type PAINTSTRUCT
    ; 64 bytes
    hDC        as long
    fErase     as long
    rcPaint    as rect
    fRestore   as long
    fIncUpdate as long
    rgb        as rgbacolor
    Reserved   as 32
  end type


% SW_NORMAL      = 1
% SW_SHOWDEFAULT = 10
% SW_SHOW        = 5
% CS_VREDRAW     = 1
% CS_HREDRAW     = 2
% CS_OWNDC       = 32
% SM_CXSCREEN    = 0
% SM_CYSCREEN    = 1
% IDI_HAND       = 32513
% IDI_QUESTION   = 32514
% IDI_EXCLAMATION= 32515
% IDI_ASTERISK   = 32516
% IDI_WINLOGO    = 32517
% IDI_APPLICATION= 32512
% IDC_ARROW      = 32512
% IDC_WAIT       = 32514
% IDC_HAND       = 32649
% IDC_ICON       = 32641
% IDC_IBEAM      = 32513
% IDC_NO         = 32648
% WM_SETICON     = &H80  
% WM_CREATE      = 1
% WM_DESTROY     = 2
% WM_PAINT       = 15
% WM_QUIT        = 18
% WM_SIZE        = 5
% WM_MOVE        = 3
% WM_ERASEBKGND  = 20
% WM_CHAR        = 258
% WM_KEYLAST     = &H108
% WM_KEYFIRST    = &H100
% WM_MOUSEMOVE   = 512
% WM_KEYDOWN     = 256
% WM_KEYUP       = 257
% WM_MBUTTONDOWN = 519
% WM_LBUTTONDOWN = 513
% WM_RBUTTONDOWN = 516
% WM_LBUTTONUP   = 514
% WM_RBUTTONUP   = 517
% WM_MBUTTONUP   = 520
% WM_TIMER       = 275
% WS_SYSMENU     = 524288 
% WS_OVERLAPPED  = WS_SYSMENU     
% WS_FULLWINDOW  = 0x00cf0000
% WS_POPUP       = 0x80000000
% WS_DLGFRAME    = 0x400000
% WS_EX_LAYERED  = 100
% WS_MAXIMIZE    = &H1000000
% WS_MINIMIZEBOX = &H20000
% WS_BORDER      = &H800000

% TRANSPARENT    = 1
% OPAQUE         = 2
% PM_REMOVE      = 1
% PM_NOREMOVE    = 0
% PM_NOYIELD     = 2
% NULL_BRUSH     = 5
% FW_BOLD        = 700
% FW_LIGHT       = 300
% FW_HEAVY       = 900
% FW_NORMAL      = 400
% PS_DOT         = 2
% PS_SOLID       = 0
% WHITE_BRUSH    = 0
% BLACK_BRUSH    = 4

% vk_LBUTTON  = &H1	
% vk_RBUTTON  = &H2 
% vk_MBUTTON  = &H4
% vk_BACK     = &H8
% vk_TAB      = &H9 
% vk_CLEAR    = &HC 
% vk_RETURN   = &HD 
% vk_SHIFT    = &H10 
% vk_CONTROL  = &H11 
% vk_MENU     = &H12 
% vk_PAUSE    = &H13 
% vk_CAPITAL  = &H14 
% vk_ESCAPE   = &H1B 
% vk_SPACE    = &H20 
% vk_PRIOR    = &H21 
% vk_NEXT     = &H22 
% vk_END      = &H23 
% vk_HOME     = &H24 
% vk_LEFT     = &H25 
% vk_UP       = &H26 
% vk_RIGHT    = &H27 
% vk_DOWN     = &H28 
% vk_PRINT    = &H2A 
% vk_SNAPSHOT = &H2C	 
% vk_INSERT   = &H2D 
% vk_DELETE   = &H2E 
% vk_HELP     = &H2F 
% vk_0 = &H30 
% vk_1 = &H31 
% vk_2 = &H32 
% vk_3 = &H33 
% vk_4 = &H34 
% vk_5 = &H35
% vk_6 = &H36 
% vk_7 = &H37 
% vk_8 = &H38 
% vk_9 = &H39 
% vk_A = &H41 
% vk_B = &H42 
% vk_C = &H43 
% vk_D = &H44 
% vk_E = &H45 
% vk_F = &H46 
% vk_G = &H47 
% vk_H = &H48 
% vk_I = &H49 
% vk_J = &H4A 
% vk_K = &H4B
% vk_L = &H4C 
% vk_M = &H4D 
% vk_N = &H4E 
% vk_O = &H4F 
% vk_P = &H50 
% vk_Q = &H51 
% vk_R = &H52 
% vk_S = &H53 
% vk_T = &H54 
% vk_U = &H55 
% vk_V = &H56 
% vk_W = &H57 
% vk_X = &H58 
% vk_Y = &H59 
% vk_Z = &H5A 
% vk_F1  = &H70 
% vk_F2  = &H71 
% vk_F3  = &H72 
% vk_F4  = &H73 
% vk_F5  = &H74 
% vk_F6  = &H75 
% vk_F7  = &H76 
% vk_F8  = &H77 
% vk_F9  = &H78 
% vk_F10 = &H79 
% vk_F11 = &H7A 
% vk_F12 = &H7B 
% vk_F13 = &H7C 
% vk_F14 = &H7D 
% vk_F15 = &H7E 
% vk_F16 = &H7F 
% vk_F17 = &H80 
% vk_F18 = &H81 
% vk_F19 = &H82 
% vk_F20 = &H83 
% vk_F21 = &H84 
% vk_F22 = &H85 
% vk_F23 = &H86 
% vk_F24 = &H87 
% vk_NUMLOCK    = &H90 
% vk_OEM_SCROLL = &H91	 
% vk_LSHIFT     = &HA0 
% vk_RSHIFT     = &HA1 
% vk_LCONTR     = &HA2	 
% vk_RCONTROL   = &HA3	

Type TRGB
 r As Long
 g As Long
 b As Long
End Type

Dim kernel32,user32
kernel32 = LoadLibrary "kernel32.dll"
user32   = LoadLibrary "user32.dll"
 
Bind kernel32
(
  GetCommandLine  GetCommandLineA   
  GetModuleHandle GetModuleHandleA  
  ExitProcess     ExitProcess
  sleep           Sleep
  Beep            Beep    
)  

Bind user32
(
  LoadIcon         LoadIconA        
  LoadCursor       LoadCursorA       
  RegisterClass    RegisterClassA    
  MessageBox       MessageBoxA       
  SendMessage      SendMessageA 
  GetMessage       GetMessageA 
  PeekMessage      PeekMessageA
  TranslateMessage TranslateMessage 
  DispatchMessage  DispatchMessageA 
  PostQuitMessage  PostQuitMessage  
  PostMessage      PostMessageA
  CreateWindowEx   CreateWindowExA   
  ShowWindow       ShowWindow        
  UpdateWindow     UpdateWindow      
  DefWindowProc    DefWindowProcA
  InvalidateRect   InvalidateRect
  ValidateRect     ValidateRect
  GetSystemMetrics GetSystemMetrics 
  ReleaseDC        ReleaseDC
  GetDC            GetDC
  ShowCursor       ShowCursor
  GetAsyncKeyState GetAsyncKeyState
  GetKeyState      GetKeyState
  BeginPaint       BeginPaint        ; @8
  EndPaint         EndPaint          ; @8
  GetClientRect    GetClientRect     ; @8  
)
 
extern lib "gdi32.dll"

Declare Function GetStockObject   (Byval n as long) as long
Declare Function CreateSolidBrush (Byval n as long) as long
Declare Function SetBkMode        (Byval h as long, Byval n as long) as long
Declare Function SetBkColor       (Byval h as long, Byval n as long) as long
Declare Function GetPixel         (ByVal hdc As Long, ByVal x As Long, ByVal y As Long) As Long
Declare Function SetPixel         (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long
Declare Function Rectangle        (ByVal hdc As Long, ByVal x1 As Long, ByVal y1 As Long, ByVal x2 As Long, ByVal y2 As Long) As Long
Declare Function TextOut          Alias "TextOutA" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal lpString As String, ByVal nCount As Long) As Long
Declare Function DeleteDC         (ByVal hdc As Long) As Long
Declare Function PatBlt           (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dwRop As Long) As Long
Declare Function SetBkColor       (ByVal hdc As Long, ByVal crColor As Long) As Long
Declare Function BitBlt           (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Declare Function CreateFont       Alias "CreateFontA" (ByVal H As Long, ByVal W As Long, ByVal E As Long, ByVal O As Long, ByVal W As Long, ByVal I As Long, ByVal u As Long, ByVal S As Long, ByVal C As Long, ByVal OP As Long, ByVal CP As Long, ByVal Q As Long, ByVal PAF As Long, ByVal F As String) As Long
Declare Function SelectObject     (ByVal hdc As Long, ByVal hObject As Long) As Long
Declare Function DeleteObject     (ByVal hObject As Long) As Long
Declare Function SetTextColor     (ByVal hdc As Long, ByVal crColor As Long) As Long
Declare Function CreateCompatibleBitmap  (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Declare Function CreateCompatibleDC      (ByVal hdc As Long) As Long

end extern

Declare Function LoadImage  Lib "user32.dll" Alias "LoadImageA" (ByVal hInst As Long,ByVal lpsz As String,ByVal un1 As Long,ByVal n1 As Long, ByVal n2 As Long, ByVal un2 As Long) As Long
Declare Function PlaySound  Lib "winmm.dll" Alias "PlaySoundA" (ByVal lpszName As String, ByVal hModule As Long, ByVal dwFlags As Long) As Long
Declare Function timeGetTime   Lib "winmm.dll" () As Long
Declare Function DestroyWindow Lib "user32.dll" (ByVal hwnd As Long) As Long

Declare Function QueryPerformanceCounter   Lib "kernel32.dll" (ByRef lpPerformanceCount As LARGE_INTEGER) As Long
Declare Function QueryPerformanceFrequency Lib "kernel32.dll" (ByRef lpFrequency As LARGE_INTEGER) As Long

% sys_Red   =1
% sys_Green =2
% sys_Blue  =4

Dim cRgb As TRGB
Dim wm as MSG
Dim wc as WndClass 

Dim BackHdc   As Long
Dim BackHnd   As Long
Dim xBack     As Long
Dim yBack     As Long
Dim sys_Seed  As Long
Dim MouseX    As Long
Dim MouseY    As Long
Dim Sys_Hdc   As Long
Dim Sys_hwnd  As Long
Dim FontHnd   As Long
Dim WinExit   As Long
Dim WinWidth  As Long
Dim WinHeight As Long
Dim ImgHdc    As Long
Dim ImgHnd    As Long
Dim ImgWidth  AS Long
Dim ImgHeight AS Long
Dim BufferDC  As Long

Function HiWord (byval hi as long) as long
shr hi,16 : Function = hi
End Function

Function LoWord (byval lo as long) as long
and lo,&hFFFF : Function = lo
End Function


declare sub keys()
declare sub render()
sys act,lbutton, keydown

Function WndProc(byval hWnd as long,byval wMsg as long, byval wParam as long,byval lparam as long) as long callback
'
'
if wMsg = WM_CREATE
  '
elseiF wMsg = WM_PAINT
  render()
ElseiF wMsg = WM_MOVE
  act=1
  InvalidateRect sys_hwnd,0,0
elseif wMsg = WM_SIZE
  act=1
  InvalidateRect sys_hwnd,0,0
elseif wMsg = WM_MOUSEMOVE
  MouseX = LoWord(lParam)
  MouseY = HiWord(lParam)
  InvalidateRect sys_hwnd,0,0
elseif wMsg = WM_LBUTTONDOWN
  lbutton=1
  act=1
elseiF wMsg = WM_LBUTTONUP
  lbutton=0
  act=0
  InvalidateRect sys_hwnd,0,0
elseiF wMsg = WM_KEYDOWN
  keydown=1
  act=1
  'k=getAsyncKeyState (1)
  InvalidateRect sys_hwnd,0,0
elseiF wMsg = WM_KEYUP
  keydown=0
  act=0
elseiF wMsg = WM_ERASEBKGND
  function=1
elseiF wMsg = WM_DESTROY
  PostQuitMessage 0
else
  Function = DefWindowProc hWnd,wMsg,wParam,lParam
endif
End Function

Function DoEvents()
'iF PeekMessage (&wm,0,0,0,Pm_Remove) >0
'iF wm.message = Wm_Quit Then WinExit =1 
'TranslateMessage &wm
'DispatchMessage  &wm
'End iF

  static long bRet
  bRet = GetMessage (&wm, 0, 0, 0)
  if bret<=0 then
    WinExit=1
  else
    TranslateMessage &wm
    DispatchMessage &wm
  end if
End Function


Function SetFont(byval hdc As Long, byval width As Long, byval height As long, byval flags As Long,byval font As string)  
FontHnd = CreateFont height,width,0,0,flags,0,0,0,0,0,0,0,0,font
SelectObject hdc,FontHnd
SetBkMode hdc,1
End Function

Function DrawText(byval hdc as long, byval text as string, byval x3 as long, byval y3 as long, byval color as long) 
SetTextColor hdc,color
TextOut hdc,x3,y3,text,Len(text)
End Function

Function SetBuffer(byval x As Long, byval y As Long) as long
BackHnd = CreateCompatibleBitmap(sys_hdc, x, y)
BackHdc = CreateCompatibleDC(sys_hdc)
SelectObject BackHdc, BackHnd
xBack = x : yBack = y
Function = BackHdc
End Function

Function SetWindow (byval cap as string, byval Ww as long, byval Wh as long, byval style as long) as long
Dim Wx, Wy, Scr as long
inst = GetModuleHandle 0
wc.style = CS_HREDRAW or CS_VREDRAW
wc.lpfnWndProc = &WndProc
wc.cbClsExtra =0
wc.cbWndExtra =0
wc.hInstance  = inst
wc.hIcon=LoadIcon 0,IDI_WINLOGO            
wc.hCursor=LoadCursor 0,IDC_ARROW       
wc.hbrBackground = GetStockObject BLACK_BRUSH
wc.lpszMenuName  = cap
wc.lpszClassName =&"Win"
RegisterClass &wc
WinWidth = Ww : WinHeight = Wh
Scr = GetSystemMetrics SM_CXSCREEN
Wx  = (Scr - Ww) /2
Scr = GetSystemMetrics SM_CYSCREEN
Wy  = (Scr - Wh) /2
sys_hwnd = CreateWindowEx 0, wc.lpszClassName, cap, style, Wx, Wy, Ww, Wh, 0, 0, inst, 0
ShowWindow sys_hwnd, SW_SHOW
Sys_hdc  = GetDC(sys_hwnd)
BufferDC = SetBuffer (Ww, Wh)
sys_Seed = timeGetTime
Function = sys_hwnd
End Function

Function Randomize()
sys_Seed = timeGetTime
End Function

Function RGB(byval red as long, byval green as long, byval blue as long) as long
Function = red + green*256 + blue*65536
End Function

Function Rand(byval z1 as long, byval z2 as long) as long
Long rnd 
mov  eax,z2
sub  eax,z1
inc  eax
imul edx,sys_Seed,0x8088405
inc  edx
mov  sys_Seed,edx
mul  edx
add  edx,z1
mov  rnd,edx
Function = rnd
End Function 

Function SetImage(byval iWidth as long, byval iHeight as long) as long
ImgHnd = CreateCompatibleBitmap(sys_hdc, iWidth, iHeight)
ImgHdc = CreateCompatibleDC(sys_hdc)
SelectObject ImgHdc, ImgHnd
ImgWidth = iWidth:ImgHeight = iHeight
Function = ImgHdc
End Function

Function FlipImageRect(byval x1 as long, byval y1 as long, byval iw as long, byval ih as long, byval x0 as long, byval y0 as long)
BitBlt sys_hdc, x1, y1, iw, ih, ImgHdc, x0, y0, &hCC0020
End Function

Function ClearImage()
PatBlt ImgHdc, 0, 0, ImgWidth, ImgHeight, &h42
End Function

Function FlipBuffer()
BitBlt Sys_hdc, 0, 0, xBack, yBack, BackHdc, 0, 0, &hCC0020
End Function

Function ClearBuffer (byval color as long)
sys_Brush = CreateSolidBrush color
SelectObject BackHdc, sys_Brush
Rectangle BackHdc,0,0,xBack,yBack
DeleteObject sys_Brush
End Function

Function FreeGraphics()
DeleteObject BackHnd
DeleteDC     BackHdc
DeleteObject ImgHnd
DeleteDC     ImgHdc 
DeleteObject FontHnd 
End Function

Function WinEnd()             
FreeGraphics
DestroyWindow sys_hwnd 
freelibrary kernel32
freelibrary user32
End Function

Function Key(byval cKey As Long) As Long
Function = GetAsyncKeyState(cKey) and 0xffff
End Function

Function EscKey() As Long
Function = GetAsyncKeyState(27)
End Function

Function WaitKey(byval wKey as long)
While Not GetAsyncKeyState(wKey)
DoEvents
FlipBuffer
Wend
End Function
 
Function MouseClick() As Long  
iF GetAsyncKeyState(1) and 0xffff
Function = 1
ElseiF GetAsyncKeyState(2) and 0xffff
Function = 2
ElseiF GetAsyncKeyState(4) and 0xffff
Function = 4
Else
Function = 0
End iF
End Function

Function ShowMouse(byval mouse As Long)   
ShowCursor(mouse)
End Function                

Function GetRGB(byval color as long, byval comp as long) as long 
iF     comp =1              '-> Red   component or use sys_red
cRGB.r = color & &HFF0000
Function = cRGB.r
ElseiF comp =2              '-> Green component or use sys_green 
cRGB.g = color & &H00FF00
Function = cRGB.g
ElseiF comp =4              '-> Blue  component or use sys_blue
cRGB.b = color & &H0000FF
Function = cRGB.b
End iF
End Function

Function DrawLine(byval hdc as long, byval x1 as long, byval y1 as long, byval x2 as long, byval y2 as long, byval col as long)
Dim i,deltaX,deltaY,pixel,d,dinc1,dinc2 As Long
Dim x, xinc1, xinc2, y, yinc1, yinc2 As Long
deltaX = Abs (x2-x1)
deltaY = Abs (y2-y1)
iF deltaX >= deltaY
 pixel = deltaX +1
 d = (2* deltaY) - deltaX
 dinc1 = deltaY *2
 dinc2 = (deltaY - deltaX) *2
 xinc1 = 1
 xinc2 = 1
 yinc1 = 0
 yinc2 = 1
Else
 pixel = deltaY +1
 d = (2 * deltaX)-deltaY
 dinc1 = deltaX *2                
 dinc2 = (deltaX-deltaY) *2      
 xinc1 = 0
 xinc2 = 1
 yinc1 = 1
 yinc2 = 1
end iF
iF x1 > x2 
 xinc1 = - xinc1
 xinc2 = - xinc2
End iF
iF y1 > y2 
 yinc1 = - yinc1
 yinc2 = - yinc2
End iF
x = x1
y = y1
For i =1 To pixel 
SetPixel hdc, x, y, col
iF d < 0 
 d = d + dinc1
 x = x + xinc1
 y = y + yinc1
Else
 d = d + dinc2
 x = x + xinc2
 y = y + yinc2
End iF
Next
End Function    

Function DrawCircle(byval hdc as long byval x0 as long, byval y0 as long, byval rad as long, byval col as long)
Dim f as long = 1 - rad
Dim ddF_x as long = 0
Dim ddF_y as long = -2 * rad
Dim x as long = 0
Dim y as long = rad
SetPixel hdc, x0, y0 + rad, col
setPixel hdc, x0, y0 - rad, col
setPixel hdc, x0 + rad, y0, col
setPixel hdc, x0 - rad, y0, col
While x < y 
iF f >= 0 
y -= 1
ddF_y += 2
f += ddF_y
End iF
x += 1
ddF_x += 2
f += ddF_x + 1
SetPixel hdc, x0 + x, y0 + y, col
SetPixel hdc, x0 - x, y0 + y, col
SetPixel hdc, x0 + x, y0 - y, col
SetPixel hdc, x0 - x, y0 - y, col
SetPixel hdc, x0 + y, y0 + x, col
SetPixel hdc, x0 - y, y0 + x, col
SetPixel hdc, x0 + y, y0 - x, col
SetPixel hdc, x0 - y, y0 - x, col
Wend
End Function

Function DrawBox(byval hdc as long, byval x5 as long, byval y5 as long, byval x6 as long, byval y6 as long, byval bCol as long)
Long x,y 
For x =0 To x6
SetPixel hdc,x5+x,y5,bCol
SetPixel hdc,x5+x,y5+y6,bCol
Next
For y =0 To y6
SetPixel hdc,x5,y5+y,bCol
SetPixel hdc,x5+x6,y5+y,bCol
Next
End Function

Function DrawEllipse(byval hdc as long, byval mx as long, byval my as long, byval a as long, byval b as long, byval color as long)
Long x, mx1 ,mx2, my1, my2
Long aq, bq, idx, idy, r, rx, ry
SetPixel hdc,mx + a, my, color
SetPixel hdc,mx - a, my, color
mx1 = mx - a: my1 = my
mx2 = mx + a: my2 = my
aq = a * a      
bq = b * b
idx = aq *2               
idy = bq *2               
r = a * bq                
rx = r *2                  
ry = 0                      
x = a
While x > 0
iF r > 0
my1 += 1: my2 -= 1
ry  += idx             
r  -= ry             
End iF
iF r <= 0
x -= 1
mx1 += 1: mx2 -= 1
rx -= idy
r +=  rx
End iF
SetPixel hdc,mx1, my1, color
SetPixel hdc,mx1, my2, color
SetPixel hdc,mx2, my1, color
SetPixel hdc,mx2, my2, color
Wend  
End Function




