'###########################################################
'####	 awinh v037 include file for o2(043)- win32   #####
'####	 by  Aurel 5.2.2021                          #####
'####	 Use at your own risk!                        #####
'###########################################################

type WNDCLASSEX
 cbSize        as INT
 Style         as INT
 lpfnwndproc   as SYS
 cbClsextra    as INT
 cbWndExtra    as INT
 hInstance     as INT
 hIcon         as INT
 hCursor       as INT
 hbrBackground as INT
 lpszMenuName  as INT
 lpszClassName as INT
 hIconSm       AS INT
End Type

Type LARGE_INTEGER
lowpart AS INT
highpart AS INT
End Type

Type POINTAPI
 x as INT
 y as INT
End Type

Type TEXTMETRIC
  tmHeight As Long
  tmAscent As Long
  tmDescent As Long
  tmInternalLeading As Long
  tmExternalLeading As Long
  tmAveCharWidth As Long
  tmMaxCharWidth As Long
  tmWeight As Long
  tmOverhang As Long
  tmDigitizedAspectX As Long
  tmDigitizedAspectY As Long
  tmFirstChar As Byte
  tmLastChar As Byte
  tmDefaultChar As Byte
  tmBreakChar As Byte
  tmItalic As Byte
  tmUnderlined As Byte
  tmStruckOut As Byte
  tmPitchAndFamily As Byte
  tmCharSet As Byte
End Type

Type LOGFONT
	lfHeight As Long
	lfWidth As Long
	lfEscapement As Long
	lfOrientation As Long
	lfWeight As Long
	lfItalic As Byte
	lfUnderline As Byte
	lfStrikeOut As Byte
	lfCharSet As Byte
	lfOutPrecision As Byte
	lfClipPrecision As Byte
	lfQuality As Byte
	lfPitchAndFamily As Byte
	lfFaceName As String * 32
End Type

Type MSG
 hwnd    as INT
 message as INT
 wParam  as INT
 lParam  as INT
 time    as INT
 pt      as POINTAPI
End Type

Type RECT
 Left   as INT
 Top    as INT
 Right  as INT
 Bottom as INT
End Type

Type PAINTSTRUCT
    INT hDC
    bool fErase
    RECT rcPaint
    bool fRestore
    bool fIncUpdate
    byte rgbReserved[32]
End type

Type OPENFILENAME
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    lpstrFilter As INT
    lpstrCustomFilter As INT
    nMaxCustFilter As Long
    nFilterIndex As Long
    lpstrFile As INT
    nMaxFile As Long
    lpstrFileTitle As INT
    nMaxFileTitle As Long
    lpstrInitialDir As INT
    lpstrTitle As INT
    flags As Long
    nFileOffset As word
    nFileExtension As word
    lpstrDefExt As INT
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As INT
End Type

% OFN_EXPLORER = 0x00080000
% OFN_PATHMUSTEXIST = 0x00000800
% OFN_FILEMUSTEXIST = 0x00001000
% OFN_OVERWRITEPROMPT = 0x00000002
% OFN_HIDEREADONLY = 0x00000004

% BCM_FIRST = 0x1600
% BCM_SETIMAGELIST = (BCM_FIRST + 0x0002)
% DT_RIGHT = &H2
% GWL_WNDPROC = -4


% SW_NORMAL      = 1
% SW_SHOWDEFAULT = 10
% SW_SHOW        = 5
% CS_VREDRAW     = 1
% CS_HREDRAW     = 2
% CS_DBLCLKS     = 0x8
% CS_OWNDC       = 32
% SM_CXSCREEN    = 0
% SM_CYSCREEN    = 1
% IDI_HAND       = 32513
% IDI_QUESTION   = 32514
% IDI_EXCLAMATION= 32515
% IDI_ASTERISK   = 32516
% IDI_WINLOGO    = 32517
% IDI_APPLICATION= 32512
% IDC_ARROW      = 32512
% IDC_WAIT       = 32514
% IDC_HAND       = 32649
% IDC_ICON       = 32641
% IDC_IBEAM      = 32513
% IDC_NO         = 32648

% WM_SETICON     = &H80
% WM_KILLFOCUS = 0x8  
% WM_CREATE      = 1
% WM_DESTROY     = 2
% WM_CLOSE       = 0x10
% WM_PAINT       = 15
% WM_QUIT        = 18
% WM_SIZE        = 5
% WM_MOVE        = 3
% WM_CHAR        = 258
% WM_KEYLAST     = &H108
% WM_KEYFIRST    = &H100
% WM_KEYDOWN     = 256
% WM_MOUSEMOVE   = 512
% WM_MBUTTONDOWN = 519
% WM_LBUTTONDOWN = 513
% WM_RBUTTONDOWN = 516
% WM_LBUTTONUP   = 514
% WM_RBUTTONUP   = 517
% WM_MBUTTONUP   = 520
% WM_TIMER       = 275
% WM_WINDOWPOSCHANGED = &H47
% WM_NOTIFY      = 0x004E
% WM_SETFONT = &H30
% WM_COMMAND = 0x111
% BN_CLICKED = 0
% WM_PARENTNOTIFY = 0x210
% WM_SETTEXT  = 0x000C
% WM_GETTEXT = 0xD
% WM_USER = 0x400
% WM_HSCROLL = 276
% WM_VSCROLL = 0x0115
'control color messages
% WM_CTLCOLORMSGBOX = 0x132
% WM_CTLCOLOREDIT = 0x133
% WM_CTLCOLORLISTBOX = 0x134
% WM_CTLCOLORBTN = 0x135
% WM_CTLCOLORDLG = 0x136
% WM_CTLCOLORSCROLLBAR = 0x137
% WM_CTLCOLORSTATIC = 0x138
% WM_CUT = 768
% WM_COPY = 769
% WM_PASTE = 770
% WM_SELECTALL = 768
% WM_SETREDRAW = 11
% WM_ERASEBKGND = 20
% WM_SETCURSOR = 0x0020

' Edit Control Messages
% EM_GETSEL = 0xB0
% EM_SETSEL = 0xB1
% EM_EXSETSEL = 1079
% EM_HIDESEL = 19
% EM_GETRECT = 0xB2
% EM_SETRECT = 0xB3
% EM_SETRECTNP = 0xB4
% EM_SCROLL = 0xB5
% EM_LINESCROLL = 0xB6
% EM_SCROLLCARET = 0xB7
% EM_GETMODIFY = 0xB8
% EM_SETMODIFY = 0xB9
% EM_GETLINECOUNT = 0xBA
% EM_LINEINDEX = 0xBB
% EM_SETHANDLE = 0xBC
% EM_GETHANDLE = 0xBD
% EM_GETTHUMB = 0xBE
% EM_LINELENGTH = 0xC1
% EM_REPLACESEL = 0xC2
% EM_GETLINE = 0xC4
% EM_LIMITTEXT = 0xC5
% EM_FINDTEXT = (WM_USER + 56)
% EM_GETTEXTLENGTHEX  = (WM_USER + 95)
% EM_CANUNDO = 0xC6
% EM_UNDO = 0xC7
% EM_FMTLINES = 0xC8
% EM_LINEFROMCHAR = &HC9
% EM_SETTABSTOPS = 0xCB
% EM_SETPASSWORDCHAR = 0xCC
% EM_EMPTYUNDOBUFFER = 0xCD
% EM_GETFIRSTVISIBLELINE = 0xCE
% EM_SETREADONLY = 0xCF
% EM_SETWORDBREAKPROC = 0xD0
% EM_GETWORDBREAKPROC = 0xD1
% EM_GETPASSWORDCHAR = 0xD2
% EM_POSFROMCHAR = (WM_USER + 38)
% EM_CHARFROMPOS = (WM_USER + 39)
% EM_GETEVENTMASK = 1083
% EM_SETEVENTMASK = 1093
% ENM_MOUSEEVENTS = 131072
% ENM_KEYEVENTS = 65536
% EM_EXLINEFROMCHAR = (WM_USER + 54)
'% EM_EXSETSEL = (WM_USER + 55)
% SCF_ALL = 4
'% EM_SETCHARFORMAT  = (WM_USER + 68)
% EM_SETCHARFORMAT = 1092

'style no hide selection -add to richedit style
% ES_NOHIDESEL = 256
% EM_SETMARGINS = &HD3
% EC_LEFTMARGIN = &H1
% EN_UPDATE = &H400
% EN_CHANGE = 768
'% CFM_COLOR = 1073741824
% CFM_COLOR     = &H40000000
% CFM_BOLD      = 1

% IDM_CUT       = 16
% IDM_COPY      = 15
% IDM_PASTE     = 26
% IDM_SELECTALL = 31

% IDM_UNDO      = 43
% IDM_REDO      = 29
% IDM_OPEN      = 2000
% IDM_SAVE      = 70
% IDM_SAVEAS    = 71

'charformat structure...
TYPE CHARFORMAT
  uint    cbSize
  dword   dwMask
  dword    dwEffects
  INT     yHeight
  INT     yOffset
  uint  crTextColor
  BYTE     bCharSet
  BYTE     bPitchAndFamily
  CHAR    szFaceName[LF_FACESIZE]
End TYPE



TYPE CHARRANGE
     INT cpMin
     INT cpMax
End TYPE

TYPE FINDTEXT
      CHARRANGE chrg
      int lpstrText
END TYPE

'bm bitmaps
% BM_SETIMAGE = 247
% MF_BYPOSITION   = &H400
% IMAGE_BITMAP = 0
% COLOR_BTNFACE = 15
% ILC_MASK = 1
% ILC_COLOR8 = 8
% ILC_COLOR16 = 16
% PS_SOLID = 0
% SRCCOPY = 0xCC0020
% PATCOPY = &HF00021
'% CFM_COLOR = 0x40000000
% ANSI_CHARSET = 0
% FR_WHOLEWORD = &H2 
% SCF_SELECTION = 0x0001
'% CFM_COLOR = 1073741824
% FR_DOWN = &H1
% DC_PEN = 19
'mousebutton...
% MK_LBUTTON = &H1

'progress constants
% PBM_SETPOS = 0x402
% PBM_SETRANGE32 = 0x406

'trackbar constants
% TB_TUMBTRACK = 5

% WS_CLIPSIBLINGS = 0x4000000
% WS_CLIPCHILDREN = 0x2000000
% WS_SYSMENU      = 524288 
% WS_THICKFRAME   = 0x40000
% WS_CAPTION      = 0xC00000 
% WS_OVERLAPPED   = 0x0  
% WS_TOOLWINDOW   = 0x00000080 '0x80
% WS_TOPMOST      = 0x8
% WS_EX_TOPMOST   = &H8
% WS_WINDOWEDGE   = 0x100
% WS_HIDDEN       = 2048
% WS_SIZED        = 262144
% WS_POPUP       = 0x80000000
% WS_DLGFRAME    = 0x400000
% WS_MAXIMIZE    = &H1000000
% WS_MINIMIZEBOX = &H20000
% WS_MAXIMIZEBOX = 0x10000
% WS_BORDER      = &H800000
% WS_CHILD       = 0x40000000
% WS_VISIBLE     = 0x10000000
% WS_VSCROLL     = 0x200000
% WS_HSCROLL     = 0x100000
% WS_OVERLAPPEDWINDOW = 0x00CF0000
'minmaxsize-> overlappedwindow
% WS_MINMAXSIZE =(WS_OVERLAPPED Or WS_VISIBLE Or WS_CAPTION Or WS_SYSMENU Or WS_THICKFRAME Or WS_MINIMIZEBOX Or WS_MAXIMIZEBOX)

% TRANSPARENT    = 1
% OPAQUE         = 2
% PM_REMOVE      = 1
% PM_NOREMOVE    = 0
% PM_NOYIELD     = 2
% NULL_BRUSH     = 5

% ES_SUNKEN = 0x4000
% ES_MULTILINE = 0x4 
% ES_WANTRETURN = 0x1000 
% ES_AUTOVSCROLL = 0x40 
% ES_AUTOHSCROLL = 0x80 

' Listbox messages
% LB_ADDSTRING = 0x180
% LB_INSERTSTRING = 0x181
% LB_DELETESTRING = 0x182
% LB_SELITEMRANGEEX = 0x183
% LB_RESETCONTENT = 0x184
% LB_SETSEL = 0x185
% LB_SETCURSEL = 0x186
% LB_GETSEL = 0x187
% LB_GETCURSEL = 0x188
% LB_GETTEXT = 0x189
% LB_GETTEXTLEN = 0x18A
% LB_GETCOUNT = 0x18B
% LB_SELECTSTRING = 0x18C
% LB_DIR = 0x18D
% LB_GETTOPINDEX = 0x18E
% LB_FINDSTRING = 0x18F
% LB_GETSELCOUNT = 0x190
% LB_GETSELITEMS = 0x191
% LB_SETTABSTOPS = 0x192
% LB_GETHORIZONTALEXTENT = 0x193
% LB_SETHORIZONTALEXTENT = 0x194
% LB_SETCOLUMNWIDTH = 0x195
% LB_ADDFILE = 0x196
% LB_SETTOPINDEX = 0x197
% LB_GETITEMRECT = 0x198
% LB_GETITEMDATA = 0x199
% LB_SETITEMDATA = 0x19A
% LB_SELITEMRANGE = 0x19B
% LB_SETANCHORINDEX = 0x19C
% LB_GETANCHORINDEX = 0x19D
% LB_SETCARETINDEX = 0x19E
% LB_GETCARETINDEX = 0x19F
% LB_SETITEMHEIGHT = 0x1A0
% LB_GETITEMHEIGHT = 0x1A1
% LB_FINDSTRINGEXACT = 0x1A2
% LB_SETLOCALE = 0x1A5
% LB_GETLOCALE = 0x1A6
% LB_SETCOUNT = 0x1A7
% LB_MSGMAX = 0x1A8
% LBN_DBLCLICK = 2
% CTLISTNOTIFY = 1

'combo constants------------------------------
% CB_INSERTSTRING = 0x14A
% CB_RESETCONTENT = 0x14B
% CB_FINDSTRING = 0x14C
% CB_SELECTSTRING = 0x14D
% CB_SETCURSEL = 0x14E
% CB_SHOWDROPDOWN = 0x14F
% CB_GETITEMDATA = 0x150
% CB_SETITEMDATA = 0x151

'treeview constants -------------------------
% TVS_LINESATROOT = 0x0004
% TVS_HASLINES = 2
% TVS_HASBUTTONS = 0x0001
% TV_FIRST = 0x1100

% TVS_CHECKBOXES = 0x100
% TVM_SETBKCOLOR = (TV_FIRST + 29)
% TVM_SETLINECOLOR = (TV_FIRST + 40)
% TVM_SETTEXTCOLOR = (TV_FIRST + 30)
% TVM_SETITEMA = (TV_FIRST + 13)
% TVM_INSERTITEMW = (TV_FIRST + 50)
% TVM_INSERTITEM = 4352
% TVI_ROOT = 0xFFFF0000
% TVI_LAST = 0xFFFF0002
'..................................
% TVIF_TEXT = 1
% TVIF_HANDLE = 16 
% TVIF_IMAGE = 2 
% TVIF_PARAM = 4
% TVIF_DI_SETITEM = 128
% TVSELECTEDIMAGE = 36
'.................................

TYPE TV_ITEM
      mask           as INT
      hItem          as INT
      state          as INT
      stateMask      as INT
      pszText        as INT
      cchTextMax     as INT
      iImage         as INT
      iSelectedImage as INT
      cChildren      as INT
      lParam         as INT
END TYPE 

TYPE TV_INSERTSTRUCT
      hParent      as INT
      hInsertAfter as INT
      item         as TV_ITEM
END TYPE


'.................................
TYPE NMTREEVIEW 
 hwnd as int 
 idfrom as int 
 code as int 
 action as int 
 omask as int 
 ohitem as int 
 ostate as int 
 ostatemask as int 
 opszText as INT
 occhTextMax as int 
 oiImage as int 
 oiSelectedImage as int 
 ocChildren as int 
 olparam as int 
 oIIntegral as int 
 nmask as int 
 nhitem as int 
 nstate as int 
 nstatemask as int 
 npszText as INT
 ncchTextMax as int 
 niImage as int 
 niSelectedImage as int 
 ncChildren as int 
 nlparam as int 
 nIIntegral as int 
End TYPE 

Dim tvi As TV_ITEM
Dim MyNmTV As NMTREEVIEW 

'ListViewControl ----------------------------
INT _lvleft,_lvinit,LV_ITEM
% LVM_INSERTCOLUMN  = 4123
% LVM_INSERTITEM    = 4103
% LVM_SETITEM       = 4102

TYPE ListviewColumn
    cmask as int
    cfmt as int
    ccx as int
    cpszText as int
    ccchTextMax as int 
    ciSubItem as int
END TYPE

TYPE ListviewItem
    mask as int
    iItem as int
    iSubItem as int
    state as int
    stateMask as int
    pszText as int
    cchTextMax as int
    iImage as int
    lParam as int
END TYPE

DIM LV_COLUMN as ListviewColumn
DIM LV_ITEM as ListviewItem

'tabControl constants-------------------------
% TCM_FIRST = 0x1300
% TCM_SETITEM = (TCM_FIRST + 6)
% TCM_GETITEM = 4869
% TCM_GETITEMCOUNT = 4868
% TCM_DELETEITEM = (TCM_FIRST + 8)
% TCM_INSERTITEM = 0x1307
% TCM_SETCURFOCUS = 0x1330 
% TCN_FIRST = -550
% TCN_SELCHANGE = -551
% TCN_SELCHANGING = -552
% TCM_GETCURSEL = 4875
% TCM_SETCURSEL = 0x130C 
% TCIF_TEXT=1
% TCS_HOTTRACK = 0x40
 
TYPE TC_ITEM 
 mask as int 
 res1 as int 
 res2 as int 
 pszText as INT 
 cchTextMax as int 
 iImage as int 
 lParam as int 
End TYPE

'toolbar constants / structures.....................................

TYPE INITCOMMONCONTROLSEX_TYPE
  DWORD dwSize
  DWORD dwICC
End TYPE

'tooltips constants .................................................
% TB_SETTOOLTIPS = 1060
% EBTOOLTIPS = 256
% TBSTYLE_TOOLTIPS = &H100
% TBSETTIP = 9
% TTS_ALWAYSTIP = &H1
% TTS_NOPREFIX = &H2
% TTS_BALLOON = &H40 ' comctl32.dll v5.8 require
% TTM_ACTIVATE = WM_USER+1

% TTM_ADDTOOL = (WM_USER + 4)
% TTM_DELTOOL = (WM_USER + 5)
% TTM_NEWTOOLRECT = (WM_USER + 6)
% TTM_GETTOOLINFO = (WM_USER + 8)
% TTM_SETTIPBKCOLOR = (WM_USER + 19)
% TTM_SETTIPTEXTCOLOR = (WM_USER + 20)
% TTM_SETMAXTIPWIDTH = (WM_USER + 24)
% TTM_UPDATETIPTEXT  = 1036
% TTDT_AUTOPOP = 2
% TTDT_INITIAL = 3

% TTF_IDISHWND = &H1
% TTF_CENTERTIP = &H2
% TTF_SUBCLASS = &H10

 Type TOOLINFO
    cbSize      As int
    uFlags      As int
    hWnd        As int
    uId         As int
    cRect       As RECT
    hinst       As int
    lpszText    As INT
End Type

'trackbar constants'''''''''''''''''''''''''''''
% TBM_SETPAGESIZE = 1045
% TBM_SETRANGEMIN = 1031
% TBM_SETRANGEMAX = 1032
% TBM_SETPOS = 1029
% TRACKBARNORMAL = 1409351681

'..............................................
% CCS_ADJUSTABLE  = 32
% CCS_NODIVIDER   = 64
% TBSTYLE_FLAT    = &H800
% TB_ADDBUTTONS   = WM_USER + 21
% TB_SETIMAGELIST = 1072
% TB_ADDBITMAP    = 1043
% TB_AUTOSIZE     = 1057
'..............................................
TYPE TBBUTTON
	iBitmap		as int
	idCommand	as int
	fsState       as byte
	fsStyle       as byte
     bReserved[1]	as byte
     bReserved[1] as byte 
	dwData		as dword
    iString       as int
End TYPE

'statusbar constants
% SBARS_SIZEGRIP = 0x100

'----------------------------------------------
Def FW_BOLD       700
Def FW_LIGHT      300
Def FW_HEAVY      900
Def FW_NORMAL     400
Def FW_DONTCARE   0
Def FW_EXTRABOLD  800
Def FW_EXTRALIGHT 200
Def FW_HEAVY      900
Def FW_LIGHT      300
Def FW_MEDIUM     500
Def FW_SEMIBOLD   600
Def FW_THIN       100

% WHITE_BRUSH    = 0
% BLACK_BRUSH    = 4
% LTGRAY_BRUSH = 0xC0C0C0
% LTGRBL_BRUSH = 0xDCDCCE

% vk_LBUTTON  = &H1	
% vk_RBUTTON  = &H2 
% vk_MBUTTON  = &H4
% vk_BACK     = &H8
% vk_TAB      = &H9 
% vk_CLEAR    = &HC 
% vk_RETURN   = &HD 
% vk_SHIFT    = &H10 
% vk_CONTROL  = &H11 
% vk_MENU     = &H12 
% vk_PAUSE    = &H13 
% vk_CAPITAL  = &H14 
% vk_ESCAPE   = &H1B 
% vk_SPACE    = &H20 
% vk_PRIOR    = &H21 
% vk_NEXT     = &H22 
% vk_END      = &H23 
% vk_HOME     = &H24 
% vk_LEFT     = &H25 
% vk_UP       = &H26 
% vk_RIGHT    = &H27 
% vk_DOWN     = &H28 
% vk_PRINT    = &H2A 
% vk_SNAPSHOT = &H2C	 
% vk_INSERT   = &H2D 
% vk_DELETE   = &H2E 
% vk_HELP     = &H2F 
% vk_0 = &H30 
% vk_1 = &H31 
% vk_2 = &H32 
% vk_3 = &H33 
% vk_4 = &H34 
% vk_5 = &H35
% vk_6 = &H36 
% vk_7 = &H37 
% vk_8 = &H38 
% vk_9 = &H39 
% vk_@ = &H40
% vk_A = &H41 
% vk_B = &H42 
% vk_C = &H43 
% vk_D = &H44 
% vk_E = &H45 
% vk_F = &H46 
% vk_G = &H47 
% vk_H = &H48 
% vk_I = &H49 
% vk_J = &H4A 
% vk_K = &H4B
% vk_L = &H4C 
% vk_M = &H4D 
% vk_N = &H4E 
% vk_O = &H4F 
% vk_P = &H50 
% vk_Q = &H51 
% vk_R = &H52 
% vk_S = &H53 
% vk_T = &H54 
% vk_U = &H55 
% vk_V = &H56 
% vk_W = &H57 
% vk_X = &H58 
% vk_Y = &H59 
% vk_Z = &H5A 
% vk_F1  = &H70 
% vk_F2  = &H71 
% vk_F3  = &H72 
% vk_F4  = &H73 
% vk_F5  = &H74 
% vk_F6  = &H75 
% vk_F7  = &H76 
% vk_F8  = &H77 
% vk_F9  = &H78 
% vk_F10 = &H79 
% vk_F11 = &H7A 
% vk_F12 = &H7B 
% vk_NUMLOCK    = &H90 
% vk_OEM_SCROLL = &H91	 
% vk_LSHIFT     = &HA0 
% vk_RSHIFT     = &HA1 
% vk_LCONTR     = &HA2	 
% vk_RCONTROL   = &HA3
	


'kernel32 = LoadLibrary "kernel32.dll"
Dim user32 as int   = LoadLibrary "user32.dll"
'gdi32    = LoadLibrary "gdi32.dll"
'dim riched32 as int =  LoadLibrary "riched32.dll"
dim riched32 as int =  LoadLibrary "riched20.dll"
dim comctl32 as int = LoadLibrary "comctl32.dll"
'comdialog32 =  LoadLibrary "comdlg32.dll"

' I am forced to use bind user32 () because standard way of SendMessage declaration NOT work like in most compilers!
bind user32
( 
SendMessage SendMessageA
)
'///  KERNEL32.DLL   /////////
Declare Function LoadLibrary Lib "kernel32.dll" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long
Declare Function GetModuleHandle  Lib "kernel32.dll" Alias "GetModuleHandleA" (INT lpModuleName) as Long
Declare Function GetCurrentDir Lib "kernel32.dll" Alias "GetCurrentDirectoryA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
'same function as above with shorter name
Declare Function GetThisFolder Lib "kernel32.dll" Alias "GetCurrentDirectoryA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long 
Declare Function ExitProcess Lib "kernel32.dll" Alias "ExitProcess" (ByVal uExitCode As Long)
Declare Function GetTickCount Lib "kernel32.dll" () As Long
Declare Sub Sleep Lib "kernel32.dll" Alias "Sleep" (ByVal dwMilliseconds As Long) 
 
Declare Function GetCurrentDir Lib "kernel32.dll" Alias "GetCurrentDirectoryA" (ByVal nBufferLength As Long, ByVal lpPathName As Long) As Long
Declare Function GetTempPath Lib "kernel32.dll" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Declare Function lstrcmpi Lib "kernel32.dll" Alias "lstrcmpiA" (ByVal lpString1 As String, ByVal lpString2 As String) As Long
Declare Function GetCommandLine Lib "kernel32.dll" Alias "GetCommandLineA" () as String
Declare Function QueryPerformanceCounter   Lib "kernel32.dll" (ByRef lpPerformanceCount As LARGE_INTEGER) As Long
Declare Function QueryPerformanceFrequency Lib "kernel32.dll" (ByRef lpFrequency As LARGE_INTEGER) As Long

'///  USER32.DLL  //////////////
Declare Function CreateWindowEx Lib "user32.dll" Alias "CreateWindowExA"(ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, ByRef lpParam As Long) As Long
Declare Function RegisterClassEx Lib "user32.dll" Alias "RegisterClassExA" (byref pcWndClassEx As WNDCLASSEX) As Long
Declare Function DefWindowProc Lib "user32.dll" Alias "DefWindowProcA" (ByVal hWnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Declare Function ShowWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long
Declare Function UpdateWindow  Lib "user32.dll" (ByVal hwnd AS Long) As Long
Declare Function DestroyWindow Lib "user32.dll" (ByVal hwnd As Long) As Long
Declare Function LoadCursor Lib "user32.dll" Alias "LoadCursorA" (ByVal hinstance As Long, ByVal lpCursorName As Long) As Long
Declare Function LoadIcon Lib "user32.dll" Alias "LoadIconA" (ByVal hinstance As Long, ByVal lpIconName As long) As Long
Declare Function MessageBox Lib "user32.dll" Alias "MessageBoxA" (ByVal hWnd As INT, ByVal lpText As String, ByVal lpCaption As String, ByVal dwType As INT) As INT
'sendMessage not work in include file properly!
'!SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hWnd As INT, ByVal dwMsg As INT, ByVal wParam As INT, lParam As Long) As INT

' GET Message
Declare Function GetMessage Lib "user32.dll" Alias "GetMessageA" ( lpMsg As MSG, ByVal hwnd As Long, ByVal wMsgFilterMin As Long, ByVal wMsgFilterMax As Long) As Long
Declare Function PeekMessage Lib "user32.dll" Alias "PeekMessageA" (lpMsg As MSG, ByVal hwnd As Long, ByVal wMsgFilterMin As INT, ByVal wMsgFilterMax As Long, ByVal wRemoveMsg As Long) As Long
Declare Function TranslateMessage Lib "user32.dll" (byRef lpMsg As MSG) As Long

Declare Function DispatchMessage Lib "user32.dll" Alias "DispatchMessageA" (byRef lpMsg As MSG) As Long
Declare Sub PostQuitMessage Lib "user32.dll" (ByVal nExitCode As Long)
! PostMessage Lib "user32.dll" Alias "PostMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

Declare Function SetForegroundWindow Lib "user32.dll" (ByVal hwnd As Long) As Long
Declare Function GetForegroundWindow Lib "user32.dll" () As Long
Declare Function SetWindowText Lib "user32.dll" Alias "SetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String) As Long
Declare Function GetParent Lib "user32.dll" (ByVal hWnd As Long) As Long

Declare Function GetWindowRect Lib "user32.dll" (ByVal hwnd As Long, lpRect As RECT) As Long
Declare Function SetWindowPos Lib "user32.dll"(hwnd AS INT,hWndInsertAfter AS INT,x AS INT,y AS INT,cx AS INT,cy AS INT,wFlags AS INT) As INT
Declare Function MoveWindow Lib "user32.dll" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Declare Function GetFocus   Lib "user32.dll" () As Long
Declare Function SetFocus   Lib "user32.dll" (ByVal hwnd As INT) As INT
Declare Function GetSysColor Lib "user32.dll" (ByVal nIndex As INT) As INT
Declare Function LoadImage Lib "user32.dll" Alias "LoadImageA" (ByVal hInst As Long, ByVal lpsz As String, ByVal dwType As Long, ByVal dwWidth As Long, ByVal dwHeight As Long, ByVal dwFlags As Long) As Long
Declare Function FillRect Lib "user32.dll" (ByVal hdc As Long, lpRect As RECT, ByVal hBrush As Long) As Long
Declare Function GetClientRect Lib "user32.dll" (ByVal hwnd As INT, ByRef lpRect As RECT) As Long
! InvalidateRect Lib "user32.dll" (ByVal hWnd As Long,ByVal lpRect As Long, ByVal bErase As Long) As Long 
Declare Sub ValidateRect Lib "user32.dll" (ByVal hwnd As Long, ByVal t As Long) 
Declare Function ReleaseDC Lib "user32.dll" (ByVal hWnd As Long, ByVal hdc As Long) As Long
Declare Function GetDC Lib "user32.dll" (ByVal hWnd As Long) As Long
Declare Function BeginPaint Lib "user32.dll" (ByVal hwnd As Long, lpPaint As PAINTSTRUCT) As Long
Declare Function EndPaint Lib "user32.dll" (ByVal hwnd As Long, lpPaint As PAINTSTRUCT) As Long
Declare Function GetCursorPos   Lib "user32.dll" (lpPoint As POINTAPI) As Long
Declare Function SetCapture     Lib "user32.dll" (ByVal hWnd As Long) As Long
Declare Function ReleaseCapture Lib "user32.dll" () As Long
Declare Function ScreenToClient Lib "user32.dll" (ByVal hWnd As Long, lpPoint As POINTAPI) As Long
Declare Function ShowCursor Lib "user32.dll" (ByVal bShow As Long) As Long
Declare Function GetAsyncKeyState Lib "user32.dll" (ByVal vKey As Long) As Integer

'/// GDI32.DLL  //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
Declare Function GetPixel   Lib "gdi32.dll" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long) As Long
Declare Function CreateHatchBrush Lib "gdi32.dll" (ByVal nIndex As Long, ByVal crColor As Long) As Long
Declare Function CreatePen Lib "gdi32.dll" Alias "CreatePen" (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long
Declare Function MoveToEx Lib "gdi32.dll" (ByVal hdc As INT, ByVal x As Long, ByVal y As Long, ByRef lpPoint As POINTAPI) As Long
Declare Function LineTo   Lib "gdi32.dll" (ByVal hdc As INT, ByVal x As Long, ByVal y As Long) As Long
Declare Function Ellipse Lib "gdi32.dll" (ByVal hdc As Long, ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
Declare Function SetPixel   Lib "gdi32.dll" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long
Declare Function SetPixelV  Lib "gdi32.dll" (ByVal hdc As INT, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long
Declare Function Rectangle  Lib "gdi32.dll" (ByVal hdc As Long, ByVal x1 As Long, ByVal y1 As Long, ByVal x2 As Long, ByVal y2 As Long) As Long
Declare Function TextOut    Lib "gdi32.dll" Alias "TextOutA" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal lpString As String, ByVal nCount As Long) As Long
Declare Function DeleteDC   Lib "gdi32.dll" (ByVal hdc As Long) As Long
Declare Function PatBlt     Lib "gdi32.dll" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dwRop As Long) As Long
Declare Function SetBkColor Lib "gdi32.dll" (ByVal hdc As Long, ByVal crColor As Long) As Long
Declare Function SetBkMode Lib "gdi32.dll"  (ByVal hDC As Long, ByVal nBkMode As Long) As Long

Declare Function BitBlt     Lib "gdi32.dll" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Declare Function CreateFont Lib "gdi32.dll" Alias "CreateFontA" (ByVal H As Long, ByVal W As Long, ByVal E As Long, ByVal O As Long, ByVal W As Long, ByVal I As Long, ByVal u As Long, ByVal S As Long, ByVal C As Long, ByVal OP As Long, ByVal CP As Long, ByVal Q As Long, ByVal PAF As Long, ByVal F As String) As Long

Declare Function GetObject  Lib "gdi32.dll" Alias "GetObjectA" (ByVal hObject As Long, ByVal nCount As Long, ByRef lpObject As Any) As Long
Declare Function SelectObject  Lib "gdi32.dll" (ByVal shdc As Long, ByVal hObject As Long) As Long
Declare Function DeleteObject  Lib "gdi32.dll" (ByVal hObject As Long) As Long
Declare Function SetTextColor  Lib "gdi32.dll" (ByVal hdc As Long, ByVal crColor As Long) As Long
Declare Function FloodFill Lib "gdi32.dll" Alias "FloodFill" (ByVal hdc As Integer, ByVal x As Integer, ByVal y As Integer, ByVal crColor As Integer) As Integer
Declare Function ExtFloodFill Lib "gdi32.dll" Alias "ExtFloodFill" (ByVal hdc As Integer, ByVal x As Integer, ByVal y As Integer, ByVal crColor As Integer, ByVal wFillType As Integer) As Integer
Declare Function CreateCompatibleBitmap    Lib "gdi32.dll" (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Declare Function CreateCompatibleDC        Lib "gdi32.dll" (ByVal hdc As Long) As Long
Declare Function SetForegroundWindow       Lib "user32.dll" (ByVal hwnd As Long) As Long
Declare Function GetStockObject Lib "gdi32.dll" (ByVal nIndex As Long) As Long
Declare Function CreateSolidBrush Lib "gdi32.dll" (ByVal crColor As Long) As Long
Declare Function TransparentBlt   Lib "msimg32.dll" (ByVal hdc As sys, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As sys, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal crTransparent As Long) As Long


'-------------------------------------------------------------------------------------------------------------------------
'//// COMDLG.DLL  ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
Declare Function GetOpenFileName  Lib "comdlg32.dll" Alias "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long
Declare Function GetSaveFileName  Lib "comdlg32.dll" Alias "GetSaveFileNameA" (pOpenfilename As OPENFILENAME) As Long

'//// SHELL32.DLL  //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
! ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

'///  COMCTL32.DLL  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
Declare Function InitCommonControlsEx Lib "comctl32.dll" (icc As INITCOMMONCONTROLSEX_TYPE) As int
Declare Function ImageList_Create Lib "comctl32.dll" (byval cx as int,byval cy as int,byval flags as int,byval cInitial as int,byval cGrow as int) as int
Declare Function ImageList_Add Lib "comctl32.dll" (ByVal cx As Int, ByVal cy As Int ByVal flags As uint, ByVal cInitial as Int, ByVal cGrow as Int) As int
Declare Function ImageList_AddMasked Lib "comctl32.dll" (byval hImageList as int,byval hBitmap as int,byval crMask as int) as int
Declare Function ImageList_AddIcon Lib "comctl32.dll" (ByVal himl As Long, ByVal hIcon As Long) As Long

'-----------------------------------------------------------------------------------------------------------------------------------------------
'/// WINMM.DLL ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
Declare Function PlaySound  Lib "winmm.dll" Alias "PlaySoundA" (ByVal lpszName As String, ByVal hModule As Long, ByVal dwFlags As Long) As Long
Declare Function timeGetTime  Lib "winmm.dll" () As Long
'------------------------------------------------------------------------------------------------------------------------------------------------
'Menu declarations
Declare Function CreatePopupMenu Lib "user32.dll" () As INT 
Declare Function CreateMenu      Lib "user32.dll" () As INT 
Declare Function GetMenu         Lib "user32.dll" (ByVal hwnd As INT) As INT 
Declare Function SetMenu         Lib "user32.dll" (ByVal hwnd As INT, ByVal hMenu As INT) As INT 
Declare Function AppendMenu      Lib "user32.dll" Alias "AppendMenuA" (ByVal hMenu As INT, ByVal wFlags As INT, ByVal wIDNewItem As INT, ByVal lpNewItem As Any) As INT 
Declare Function DrawMenuBar     Lib "user32.dll" (ByVal hwnd As INT) As INT 
Declare Function DeleteMenu      Lib "user32.dll" (ByVal hMenu As INT, ByVal nPosition As INT, ByVal wFlags As INT) As INT 
Declare Function DestroyMenu     Lib "user32.dll" (ByVal hMenu As INT) As INT 
Declare Function TrackPopupMenu  Lib "user32.dll" (ByVal hMenu As INT, ByVal wFlags As INT, ByVal x As INT, ByVal y As INT, ByVal nReserved As INT, ByVal hwnd As INT, lprc As RECT) As INT
! SetMenuItemBitmaps Lib "user32.dll" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long, ByVal hBitmapUnchecked As Long, ByVal hBitmapChecked As Long) As Long 

'timer functions
Declare Function SetTimer Lib "user32.dll" (ByVal hWnd As Long, ByVal nIDEvent As Long, ByVal uElapse As Long, ByVal lpTimerFunc As Long) As Long
Declare Function KillTimer Lib "user32.dll" (ByVal hWnd As Long, ByVal nIDEvent As Long) As Long

' AWINH declared function - to avoid #lookahed ================================================================================================
'dim WndProc as sys
! HiWord (byval hi as INT) as INT
! LoWord (byval lo as INT) as INT
! ControlFont (byval hwnd as INT,byval height As INT, byval width As INT, byval flag As INT,byval fontname As string)
! SetText (byval hwnd as int,byval stext as string)
! GetText (byval hwnd as int) as String
! SetRichEditBackColor(byval _Rhwnd as int, byval _backcolor as int)
! SetWindow (byval wcaption as string ,byval Wx as int,byval Wy as int, byval Ww as int, byval Wh as int, byval wparent as int, byval style as int) as int
! Wait()
! CloseWindow(byval wnd as INT) as INT
Declare Sub EndProgram()
Declare Sub GetSize(byval hnd as INT,byref hndx as INT,byref hndy as INT,byref hndw as INT,byref hndh as INT)
Declare Sub SetSize(byval hnd as INT,byval hndx as INT,byval hndy as INT,byval hndw as INT,byval hndh as INT)

! SetButton       (byval _bhwnd as int,byval _bx as int,byval _by as int,byval _bw as int,byval _bh as int, byval _btext as string,byval _bflag as int,byval _ext as int,byval _cID as INT) as int
! SetEditBox      (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
! SetListView     (byval lvhwnd as int,byval lvx as int,byval lvy as int,byval lvw as int ,byval lvh as int,byval lvstring as string,byval lvcwidth as int,byval lvflag as int,byval _ex as int,byval _cID as INT) As INT
! SetListBox      (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
! SetStatic       (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
! SetRichEdit     (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
! SetProgressBar  (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int,byval _emin as int,byval _emax as int,byval _epos as int,byval _eflag as int,byval _ext as int,byval cID as INT)
Declare Sub PBSetPos (byval _hpb as int,byval _pbpos as int)
! SetRadioButton  (byval _bhwnd as int,byval _bx as int,byval _by as int,byval _bw as int,byval _bh as int, byval _btext as string,byval _bflag as int,byval _ext as int,byval _cID as INT) as int
! SetCheckBox     (byval _bhwnd as int,byval _bx as int,byval _by as int,byval _bw as int,byval _bh as int, byval _btext as string,byval _bflag as int,byval _ext as int,byval _cID as INT) as int
! SetComboBox     (byval _cbhwnd as int,byval _cbx as int,byval _cby as int,byval _cbw as int,byval _cbh as int, byval _cbtext as string,byval _cbflag as int,byval _ext as int,byval _cID as INT) as int
! AddCBItem       (byval _cbh as INT,byval _cbpos as INT,byval _cbstring as string) as iNT
! SetTreeView     (byval _tvhwnd as INT,byval _tvx as INT,byval _tvy as INT,byval _tvw as INT,_tvh,byval tvflag as INT,byval _tvextend as INT,byval _cID as INT) as INT

! TVInsertItem    (byval hTree as INT ,byval tvPos as INT,byval itemText as string,byval hImg as INT,byval tvselect as INT ) as INT
! SetTabControl  (byval _tbhwnd as INT,byval _tx as INT,byval _ty as INT,byval _tw as INT,byval _th as INT,byval _tbflag as INT,byval _ex as INT,byval cID as INT) As INT
! AddTab         (byval hwnd as INT ,byval tbpos as INT,byval tbtext as String ) as INT
! SetTabText     (byval cntID as INT,byval tbIndex as INT,byval tabText as String)
Declare SUB SetSelectedTab (byval cntID as INT,byval index as INT)
! GetSelectedTab (byval cntID as INT) as INT
! GetTabText    (byval cntID as INT,byval tbIndex as INT) as String
! GetTabCount   (byval cntID as INT) as INT
! DeleteTab     (byval cntID as INT,byval index as INT ) as INT
! SetToolbar    (byval _tbhwnd as INT,byval _tbflag as INT,byval _ex as INT,byval cID as INT) As INT
! SetToolTip    (byval _tthwnd as INT) As INT
! SetStatusBar  (byval shwnd as INT,byval stext as STRING,byval sflag as INT,byval ex as INT) as INT
! SetTrackBar   (byval thwnd as INT,byval tex as INT,byval tey as INT,byval tew as INT,byval teh as INT,byval temin INT,byval temax as INT,byval tepage as INT,byval tepos as INT,byval teflag as INT,byval text as INT,byval ttID as INT) as INT
! GetTrackPos   (byval wnd as INT) as INT
! Randomize()
! RGB(byval red as INT,byval green as INT,byval blue as INT) as INT
! Rand(byval z1 as INT, byval z2 as INT) as INT
! Key(byval cKey As INT) As INT
! EscKey() As INT
! MsgBox(byval lpText AS STRING,byval lpCaption AS STRING) as INT
! Info(byval lpText As String) as int
! Replace    (byref t as string,byref w as string,byref r as string) as string
! FileDialog(byval Dir As String,byval filter as String ,byval Title as String ,byval Hwnd as INT,byval Flags as INT,byref defext as INT) As String

DECLARE SUB InitDrawing(byval wnd as INT)
DECLARE SUB FillSolidRect(wID as INT, x As Long, Y As Long, cx As Long, cy As Long, bbColor as INT)
DECLARE SUB WindowColor(byval wID as INT,byval wr as INT,byval wg as INT,byval wb as INT)


' END of AWINH functions =====================================================================================================================
Def INT_Red   1
Def INT_Green 2
Def INT_Blue  4
Def INT_BLACK &h101010
Def INT_WHITE &hE0E0E0
Dim INT_Seed  As Long

TYPE TBADDBITMAP
     INT hInst
     INT nID
End TYPE 

'define Msg,Class & ClassEx //////////////////////////////////
Dim wm as MSG
Dim rc as RECT
Dim wcx as WNDCLASSEX
INT INT_hwnd 


'/////////////////////////////////////////////////////////////

INT bHnd,bHdc
INT hbrush

Dim controlID As INT
Dim notifyCode As INT
'Controls handler {{{{{{{{{{{{{{{{{{{{{{{
Dim hButton     As INT
Dim hEdit       As INT
Dim hRichEdit   As INT
Dim hScrollBar  As INT
Dim hListbox    As INT
Dim hCombobox   As INT
Dim hListView   As INT
Dim hStatic     As INT
Dim hStatus     as INT
Dim hProgress   As INT
Dim hTreeView   As INT
Dim hTabControl As INT
Dim hTBControl  As INT
Dim hTTControl  As INT
Dim hTrackBar   As INT
'}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}
STRING ClassName = "Oxygen"
Dim AscKey as INT

'GLOBALS for drawing to DC (((((((((((((((((((((((((((((((((((((((((((((((((((( 
INT hdc, hdcMem, hbmMem,   oldBmp, oldBrush, oldPen, oldFont, fColor,bColor
INT textX,textY,hBrush
INT ww,hh
')))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))

'--------------------------------------------
MACRO Default
DefWindowProc hwnd,wMsg,wParam,lParam
End MACRO
'---------------------------------------------
Macro RightS(s,i)
Mid(s,(-i))
End macro
'--------------------------------------------
Function HiWord (byval hi as long) as long
shr hi,16 : function=hi
End Function
'---------------------------------------------
Function LoWord (byval lo as long) as long
And lo,&hffff : function=lo
End Function
'----------------------------------------------------------------

'=========================================================================================================
Function ControlFont ( byval hwnd as long,byval height As Long, byval width As long, byval flag As Long,byval fontname As string)  
int hFont
hFont = CreateFont( height,width,0,0,flag,0,0,0,1,0,0,0,2,fontname)
'CreateFont(_fsize,0,0,0,_ff,_fi,_fu,_fs,1,0,0,0,2,_fname)
SendMessage hwnd,WM_SETFONT,hfont,1
End Function
'----------------------------------------------------------------------
Function SetText (byval hwnd as int,byval stext as string)
SendMessage hwnd,WM_SETTEXT,0,strptr(stext)
UpdateWindow hwnd
End Function
'-------------------------------------------------------------------
Function GetText (byval hwnd as int) as string
char display[255]=""
SendMessage hwnd,WM_GETTEXT,255, display
Return display 
End Function
'====================================================================================================
Function SetRichEditBackColor(byval _ehwnd as int, byval _ecolor as int)
  SendMessage(_ehwnd, 1091,0,_ecolor) 'EM_SETBKGNDCOLOR=1091
End Function
'=====================================================================================================

Function SetWindow (byval caption as string ,byval Wx as int,byval Wy as int, byval Ww as int, byval Wh as int, byval wparent as int, byval style as int) as int
int inst = GetModuleHandle 0
int reg
wcx.cbSize        = SizeOf(WNDCLASSEX)
wcx.style         = CS_DBLCLKS | CS_OWNDC 
wcx.lpfnWndProc   = &WndProc
wcx.cbClsExtra    = 0
wcx.cbWndExtra    = 0
wcx.hInstance     = inst
wcx.hIcon         = LoadIcon 0,IDI_APPLICATION        
wcx.hCursor       = LoadCursor 0,IDC_ARROW       
wcx.hbrBackground = CreateSolidBrush(GetSysColor(15))
wcx.lpszMenuName  = strptr ""
wcx.lpszClassName = strptr ClassName
wcx.hIconSm       = LoadIcon 0,IDI_APPLICATION 

reg = RegisterClassEx(wcx)
'print "REGISTRED:" + str reg

'create window -------------------------------------------------------------------------------------
INT_hwnd = CreateWindowEx 0, ClassName, caption, style, Wx, Wy, Ww, Wh, wparent, 0, inst, 0
'---------------------------------------------------------------------------------------------------
'IF style <> WS_HIDDEN
ShowWindow INT_hwnd, SW_SHOW
'END IF
UpdateWindow INT_hwnd
'INT_hdc = GetDC(INT_hwnd)
'bHnd = CreateCompatibleBitmap(INT_hdc,ww,wh)
'bHdc = CreateCompatibleDC(INT_hdc)
'SelectObject bHdc, bHnd
'Width = ww
'Height= wh
INT_Seed = timeGetTime
'QueryPerformanceFrequency INT_qf
'QueryPerformanceCounter   INT_qc1
'print "WINDOW:" + Str(INT_hwnd)
Function = INT_hwnd
End Function

'- Msg Loop -----------------------------------------------------------------------------------
Function Wait()

  'INT _message
  While GetMessage(wm,0,0,0) <> 0
'   _message = wm
     Translatemessage wm
     DispatchMessage wm   
  Wend
  
End Function

'----------------------------------------------------------------------------------------------
Function CloseWindow(wnd as INT) as INT
DestroyWindow wnd
'PostQuitMessage 0
Return wnd=0
End Function

'----------------------------------------------------------------------------------------------
Sub EndProgram
PostQuitMessage 0
ExitProcess 0
End Sub

'GetClientsize --------------------------------------------------------------------------------
SUB GetSize(byval hnd as INT,byref hndx as INT,byref hndy as INT,byref hndw as INT,byref hndh as INT)
GetClientRect(hnd,rc)
'hndx=0:hndy=0:hndw=0:hndh=0
hndx = rc.left
hndy = rc.top
hndw = rc.right
hndh = rc.bottom

End SUB

'SetSize() --------------------------------------------------------------------------------------
SUB SetSize(byval hnd as INT,byval hndx as INT,byval hndy as INT,byval hndw as INT,byval hndh as INT)
INT sdata[4]
'print "HNDX:" + str(hndx)
sdata[0]=hndx
sdata[1]=hndy
sdata[2]=hndw
sdata[3]=hndh
'SetWindowPos(hnd,0,sdata[0],sdata[1],sdata[2],sdata[3],0)
MoveWindow(hnd, hndx, hndy, hndw, hndh,1)

End SUB
'===============================================================================================
'syn : SetButton (hwnd,x,y,w,h,caption$,style,ext,controlID)
Function SetButton(byval _bhwnd as int,byval _bx as int,byval _by as int,byval _bw as int,byval _bh as int, byval _btext as string,byval _bflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
If _bflag=0
    _bflag = 0x50000000
EndIf
_ext = 0
hButton = CreateWindowEx(_ext,"BUTTON",_btext,_bflag,_bx,_by,_bw,_bh,_bhwnd,_cID,0,0)
_hfont = GetStockObject(17)
SendMessage hButton,WM_SETFONT,_hfont,0
UpdateWindow _bhwnd
Function = hButton
End Function
'==============================================================================================
Function IconButton(byval _bhwnd as int,byval _bx as int,byval _by as int,byval _bw as int,byval _bh as int, byval _ibicon as int,byval _bflag as int,byval _ext as int,byval _cID as INT) as int
INT _iconButton
If _bflag=0
    _bflag = 1409351744
EndIf
_ext = 0
_iconButton = CreateWindowEx(_ext,"BUTTON",_ibicon,_bflag,_bx,_by,_bw,_bh,_bhwnd,_cID,0,0)
SendMessage( _iconButton , 247, 1, _ibicon)
'UpdateWindow _bhwnd
Function = _iconButton
End Function



'===============================================================================================
'syn : SetEditBox (hwnd,x,y,w,h,caption$,style,ext)
Function SetEditBox(byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
If _eflag=0
    _eflag = 0x50800000
EndIf
hEdit = CreateWindowEx(_ext,"EDIT",_etext,_eflag,_ex,_ey,_ew,_eh,_ehwnd,_cID,0,0)
_hfont = GetStockObject(17)
SendMessage hEdit,WM_SETFONT,_hfont,0
UpdateWindow _ehwnd
Function = hEdit
End Function

'===============================================================================================
Function SetListBox (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
If _eflag=0
    _eflag = 0x50A00140 Or CTLISTNOTIFY
EndIf
hListbox = CreateWindowEx(_ext,"LISTBOX",_etext,_eflag,_ex,_ey,_ew,_eh,_ehwnd,_cID,0,0)
_hfont = GetStockObject(17)
SendMessage hListbox,WM_SETFONT,_hfont,0
UpdateWindow _ehwnd
Function = hListbox
End Function

'create ListView ==============================================================================
Function SetListView (byval lvhwnd as int,byval _lvx as int,byval _lvy as int,byval _lvw as int ,byval _lvh as int,byval lvstring as string,byval lvcwidth as int,byval _lvflag as int,byval _ex as int,byval _cID as INT) As INT
'
  If _lvflag=0
   _lvflag = 1409351681 | 8
  End If
  hListView = CreateWindowEx(_ex,"SysListView32","",_lvflag,_lvx,_lvy,_lvw,_lvh,lvhwnd,_cID,0,0)
  LV_COLUMN.cmask       = 7 'LVCF_FMT|LVCF_TEXT|LVCF_WIDTH
  LV_COLUMN.cfmt        = 0 '  LVCFMT_LEFT
  LV_COLUMN.ccx         = lvcwidth
  LV_COLUMN.cpszText    = strptr(lvstring)
  LV_COLUMN.ccchTextMax = sizeof(lvstring)+1
  LV_COLUMN.ciSubItem   = 0
  SendMessage(hListView, LVM_INSERTCOLUMN, 0, LV_COLUMN) ' listview insert column 4123
  'GetAsyncKeyState(VK_LBUTTON)
   UpdateWindow lvhwnd
  Function = hListView
End Function
'-------------------------------------------------------------------------------------
'add list view column  {AddLVC hwnd, pos, width , text, flag}
Function AddListViewColumn (byval _lvhandle as int,byval _lvpos as int,byval _lvcwidth as int,byval lvstring as string,byval _lvflag as INT) as INT
  LV_COLUMN.cmask      = 7
  LV_COLUMN.cfmt       = 0
  LV_COLUMN.ccx        =_lvcwidth
  LV_COLUMN.cpszText   = strptr(lvstring)
  SendMessage( _lvhandle, LVM_INSERTCOLUMN,_lvpos,LV_COLUMN)
End Function
'-----------------------------------------------------------------------------------.
'add listview item {AddLVI hwnd, pos, text, icon}
Function AddListViewItem (byval _lvhandle as int,byval _lvpos as int,byval lvstring as string,byval _lvicon as int) as int
  INT lvflag
  lvflag = 4097 '#LVIF_TEXT|#LVIF_DI_SETITEM
  If _lvicon
    lvflag = 3 '#LVIF_TEXT|#LVIF_IMAGE
  End If
  LV_ITEM.mask      = lvflag
  LV_ITEM.iItem     = _lvpos
  LV_ITEM.iSubItem  = 0
  LV_ITEM.pszText   = strptr(lvstring)
  LV_ITEM.iImage    =_lvicon
  SendMessage(_lvhandle,LVM_INSERTITEM, _lvpos, LV_ITEM) 'list view insert item
End Function
'----------------------------------------------------------------------------------
'add list view sub item
Function AddListViewSubItem (byval _lvhandle as int,byval _lvpos as int,byval _lvsub as int,byval lvstring as string)as INT
  LV_ITEM.mask      = 4097    '#LVIF_TEXT|#LVIF_DI_SETITEM
  LV_ITEM.iItem     = _lvpos
  LV_ITEM.iSubItem  = _lvsub
  LV_ITEM.pszText   = strptr(lvstring)
  SendMessage(_lvhandle, LVM_SETITEM, 0, LV_ITEM)
End Function
'===============================================================================================
Function SetStatic (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
If _eflag=0
    _eflag = 0x5000010B
EndIf
hStatic = CreateWindowEx(_ext,"STATIC",_etext,_eflag,_ex,_ey,_ew,_eh,_ehwnd,_cID,0,0)
_hfont = GetStockObject(17)
SendMessage hStatic,WM_SETFONT,_hfont,0
UpdateWindow _ehwnd
Function = hStatic
End Function

'=====================================================================================
Function SetRichEdit (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int, byval _etext as string,byval _eflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
If _eflag=0
'0x50800080 single , 0x50B010C4 multiline
    _eflag = 0x50800080 Or ES_SUNKEN
EndIf
hRichEdit = CreateWindowEx(_ext,"richedit20A",_etext,_eflag,_ex,_ey,_ew,_eh,_ehwnd,_cID,0,NULL)
_hfont = GetStockObject(17)
'SendMessage hRichEdit,WM_SETFONT,_hfont,0
UpdateWindow _ehwnd
Function = hRichEdit
End Function
'=====================================================================================
'SetProgressbar(hwnd,x,y,w,h,min,max,pos,flag,ext)
Function SetProgressBar (byval _ehwnd as int,byval _ex as int,byval _ey as int,byval _ew as int,byval _eh as int,byval _emin as int,byval _emax as int,byval _epos as int,byval _eflag as int,byval _ext as int,byval cID as INT)
  If _eflag = 0 then
    _eflag=WS_CHILD Or WS_VISIBLE
  End If
  hprogress = CreateWindowEx(_ext,"msctls_progress32","",_eflag,_ex,_ey,_ew,_eh,_ehwnd,cID,0,0)
  'UpdateWindow hprogress
  SendMessage(hprogress,PBM_SETRANGE32,_emin,_emax)
  SendMessage(hprogress,PBM_SETPOS,_epos,0)
   UpdateWindow hprogress
  Return hprogress
End Function
':::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
'Progress SET  POSITION
SUB PBSetPos (byval _hpb as int,byval _pbpos as int)
If _hpb <> 0
SendMessage(_hpb,PBM_SETPOS,_pbpos,0)
UpdateWindow _hpb
End If
End SUB
'=====================================================================================
'syn : SetRadioButton (hwnd,x,y,w,h,caption$,style,ext,controlID)
Function SetRadioButton(byval _bhwnd as int,byval _bx as int,byval _by as int,byval _bw as int,byval _bh as int, byval _btext as string,byval _bflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
If _bflag=0
    _bflag = 0x50000009
End If
_ext = 0
hButton = CreateWindowEx(_ext,"BUTTON",_btext,_bflag,_bx,_by,_bw,_bh,_bhwnd,_cID,0,0)
_hfont = GetStockObject(17)
SendMessage hButton,WM_SETFONT,_hfont,0
UpdateWindow _bhwnd
Function = hButton
End Function
'=====================================================================================
'syn : SetCheckBox (hwnd,x,y,w,h,caption$,style,ext,controlID)
Function SetCheckBox (byval _bhwnd as int,byval _bx as int,byval _by as int,byval _bw as int,byval _bh as int, byval _btext as string,byval _bflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
If _bflag=0
    _bflag = 0x50008003
End If
_ext = 0
hButton = CreateWindowEx(_ext,"BUTTON",_btext,_bflag,_bx,_by,_bw,_bh,_bhwnd,_cID,0,0)
_hfont = GetStockObject(17)
SendMessage hButton,WM_SETFONT,_hfont,0
UpdateWindow _bhwnd
Function = hButton
End Function
'=====================================================================================
Function SetComboBox(byval _cbhwnd as int,byval _cbx as int,byval _cby as int,byval _cbw as int,byval _cbh as int, byval _cbtext as string,byval _cbflag as int,byval _ext as int,byval _cID as INT) as int
INT _hfont
  If _cbflag=0
    _cbflag = 0x50A00603
  EndIf
  hComboBox = CreateWindowEx(_ext,"COMBOBOX",_cbText,_cbflag,_cbx,_cby,_cbw,_cbh,_cbhwnd,_cID,0,0)
_hfont = GetStockObject(17)
SendMessage hComboBox,WM_SETFONT,_hfont,0
UpdateWindow _cbhwnd
Function = hComboBox
End Function
'-------------------------------------------------------------------------------------------------
Function AddCBItem(byval _cbh as INT,byval _cbpos as INT,byval _cbstring as string) as iNT
  Function = SendMessage(_cbh, 330,_cbpos, strptr _cbstring) ' cb_insertString=330
End Function

'=====================================================================================
Function SetTreeView (byval _tvhwnd as INT,byval _tvx as INT,byval _tvy as INT,byval _tvw as INT,_tvh,byval tvflag as INT,byval _tvextend as INT,byval _cID as INT) as INT
  'INT hTreeView
  If tvflag=0
    tvflag= tvflag | WS_CHILD | WS_VISIBLE | TVS_HASLINES | TVS_HASBUTTONS | TVS_LINESATROOT
  End If
  'If _tvinit=0
   ' FirstTreeViewInit()
  'EndIf
 hTreeView  = CreateWindowEx(_tvextend,"SysTreeView32","",tvflag,_tvx,_tvy,_tvw,_tvh,_tvhwnd,_cID,0,0)
UpdateWindow _tvhwnd
  Function = hTreeView
End Function

'-------------------------------------------------------------------------------------
'FN -> InsertItem (hwnd ,tPos, text, img, select)
Function TVInsertItem (byval hTree as INT, byval tvPos as INT, byval tvText as string , byval hImg as INT, byval tvselect as INT ) as INT
INT h
'tvi.mask           = TVIF_TEXT | TVIF_IMAGE | TVSELECTEDIMAGE
tvi.hitem    	     = tvPos
tvi.mask       	= TVIF_TEXT | TVIF_IMAGE | TVSELECTEDIMAGE
tvi.state      	= 0
tvi.statemask  	= 0
tvi.pszText    	= strptr(tvText) 
tvi.cchtextmax    = sizeof(tvText)+1 
tvi.iImage    	= himg
tvi.iSelectedImage = tvselect

h = SendMessage(hTree, 4352, 0, tvi)
'UpdateWindow hTree
Function = h
End function

'=====================================================================================
Function SetTabControl (byval _tbhwnd as INT,byval _tx as INT,byval _ty as INT,byval _tw as INT,byval _th as INT,byval _tbflag as INT,byval _ex as INT,byval cID as INT) As INT
INT _hfont
  If _tbflag=0
    _tbflag=WS_CHILD | WS_VISIBLE| TCS_HOTTRACK
  End If
  
  hTabControl = CreateWindowEx(_ex,"SysTabControl32","",_tbflag,_tx,_ty,_tw,_th,_tbhwnd,cID,0,0)
 _hfont = GetStockObject(17)
 SendMessage hTabControl,WM_SETFONT,_hfont,0
  UpdateWindow _tbhwnd
Function = hTabControl
End Function
'=====================================================================================
'AddTab
Function AddTab (byval hwnd as INT ,byval tbpos as INT,byval tbtext as String ) as INT
TC_ITEM tie
tie.mask=1
tie.pszText= strptr(tbtext)
tie.cchTextMax=Len(tbtext)
tie.iImage = -1
SendMessage(hWnd,0x1307,tbpos,&tie)

End Function
'=====================================================================================
Function SetTabText (cntID as INT,tbIndex as INT,tabText as String)
TC_ITEM tie
tie.mask=1
tie.pszText= strptr(tabText)
tie.cchTextMax=Len(tabtext)
tie.iImage = -1
SendMessage(cntID,TCM_SETITEM,tbIndex,&tie)
Return
End Function

'=====================================================================================
SUB SetSelectedTab (cntID as INT,index as INT)
Sendmessage (cntID,TCM_SETCURSEL,index,0)

'Return tbIndex
End Sub
'=====================================================================================

Function GetSelectedTab (cntID as INT) as INT
INT tbIndex
tbIndex = Sendmessage (cntID,TCM_GETCURSEL,0,0)

Return tbIndex
End Function

'=====================================================================================
Function GetTabText (cntID as INT,tbIndex as INT) as string
string tabText=Space(256)
TC_ITEM tie
tie.mask=1
tie.pszText = strptr tabText
tie.cchTextMax = 256
tie.iImage = -1
Sendmessage (cntID,TCM_GETITEM,tbIndex,&tie)
Return tabText
End Function
'=====================================================================================
Function GetTabCount (cntID as INT) as INT
INT tbCount
tbCount = Sendmessage (cntID,TCM_GETITEMCOUNT,0,0)
Return tbCount
End Function
'=====================================================================================
Function DeleteTab (cntID as INT, index as INT ) as INT
Sendmessage (cntID,TCM_DELETEITEM,index,0)
Return 0
End Function

'=====================================================================================

Function SetToolbar (byval _tbhwnd as INT,byval _tbflag as INT,byval _ex as INT,byval cID as INT) As INT
INT _hfont
INT  TBSTYLES = TBSTYLE_FLAT | WS_CHILD | WS_VISIBLE 
  If _tbflag = 0
    _tbflag = 1342179328 | TBSTYLES |4 | &H100
  Else
   _tbflag=1342179328 | TBSTYLES |4 | _tbflag
  End If
  
  hTBControl = CreateWindowEx(_ex,"TOOLBARWINDOW32","",_tbflag,0,0,0,0,_tbhwnd, cID,0,0)
 _hfont = GetStockObject(17)
 SendMessage hTBControl,WM_SETFONT,_hfont,0
  UpdateWindow _tbhwnd
Function = hTBControl
End Function


'=====================================================================================
'set tooltip control
Function SetToolTip (byval _tthwnd as INT) As INT
INT _hfont


hTTControl = CreateWindowEx(0,"tooltips_class32","", -805306368,0,0,0,0,_tthwnd,0,0,0)
SendMessage( _tthwnd, 1060, hTTControl,0)


Function = hTTControl
End Function

'=====================================================================================
'Statusbar...
Function SetStatusBar (byval shwnd as INT,byval stext as STRING,byval sflag as INT,byval ex as INT) as INT
  If sflag=0
    sflag= 1409286400 
    sflag = WS_CHILD | WS_VISIBLE | SBARS_SIZEGRIP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN
  End If
  hStatus =CreateWindowEx(ex,"msctls_statusbar32",stext,sflag,0,0,0,0,shwnd,0,0,0)
'UpdateWindow shwnd  
  Return hStatus
End Function
'=======================================================================================
'Trackbar...
Function SetTrackBar (byval _thwnd as INT,byval _ex as INT,byval _ey as INT,byval _ew as INT, byval _eh as INT, byval _emin as INT, byval _emax as INT, byval _epage as INT, byval _epos as INT, byval _eflag as INT, byval _ext as INT ,byval _tID as INT) as INT
  
  If _eflag=0
    _eflag = TRACKBARNORMAL |_eflag
  End If
  hTrackbar=CreateWindowEx(_ext,"msctls_trackbar32","",_eflag,_ex,_ey,_ew,_eh,_thwnd,_tID,0,0)
  SendMessage(hTrackbar, TBM_SETPAGESIZE, 0,byval _epage)
  SendMessage(hTrackbar, TBM_SETRANGEMIN, 0,byval _emin )
  SendMessage(hTrackbar, TBM_SETRANGEMAX, 0,byval _emax )
  SendMessage(hTrackbar, TBM_SETPOS,      1,byval _epos )
  Function = hTrackbar
End Function
'---------------------------------------------------------------------------------------
Function GetTrackPos (byval wnd as INT) as INT
INT tpos
  tpos=SendMessage( wnd , 1024,0,0)
Return tpos
End Function


'=====================================================================================
Function Randomize()
INT_Seed = timeGetTime
End Function

'=====================================================================================

Function RGB(byval red as INT,byval green as INT,byval blue as INT) as INT
  INT color
  color = red
  color = color + green*256
  color = color + blue*65536
  Return color
End Function 


'=====================================================================================


Function Rand(byval z1 as INT, byval z2 as INT) as INT
INT rnd 
mov  eax,z2
sub  eax,z1
Inc  eax
imul edx,INT_Seed,0x8088405
Inc  edx
mov  INT_Seed,edx
mul  edx
add  edx,z1
mov  rnd,edx
Function = rnd
End Function



Function Key(byval cKey As INT) As INT
Function = GetAsyncKeyState(cKey)
End Function

Function EscKey() As INT
Function = GetAsyncKeyState(27)
End Function



'MsgBox-------------------------------------------------------------------
Function MsgBox (byval lpText AS STRING,byref lpCaption AS STRING) as INT
If lpCaption = "" then lpCaption="<MsgBox>"
Function =  MessageBox 0, lpText, lpCaption, 0
End Function
'-------------------------------------------------------------------------
Function Info(byval lpText as string) as int
string lpCaption = "INFO"
function =  MessageBox 0, lpText, lpCaption, 0

End Function

'---------------------------------------
Function Replace(byref t as string,byref w as string,byref r as string) as string
  '=======================================
  '
  INT a,b,lw,lr
  string s=t
  '
  lw=Len(w)
  lr=Len(r)
  a=1
  '  
  do
    a=Instr(a,s,w)
    If a=0 then exit do
    s=Left(s,a-1)+r+Mid(s,a+lw)
    a+=lr
  End do
  Return s
End Function
'----------------------------------
Macro Trim(dirty )
  Ltrim(Rtrim(dirty))    
End macro
'---------------------------------------------------------------------------------------
'FileDialog( $ iDir , $ filter ,$ title , % parent ,% flag )
Function FileDialog(byval Dir As String,byval filter as string ,byval Title as string ,byval Hwnd as INT,byval Flags as INT,byref defext as INT) As String
Dim ofn As OPENFILENAME
Dim filename[255] As zstring 
INT retval	
	
ofn.lStructSize = 76
ofn.hwndOwner = hWnd
ofn.hInstance = GetModuleHandle(0)
ofn.lpstrFilter = ?filter
ofn.lpstrCustomFilter= NULL
ofn.nMaxCustFilter = 0
ofn.nFilterIndex = 2
ofn.lpstrFile = @filename 'zstring buffer
ofn.nMaxFile = 255
ofn.lpstrFileTitle = NULL
ofn.nMaxFileTitle = 0
ofn.lpstrInitialDir = ?dir
ofn.lpstrTitle = ?title
If Flags = 0 then ofn.Flags = OFN_EXPLORER Or OFN_FILEMUSTEXIST Or OFN_HIDEREADONLY
If Flags = 1 then ofn.Flags = OFN_EXPLORER Or OFN_OVERWRITEPROMPT Or OFN_HIDEREADONLY
ofn.nFileOffset = 0
ofn.nFileExtension = 0
ofn.lpstrDefExt = ?defext
ofn.lCustData = 0
ofn.lpfnHook = 0
ofn.lpTemplateName = NULL

' Execute the dialog box
If Flags = 0 then retval = GetOpenFileName(ofn)
If Flags = 1 then retval = GetSaveFileName(ofn)
	
Return filename

End Function 

' *****************************************************************************
' *******    I N I T    H D C    D R A W I N G        *************************
' *****************************************************************************
SUB InitDrawing(byval wnd as INT)
'static ww,hh as int
''get current size of window
GetSize(wnd,0,0,ww,hh)
'get window DC
hdc      = GetDC(wnd)
hdcMem   = CreateCompatibleDC(0)
hbmMem   = CreateCompatibleBitmap(hdc,ww,hh)
oldBmp   = SelectObject( hdcMem, hbmMem )
oldBrush = SelectObject(hdcMem, CreateSolidBrush( RGB(231,223,231)) )
oldPen   = SelectObject(hdcMem, CreatePen(PS_SOLID,1,RGB(231,223,231)))
'fill rectangle memDC with brush color
rc.right = ww + 1000
rc.bottom = hh + 1000

FillRect ( hdcMem,rc, oldBrush) 
SetTextColor( hDC,RGB(0,0,0))
SetBkColor( hDC, RGB(231,223,231))
'blit to memDC
BitBlt(hDCmem, 0, 0, ww, hh, hdc, 0, 0, SRCCOPY)
'UpdateWindow wnd
ReleaseDC( wnd, hdc)
End SUB

' set window color =========================================================================
Sub FillSolidRect(wID as INT, x As Long, Y As Long, cx As Long, cy As Long, bbColor as INT) 
    Dim hBr As Long ' rc As RECT 
    hDC=GetDC(wID)
    rc.Left = x 
    rc.Top = Y 
    rc.right = x + cx 
    rc.bottom = Y + cy 
    hBr = CreateSolidBrush(bbColor) 
    FillRect hDC, rc, hBr 

    BitBlt(hdcMem, 0, 0, ww, hh, hdc, 0, 0, SRCCOPY)

    ReleaseDC( wID, hdc) 
End Sub 
'-----------------------------------------------------------------------------------------
SUB WindowColor(byval wID as INT,byval wr as INT,byval wg as INT,byval wb as INT)
INT backColor = RGB (wr,wg,wb)
FillSolidRect(wID,0,0,ww,hh,backColor)
End SUB	
'========================================================================================