'SsArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\SsArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String
    Local a() As String

    Local arr As Long
    Local clone As Long

    arr = SsArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000
    ReDim a(1 To Count)
    For i = 1 To Count
        a(i) = Format$(i, "0000000")
    Next i

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        SsArrAdd arr, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    SsArrClear arr
    SsArrAdd arr, ""
    d = Timer
    For i = 1 To 10000
        SsArrIns arr, 1, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    SsArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        SsArrSet arr, i, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If SsArrGet(arr, i) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    SsArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, SsArrGet(arr, 1)
    ListBox Add CbHndl, lbxID, SsArrGet(arr, 2)
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, SsArrGet(arr, SsArrCount(arr) - 1)
    ListBox Add CbHndl, lbxID, SsArrGet(arr, SsArrCount(arr))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    SsArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, SsArrGet(arr, 1)
    ListBox Add CbHndl, lbxID, SsArrGet(arr, 2)
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, SsArrGet(arr, SsArrCount(arr) - 1)
    ListBox Add CbHndl, lbxID, SsArrGet(arr, SsArrCount(arr))

    'test sort
    For i = 1 To SsArrCount(arr) - 1
        If SsArrGet(arr, i) > SsArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(SsArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If SsArrBinSearch(arr, a(i)) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    SsArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        SsArrBinInsert arr, a(Rnd(1, 5))
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SsArrCount(arr)
        ListBox Add CbHndl, lbxID, SsArrGet(arr, i)
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    SsArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SsArrCount(arr)
        ListBox Add CbHndl, lbxID, SsArrGet(arr, i)
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = SsArrCount(arr) To 1 Step -1
        If Val(SsArrGet(arr, i)) Mod 2 Then SsArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SsArrCount(arr)
        ListBox Add CbHndl, lbxID, SsArrGet(arr, i)
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    SsArrClear arr
    SsArrStkPush arr, a(1)
    SsArrStkPush arr, a(2)
    SsArrStkPush arr, a(3)
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While SsArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + SsArrStkPeek(arr)
        ListBox Add CbHndl, lbxID, "Pop() = " + SsArrStkPop(arr)
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    SsArrClear arr
    SsArrQuePush arr, a(1)
    SsArrQuePush arr, a(2)
    SsArrQuePush arr, a(3)
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While SsArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + SsArrQuePeek(arr)
        ListBox Add CbHndl, lbxID, "Pop = " + SsArrQuePop(arr)
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add A, B, C to Front of Deque"
    SsArrClear arr
    SsArrPushFirst arr, "A"
    SsArrPushFirst arr, "B"
    SsArrPushFirst arr, "C"
    ListBox Add CbHndl, lbxID, "Add X, Y, Z to End of Deque"
    SsArrPushLast arr, "X"
    SsArrPushLast arr, "Y"
    SsArrPushLast arr, "Z"
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While SsArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + SsArrPeekFirst(arr)
        ListBox Add CbHndl, lbxID, "PopFirst = " + SsArrPopFirst(arr)
        ListBox Add CbHndl, lbxID, "PeekLast = " + SsArrPeekLast(arr)
        ListBox Add CbHndl, lbxID, "PopLast = " + SsArrPopLast(arr)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    SsArrClear arr
    For i = 1 To 3
        SsArrAdd arr, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = SsArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To SsArrCount(clone)
        ListBox Add CbHndl, lbxID, SsArrGet(clone, i)
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = SsArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    SsArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    SsArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SsArrCount(arr)
        ListBox Add CbHndl, lbxID, SsArrGet(arr, i)
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    SsArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    SsArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    SsArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SsArrCount(arr)
        ListBox Add CbHndl, lbxID, SsArrGet(arr, i)
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = SsArrFinal(arr)
    clone = SsArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "SsArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
