'WsLnHshRandom.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\WsLnHsh.inc"

'test Hash Table with random strings

Macro lbxID = 1000
Macro btnID = 1001

Function RndStr(ByVal characters As Long) As String
    'create random string characters long
    Local i As Long
    Local s As WString
    For i = 1 To characters
        s += Chr$$(Rnd(1, 65000))
    Next i
    Function = s
End Function

CallBack Function BtnCB()
    Local i, Count As Long
    Local a() As WString
    Local d As Double
    Local s As String

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000
    ReDim a(1 To Count)

    Local hash As Long
    hash = WsLnHshNew(Count)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "build random Keys; 25 characters long; Chr$(Rnd(1, 65000))"
    For i = 1 To Count
        a(i) = RndStr(25)
    Next i

    'add Key and Value to Hash Table

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "add "+Format$(Count, "#,")+" Key/Value items to Hash Table; 25 character Key"
    d = Timer
    For i = 1 To Count
        WsLnHshSet hash, a(i), i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WsLnHshCount(hash), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "test all "+Format$(Count, "#,")+" Key's existence with WsLnHshGot()"
    d = Timer
    For i = 1 To Count
        If IsFalse WsLnHshGot(hash, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, ""
    WsLnHshClear hash
    ListBox Add CbHndl, lbxID, "build random Keys; 50 characters long; Chr$(Rnd(1, 65000))"
    For i = 1 To Count
        a(i) = RndStr(50)
    Next i

    'add Key and Value to Hash Table

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "add "+Format$(Count, "#,")+" Key/Value items to Hash Table; 50 character Key"
    d = Timer
    For i = 1 To Count
        WsLnHshSet hash, a(i), i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WsLnHshCount(hash), "#,")

    'test to see if Key is in Hash Table

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "test all "+Format$(Count, "#,")+" Key's existence with WsLnHshGot()"
    d = Timer
    For i = 1 To Count
        If IsFalse WsLnHshGot(hash, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'store/restore to/from String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Store Hash Table to String"
    s = WsLnHshStore(hash)
    ListBox Add CbHndl, lbxID, "Restore Hash Table from String"
    WsLnHshRestore hash, s
    ListBox Add CbHndl, lbxID, "make sure all Key/Value items in Hash Table"
    For i = 1 To Count
        If IsFalse WsLnHshGot(hash, a(i)) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'must free handle before container goes out of scope
    hash = WsLnHshFinal(hash)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "WsLnHshRandom", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
