'BtLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\BtLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = BtLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 255

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        BtLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(BtLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = BtLstFirst(list)
    While node
        Incr i
        If BtLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = BtLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    BtLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        BtLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = BtLstLast(list)
    While node
        Incr i
        If BtLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = BtLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    BtLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    BtLstAdd list, 2
    BtLstAdd list, 4
    BtLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = BtLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : BtLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : BtLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = BtLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : BtLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : BtLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = BtLstFirst(list) : node = BtLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : BtLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : BtLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = BtLstLast(list) : node = BtLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : BtLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : BtLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = BtLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = BtLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = BtLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : BtLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(BtLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : BtLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : BtLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : BtLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(BtLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : BtLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    BtLstClear list
    BtLstStkPush list, 1
    BtLstStkPush list, 2
    BtLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While BtLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(BtLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(BtLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    BtLstClear list
    BtLstQuePush list, 1
    BtLstQuePush list, 2
    BtLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While BtLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(BtLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(BtLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    BtLstPushFirst list, 1
    BtLstPushFirst list, 2
    BtLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    BtLstPushLast list, 4
    BtLstPushLast list, 5
    BtLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = BtLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(BtLstGet(node))
        node = BtLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While BtLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(BtLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(BtLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(BtLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(BtLstPopLast(list))
    Wend


    'must free handles before they go out of scope
    list = BtLstFinal(list)
    clone = BtLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "BtLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
