#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Byte Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = BtQueNew() 'get handle for new container
    '       h = BtQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro BtQueTag = -1900523422
Type BtQueNode
    next As BtQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Byte
End Type
Type BtQue
    tag As Long
    count As Long
    first As BtQueNode Ptr
    last As BtQueNode Ptr
End Type

Function BtQueNew() As Long
    'allocate new container - return handle
    Local p As BtQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = BtQueTag
    Function = p
End Function

Function BtQueFinal(ByVal p As BtQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>BtQueTag, LibErrH)
        BtQueClear p
        MemFree(p)
    End If
End Function

Function BtQueValidate(ByVal p As BtQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = BtQueTag Then Function = @p.tag
End Function

Sub BtQueClear(ByVal p As BtQue Ptr)
    'delete all data
    Local node As BtQueNode Ptr
    ExitS(p=0 Or @p.tag<>BtQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function BtQueCount(ByVal p As BtQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>BtQueTag, LibErrH)
    Function = @p.count
End Function

Sub BtQuePush(ByVal p As BtQue Ptr, ByVal value As Byte)
    'add value to end of queue
    Local node As BtQueNode Ptr
    ExitS(p=0 Or @p.tag<>BtQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(BtQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(BtQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function BtQuePeek(ByVal p As BtQue Ptr) As Byte
    'get first value in queue
    ExitF(p=0 Or @p.tag<>BtQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function BtQuePop(ByVal p As BtQue Ptr) As Byte
    'get and remove first value in queue
    Local node As BtQueNode Ptr
    ExitF(p=0 Or @p.tag<>BtQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            BtQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
