#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Integer Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = InQueNew() 'get handle for new container
    '       h = InQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro InQueTag = -1821650520
Type InQueNode
    next As InQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Integer
End Type
Type InQue
    tag As Long
    count As Long
    first As InQueNode Ptr
    last As InQueNode Ptr
End Type

Function InQueNew() As Long
    'allocate new container - return handle
    Local p As InQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = InQueTag
    Function = p
End Function

Function InQueFinal(ByVal p As InQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>InQueTag, LibErrH)
        InQueClear p
        MemFree(p)
    End If
End Function

Function InQueValidate(ByVal p As InQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = InQueTag Then Function = @p.tag
End Function

Sub InQueClear(ByVal p As InQue Ptr)
    'delete all data
    Local node As InQueNode Ptr
    ExitS(p=0 Or @p.tag<>InQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function InQueCount(ByVal p As InQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>InQueTag, LibErrH)
    Function = @p.count
End Function

Sub InQuePush(ByVal p As InQue Ptr, ByVal value As Integer)
    'add value to end of queue
    Local node As InQueNode Ptr
    ExitS(p=0 Or @p.tag<>InQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(InQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(InQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function InQuePeek(ByVal p As InQue Ptr) As Integer
    'get first value in queue
    ExitF(p=0 Or @p.tag<>InQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function InQuePop(ByVal p As InQue Ptr) As Integer
    'get and remove first value in queue
    Local node As InQueNode Ptr
    ExitF(p=0 Or @p.tag<>InQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            InQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
