#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Long Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = LnQueNew() 'get handle for new container
    '       h = LnQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro LnQueTag = 1868553327
Type LnQueNode
    next As LnQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Long
End Type
Type LnQue
    tag As Long
    count As Long
    first As LnQueNode Ptr
    last As LnQueNode Ptr
End Type

Function LnQueNew() As Long
    'allocate new container - return handle
    Local p As LnQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = LnQueTag
    Function = p
End Function

Function LnQueFinal(ByVal p As LnQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>LnQueTag, LibErrH)
        LnQueClear p
        MemFree(p)
    End If
End Function

Function LnQueValidate(ByVal p As LnQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = LnQueTag Then Function = @p.tag
End Function

Sub LnQueClear(ByVal p As LnQue Ptr)
    'delete all data
    Local node As LnQueNode Ptr
    ExitS(p=0 Or @p.tag<>LnQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function LnQueCount(ByVal p As LnQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>LnQueTag, LibErrH)
    Function = @p.count
End Function

Sub LnQuePush(ByVal p As LnQue Ptr, ByVal value As Long)
    'add value to end of queue
    Local node As LnQueNode Ptr
    ExitS(p=0 Or @p.tag<>LnQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(LnQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(LnQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function LnQuePeek(ByVal p As LnQue Ptr) As Long
    'get first value in queue
    ExitF(p=0 Or @p.tag<>LnQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function LnQuePop(ByVal p As LnQue Ptr) As Long
    'get and remove first value in queue
    Local node As LnQueNode Ptr
    ExitF(p=0 Or @p.tag<>LnQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            LnQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
