#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Single Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = SnQueNew() 'get handle for new container
    '       h = SnQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro SnQueTag = 217604277
Type SnQueNode
    next As SnQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Single
End Type
Type SnQue
    tag As Long
    count As Long
    first As SnQueNode Ptr
    last As SnQueNode Ptr
End Type

Function SnQueNew() As Long
    'allocate new container - return handle
    Local p As SnQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = SnQueTag
    Function = p
End Function

Function SnQueFinal(ByVal p As SnQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>SnQueTag, LibErrH)
        SnQueClear p
        MemFree(p)
    End If
End Function

Function SnQueValidate(ByVal p As SnQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = SnQueTag Then Function = @p.tag
End Function

Sub SnQueClear(ByVal p As SnQue Ptr)
    'delete all data
    Local node As SnQueNode Ptr
    ExitS(p=0 Or @p.tag<>SnQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function SnQueCount(ByVal p As SnQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>SnQueTag, LibErrH)
    Function = @p.count
End Function

Sub SnQuePush(ByVal p As SnQue Ptr, ByVal value As Single)
    'add value to end of queue
    Local node As SnQueNode Ptr
    ExitS(p=0 Or @p.tag<>SnQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(SnQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(SnQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function SnQuePeek(ByVal p As SnQue Ptr) As Single
    'get first value in queue
    ExitF(p=0 Or @p.tag<>SnQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function SnQuePop(ByVal p As SnQue Ptr) As Single
    'get and remove first value in queue
    Local node As SnQueNode Ptr
    ExitF(p=0 Or @p.tag<>SnQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            SnQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
