#Include This Once
#Include Once "C:\HLib3\List\CxLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   CurrencyX Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = CxStkNew() 'get handle for new container
    '       h = CxStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro CxStkTag = -1010015649
Type CxStkNode
    prev As CxStkNode Ptr
    index As Long
    arr(1 To %StkMax) As CurrencyX
End Type
Type CxStk
    tag As Long
    count As Long
    top As CxStkNode Ptr
End Type

Function CxStkNew() As Long
    'allocate new container - return handle
    Local p As CxStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = CxStkTag
    Function = p
End Function

Function CxStkFinal(ByVal p As CxStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>CxStkTag, LibErrH)
        CxStkClear p
        MemFree(p)
    End If
End Function

Function CxStkValidate(ByVal p As CxStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = CxStkTag Then Function = @p.tag
End Function

Sub CxStkClear(ByVal p As CxStk Ptr)
    'delete all data - Modifies Container Data
    Local node As CxStkNode Ptr
    ExitS(p=0 Or @p.tag<>CxStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function CxStkCount(ByVal p As CxStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>CxStkTag, LibErrH)
    Function = @p.count
End Function

Sub CxStkPush(ByVal p As CxStk Ptr, ByVal value As CurrencyX)
    'push value on top of stack
    Local node As CxStkNode Ptr
    ExitS(p=0 Or @p.tag<>CxStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(CxStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(CxStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function CxStkPeek(ByVal p As CxStk Ptr) As CurrencyX
    'get top value on stack
    ExitF(p=0 Or @p.tag<>CxStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function CxStkPop(ByVal p As CxStk Ptr) As CurrencyX
    'get and remove top value on stack
    Local node As CxStkNode Ptr
    ExitF(p=0 Or @p.tag<>CxStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
