#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   String Buffer Container
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = SsNew() 'get handle for new container
    '   h = SsFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro SsTag = -445588383
Type SsStr
    tag As Long
    count As Long
    mem As Byte Ptr
End Type

Declare Function SsCompareCB(ByVal pa As SsStr Ptr, ByVal pb As SsStr Ptr, ByVal pCollation As SsStr Ptr) As Long

Function SsNew() As Long
    'allocate new container - return handle
    Local p As SsStr Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = SsTag
    Function = p
End Function

Function SsFinal(ByVal p As SsStr Ptr) As Long
    'free allocated container - return null - container can't be Read Locked
    If p Then
        ExitF(@p.tag<>SsTag, LibErrH)
        SsClear p
        MemFree(p)
    End If
End Function

Function SsValidate(ByVal p As SsStr Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = SsTag Then Function = @p.tag
End Function

Sub SsClear(ByVal p As SsStr Ptr)
    'delete all data - container can't be Read Locked
    ExitS(p=0 Or @p.tag<>SsTag, LibErrH)
    @p.count = 0
    @p.mem = MemFree(@p.mem)
End Sub

Function SsCount(ByVal p As SsStr Ptr) As Long
    'get item count (number of characters)
    ExitF(p=0 Or @p.tag<>SsTag, LibErrH)
    Function = @p.count
End Function

Function SsGet(ByVal p As SsStr Ptr) As String
    'get String
    ExitF(p=0 Or @p.tag<>SsTag, LibErrH)
    If @p.count Then Function = Peek$(@p.mem, @p.count)
End Function

Sub SsSet(ByVal p As SsStr Ptr, ByRef value As String)
    'set String - container can't be Read Locked
    Local strLen As Long : strLen = Len(value)
    ExitS(p=0 Or @p.tag<>SsTag, LibErrH)
    @p.count = 0
    If @p.mem Then @p.mem = MemFree(@p.mem)
    If strLen Then
        @p.mem = MemAlloc(strLen + 1)
        ExitS(@p.mem=0, LibErrM)
        @p.count = strLen
        Poke$ @p.mem, value
    End If
End Sub

Function SsSetNew(ByRef value As String) As Long
    'allocate and set new string buffer container - return handle
    Local h As Long
    h = SsNew()
    If h Then SsSet h, value
    Function = h
End Function

Function SsCompare(ByVal pa As SsStr Ptr, ByVal pb As SsStr Ptr, ByVal pCollation As SsStr Ptr) Private As Long
    Local i, compare, top As Long
    If pa And pb And @pa.tag=SsTag And @pb.tag=SsTag Then
        If @pa.count < @pb.count Then top = @pa.count Else top = @pb.count
        For i = 0 To top - 1
            compare = @pa.@mem[i] - @pb.@mem[i]
            If compare Then
                Function = compare : Exit Function
            End If
        Next i
        Function = @pa.count - @pb.count
    Else
        ExitLogErr(LibErrH)
    End If
End Function

Function SsCompareUCase(ByVal pa As SsStr Ptr, ByVal pb As SsStr Ptr, ByVal pCollation As SsStr Ptr) Private As Long
    Local ca, cb, i, compare, top As Long
    If pa And pb And @pa.tag=SsTag And @pb.tag=SsTag Then
        If @pa.count < @pb.count Then top = @pa.count Else top = @pb.count
        For i = 0 To top - 1
            ca = @pa.@mem[i]
            cb = @pb.@mem[i]
            If cA > 96 And cA < 123 Then cA -= 32
            If cB > 96 And cB < 123 Then cB -= 32
            compare = ca - cb
            If compare Then
                Function = compare : Exit Function
            End If
        Next i
        Function = @pa.count - @pb.count
    Else
        ExitLogErr(LibErrH)
    End If
End Function

Function SsCompareCollate(ByVal pa As SsStr Ptr, ByVal pb As SsStr Ptr, ByVal pCollation As SsStr Ptr) Private As Long
    Local i, compare, top As Long
    If pa And pb And pCollation And @pa.tag=SsTag And @pb.tag=SsTag And @pCollation.tag=SsTag Then
        If @pa.count < @pb.count Then top = @pa.count Else top = @pb.count
        For i = 0 To top - 1
            compare = @pCollation.@mem[@pa.@mem[i]] - @pCollation.@mem[@pb.@mem[i]]
            If compare Then
                Function = compare : Exit Function
            End If
        Next i
        Function = @pa.count - @pb.count
    Else
        ExitLogErr(LibErrH)
    End If
End Function

Macro Function SsEqual(ssmem, strMem)
    MacroTemp result, pa, pb
    Local result As Long
    Local pa, pb As Byte Ptr
    result = 0
    pa = ssmem : pb = strMem
    If pa And pb Then
        While @pa And @pb And @pa = @pb
            Incr pa
            Incr pb
        Wend
        If @pa = 0 And @pb = 0 Then result = 1
    ElseIf pa Or pb Then
    Else
        result = 1
    End If
End Macro = result

Macro Function SsEqualUCase(ssmem, strMem)
    MacroTemp result, pa, pb, ca, cb
    Register ca As Long
    Register cb As Long
    Local result As Long
    Local pa, pb As Byte Ptr
    result = 0
    pa = ssmem : pb = strMem
    If pa And pb Then
        ca = @pa
        cb = @pb
        If cA > 96 And cA < 123 Then cA -= 32
        If cB > 96 And cB < 123 Then cB -= 32
        While ca And cb And ca = cb
            Incr pa
            Incr pb
        Wend
        If @pa = 0 And @pb = 0 Then result = 1
    ElseIf pa Or pb Then
    Else
        result = 1
    End If
End Macro = result
