#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   WString Buffer Container
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = WsNew() 'get handle for new container
    '   h = WsFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro WsTag = -1119369189
Type WsStr
    tag As Long
    count As Long
    mem As Word Ptr
End Type

Declare Function WsCompareCB(ByVal pa As WsStr Ptr, ByVal pb As WsStr Ptr, ByVal pCollation As WsStr Ptr) As Long

Function WsNew() As Long
    'allocate new container - return handle
    Local p As WsStr Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsTag
    Function = p
End Function

Function WsFinal(ByVal p As WsStr Ptr) As Long
    'free allocated container - return null - container can't be Read Locked
    If p Then
        ExitF(@p.tag<>WsTag, LibErrH)
        WsClear p
        MemFree(p)
    End If
End Function

Function WsValidate(ByVal p As WsStr Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = WsTag Then Function = @p.tag
End Function

Sub WsClear(ByVal p As WsStr Ptr)
    'delete all data - container can't be Read Locked
    ExitS(p=0 Or @p.tag<>WsTag, LibErrH)
    @p.count = 0
    @p.mem = MemFree(@p.mem)
End Sub

Function WsCount(ByVal p As WsStr Ptr) As Long
    'get item count (number of characters)
    ExitF(p=0 Or @p.tag<>WsTag, LibErrH)
    Function = @p.count
End Function

Function WsGet(ByVal p As WsStr Ptr) As WString
    'get WString
    ExitF(p=0 Or @p.tag<>WsTag, LibErrH)
    If @p.count Then Function = Peek$$(@p.mem, @p.count)
End Function

Sub WsSet(ByVal p As WsStr Ptr, ByRef value As WString)
    'set WString - container can't be Read Locked
    Local strLen As Long : strLen = Len(value)
    ExitS(p=0 Or @p.tag<>WsTag, LibErrH)
    @p.count = 0
    If @p.mem Then @p.mem = MemFree(@p.mem)
    If strLen Then
        @p.mem = MemAlloc((strLen * 2) + 2)
        ExitS(@p.mem=0, LibErrM)
        @p.count = strLen
        Poke$$ @p.mem, value
    End If
End Sub

Function WsSetNew(ByRef value As WString) As Long
    'allocate and set new string buffer container - return handle
    Local h As Long
    h = WsNew()
    If h Then WsSet h, value
    Function = h
End Function

Function WsCompare(ByVal pa As WsStr Ptr, ByVal pb As WsStr Ptr, ByVal pCollation As WsStr Ptr) Private As Long
    Local i, compare, top As Long
    If pa And pb And @pa.tag=WsTag And @pb.tag=WsTag Then
        If @pa.count < @pb.count Then top = @pa.count Else top = @pb.count
        For i = 0 To top - 1
            compare = @pa.@mem[i] - @pb.@mem[i]
            If compare Then
                Function = compare : Exit Function
            End If
        Next i
        Function = @pa.count - @pb.count
    Else
        ExitLogErr(LibErrH)
    End If
End Function

Function WsCompareUCase(ByVal pa As WsStr Ptr, ByVal pb As WsStr Ptr, ByVal pCollation As WsStr Ptr) Private As Long
    Local ca, cb, i, compare, top As Long
    If pa And pb And @pa.tag=WsTag And @pb.tag=WsTag Then
        If @pa.count < @pb.count Then top = @pa.count Else top = @pb.count
        For i = 0 To top - 1
            ca = @pa.@mem[i]
            cb = @pb.@mem[i]
            If cA > 96 And cA < 123 Then cA -= 32
            If cB > 96 And cB < 123 Then cB -= 32
            compare = ca - cb
            If compare Then
                Function = compare : Exit Function
            End If
        Next i
        Function = @pa.count - @pb.count
    Else
        ExitLogErr(LibErrH)
    End If
End Function

Function WsCompareCollate(ByVal pa As WsStr Ptr, ByVal pb As WsStr Ptr, ByVal pCollation As WsStr Ptr) Private As Long
    Local i, compare, top As Long
    If pa And pb And pCollation And @pa.tag=WsTag And @pb.tag=WsTag And @pCollation.tag=WsTag Then
        If @pa.count < @pb.count Then top = @pa.count Else top = @pb.count
        For i = 0 To top - 1
            compare = @pCollation.@mem[@pa.@mem[i]] - @pCollation.@mem[@pb.@mem[i]]
            If compare Then
                Function = compare : Exit Function
            End If
        Next i
        Function = @pa.count - @pb.count
    Else
        ExitLogErr(LibErrH)
    End If
End Function

Macro Function WsEqual(wsmem, wstrMem)
    MacroTemp result, pa, pb
    Local result As Long
    Local pa, pb As Word Ptr
    result = 0
    pa = wsmem : pb = wstrMem
    If pa And pb Then
        While @pa And @pb And @pa = @pb
            Incr pa
            Incr pb
        Wend
        If @pa = 0 And @pb = 0 Then result = 1
    ElseIf pa Or pb Then
    Else
        result = 1
    End If
End Macro = result
