'don't need to include this file unless it contains a required UDT
'build date: 03-06-2013
'errors added to log file in app folder: Exe.Path$+"HLib.log"
'public domain - use at own risk

    'Naming Convention
    '    Variable Types:
    '        Bt = Byte
    '        In = Integer
    '        Wd = Word
    '        Ln = Long
    '        Dw = Dword
    '        Qd = Quad
    '        Sn = Single
    '        Db = Double
    '        Cu = Currency
    '        Cx = CurrencyX
    '        Ex = Extended
    '        Ss = String
    '        Ws = WString
    '        Sz = StringZ
    '        Wz = WStringZ
    '        Oj = Object
    '        Ut = UDT
    '        Sc = String Character
    '        Wc = WString Character
    '    Containers:
    '        Str = String Buffer container
    '        Arr = Array container
    '        Lst = List container
    '        Stk = Stack container
    '        Que = Queue container
    '        Dqu = Deque
    '        Pri = Priority Queue
    '        Tre = Tree Container
    '        Tri = Tire Tree Containera - Radix Tree
    '        Hsh = Hash Container
    '        Set = Set Container
    '        Cur = Currsor
    '        Ech = For Each Cursor
    '        MTre = MultiTree
    '        MHsh = MultiHash
    '        MSet = MultiSet
    '        DTre = Deep Tree


    '----------------------------------------------------------------------------------------
    '   String List Container Procedures
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = SsLstNew() 'get handle for new container
    '       h = SsLstFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------

Declare Function SsLstNew() As Long
    'allocate new container - return handle

Declare Function SsLstFinal(ByVal hLst As Long) As Long
    'free allocated container - return null - Modifies Container Data

Declare Function SsLstValidate(ByVal hLst As Long) As Long
    'True/False if valid handle for this container

Declare Sub SsLstClear(ByVal hLst As Long)
    'delete all data - Modifies Container Data

Declare Function SsLstCount(ByVal hLst As Long) As Long
    'get item count (number of characters)

Declare Sub SsLstAdd(ByVal hLst As Long, ByRef value As String)
    'append Value to end of List - Modifies Container Data

Declare Sub SsLstIns(ByVal hLst As Long, ByRef value As String)
    'insert Value at front of List - Modifies Container Data

Declare Function SsLstFirst(ByVal hLst As Long) As Long
    'get handle to first node in List

Declare Function SsLstLast(ByVal hLst As Long) As Long
    'get handle to last node in List

Declare Function SsLstNext(ByVal hNode As Long) As Long
    'get handle to next node in List

Declare Function SsLstPrev(ByVal hNode As Long) As Long
    'get handle to previous node in List

Declare Function SsLstGet(ByVal hNode As Long) As String
    'get node's Value

Declare Sub SsLstSet(ByVal hNode As Long, ByRef value As String)
    'set node's Value - Modifies Container Data

Declare Sub SsLstInsPrev(ByVal hLst As Long, ByVal hNode As Long, ByRef value As String)
    'insert Value before node - Modifies Container Data

Declare Sub SsLstInsNext(ByVal hLst As Long, ByVal hNode As Long, ByRef value As String)
    'insert Value after Cursor - Modifies Container Data

Declare Sub SsLstDelPrev(ByVal hLst As Long, ByVal hNode As Long)
    'remove node before this node - Modifies Container Data

Declare Sub SsLstDelNext(ByVal hLst As Long, ByVal hNode As Long)
    'remove node after this node - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Stack Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstStkPush(ByVal hLst As Long, ByRef value As String)
    'Push Value on Stack - Modifies Container Data

Declare Function SsLstStkPeek(ByVal hLst As Long) As String
    'get top Value on Stack

Declare Function SsLstStkPop(ByVal hLst As Long) As String
    'get and remove top Value on Stack - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Queue Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstQuePush(ByVal hLst As Long, ByRef value As String)
    'Add Value to end of Queue - Modifies Container Data

Declare Function SsLstQuePeek(ByVal hLst As Long) As String
    'get first Value in Queue

Declare Function SsLstQuePop(ByVal hLst As Long) As String
    'get and remove first Value in Queue - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Deque Procedures (double-ended Queue)
    '----------------------------------------------------------------------------------------

Declare Sub SsLstPushFirst(ByVal hLst As Long, ByRef value As String)
    'Add Value at front of container - Modifies Container Data

Declare Sub SsLstPushLast(ByVal hLst As Long, ByRef value As String)
    'Add Value at end of container - Modifies Container Data

Declare Function SsLstPeekFirst(ByVal hLst As Long) As String
    'get first Value in container

Declare Function SsLstPeekLast(ByVal hLst As Long) As String
    'get last Value in container

Declare Function SsLstPopFirst(ByVal hLst As Long) As String
    'get and remove first Value in container - Modifies Container Data

Declare Function SsLstPopLast(ByVal hLst As Long) As String
    'get and remove last Value in container - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------

Declare Function SsLstClone(ByVal hLst As Long) As Long
    'returns handle to duplicate container

    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------

Declare Function SsLstStore(ByVal hLst As Long) As String
    'store container to String

Declare Sub SsLstRestore(ByVal hLst As Long, ByRef s As String)
    'restore container from string - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------

Declare Sub SsLstFileStore(ByVal hLst As Long, ByVal file As String)
    'store container to file

Declare Sub SsLstFileRestore(ByVal hLst As Long, ByVal file As String)
    'restore container from file - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   String Builder Procedures
    '       use container's other procedures to Add/Insert/Modify/Remove string segments
    '----------------------------------------------------------------------------------------

Declare Function SsLstBuildStr(ByVal hLst As Long) As String
    'get complete string containing all string segments in container

    '----------------------------------------------------------------------------------------
    '   Text Document Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstTextLoad(ByVal hLst As Long, ByVal file As String)
    'load text file into container clearing current contents - Modifies Container Data

Declare Sub SsLstTextSave(ByVal hLst As Long, ByVal file As String)
    'save container to text file overwriting file's current contents

Declare Function SsLstTextGet(ByVal hLst As Long) As String
    'get container's contents as a Text Document, appending CrLf to each item

Declare Sub SsLstTextSet(ByVal hLst As Long, ByVal s As String)
    'replace container's contents with a Text Document - each line = item in container (removing CrLf) - Modifies Container Data

    '----------------------------------------------------------------------------------------
    '   File List Procedures
    '----------------------------------------------------------------------------------------

Declare Sub SsLstGetFiles(ByVal hLst As Long, ByVal folder As String, ByVal mask As String)
    'load container with all files in folder matching the mask - Modifies Container Data
    'loads file names without path

Declare Sub SsLstGetPaths(ByVal hLst As Long, ByVal folder As String, ByVal mask As String)
    'load container with all files in folder matching the mask - Modifies Container Data
    'loads full path
