#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\SsLst.inc"
#Include Once "C:\HLib3\List\DwLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'String/Dword ~ Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - no limit on Key length
    '   - use SsDwTreComparison() to change how Keys compared
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   - use MultiTree for one-to-many relationship
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = SsDwTreNew() 'get handle for new container
    '   h = SsDwTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--


Macro SsDwTreNodeTag = -324365412
Macro SsDwTreTag = 1620720082
Type SsDwTreNode
    tag As Long
    P As SsDwTreNode Ptr
    L As SsDwTreNode Ptr
    R As SsDwTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As Dword
End Type
Type SsDwTre
    tag As Long
    count As Long
    root As SsDwTreNode Ptr
    compareCB As Long
    collation As SsStr Ptr
End Type

Function SsDwTreNew() As Long
    'allocate new container - return handle
    Local p As SsDwTre Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = SsDwTreTag
    @p.compareCB = CodePtr(SsCompare)
    @p.collation = SsNew() : If Err Then Exit Function
    Function = p
End Function

Function SsDwTreFinal(ByVal pTree As SsDwTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>SsDwTreTag, LibErrH)
        @pTree.collation = SsFinal(@pTree.collation)
        SsDwTreClear pTree
        MemFree(pTree)
    End If
End Function

Function SsDwTreValidate(ByVal pTree As SsDwTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = SsDwTreTag Then Function = @pTree.tag
End Function

Sub SsDwTreComparison(ByVal pTree As SsDwTre Ptr, ByVal compareUCase As Long, ByVal collationSequence As String)
    'set how Strings compared
    'default = case ignored
    'if collationSequence String provided then
    '   Strings are compared using the order of the collation sequence String
    '   collation String must be 256 characters
    'else if compareUCase = True then
    '   Strings compared UCase
    ExitS(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    @pTree.compareCB = CodePtr(SsCompare)
    SsClear @pTree.collation
    If Len(collationSequence) Then
        ExitS(Len(collationSequence)<>256, LibErrS)
        SsSet @pTree.collation, collationSequence : If Err Then Exit Sub
        @pTree.compareCB = CodePtr(SsCompareCollate)
    ElseIf compareUCase Then
        @pTree.compareCB = CodePtr(SsCompareUCase)
    End If
End Sub

Sub SsDwTreClear(ByVal pTree As SsDwTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As SsDwTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = SsDwTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = SsDwTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            SsDwTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function SsDwTreCount(ByVal pTree As SsDwTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub SsDwTreSet(ByVal pTree As SsDwTre Ptr, ByRef key As String, ByVal value As Dword, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local compare, temp As Long
    Local n As SsDwTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    temp = SsSetNew(key) : If Err Then Exit Sub
    If @pTree.root Then
        n = @pTree.root
        While 1
            Call Dword @pTree.compareCB Using SsCompareCB(temp, @n.K, @pTree.collation) To compare
            If compare > 0 Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = SsDwTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    SsSet @n.@R.K, key
                    @n.@R.V = value
                    SsDwTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf compare < 0 Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = SsDwTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    SsSet @n.@L.K, key
                    @n.@L.V = value
                    SsDwTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then @n.V = value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = SsDwTreAllocNode(pTree) : If Err Then Exit Sub
        SsSet @pTree.@root.K, key
        @pTree.@root.V = value
        @pTree.count = 1
    End If
    temp = SsFinal(temp)
End Sub

Function SsDwTreGet(ByVal pTree As SsDwTre Ptr, ByRef key As String) As Dword
    'get Key's associated Value
    Local compare, temp As Long
    Local n As SsDwTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    temp = SsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using SsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = @n.V
            Exit Loop
        End If
    Wend
    temp = SsFinal(temp)
End Function

Function SsDwTreGot(ByVal pTree As SsDwTre Ptr, ByRef key As String) As Long
    'True/False if Key exist
    Local compare, temp As Long
    Local n As SsDwTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    temp = SsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using SsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
    temp = SsFinal(temp)
End Function

Sub SsDwTreDel(ByVal pTree As SsDwTre Ptr, ByRef key As String)
    'remove Key and associated Value
    Local pNode As SsDwTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    pNode = SsDwTreGot(pTree, key)
    If pNode Then
        SsDwTreRemoveNode(pTree, pNode)
    End If
End Sub

Function SsDwTreFirst(ByVal pTree As SsDwTre Ptr) As Long
    'get handle to first node in tree
    Local n As SsDwTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function SsDwTreLast(ByVal pTree As SsDwTre Ptr) As Long
    'get handle to last node in tree
    Local n As SsDwTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function SsDwTreNext(ByVal pNode As SsDwTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As SsDwTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>SsDwTreNodeTag, LibErrH)
        minR = SsDwTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = SsDwTreParentGreater(pNode)
        End If
    End If
End Function

Function SsDwTrePrev(ByVal pNode As SsDwTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As SsDwTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>SsDwTreNodeTag, LibErrH)
        maxL = SsDwTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = SsDwTreParentLesser(pNode)
        End If
    End If
End Function

Function SsDwTreGetKey(ByVal pNode As SsDwTreNode Ptr) As String
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>SsDwTreNodeTag, LibErrH)
    Function = SsGet(@pNode.K)
End Function

Function SsDwTreGetVal(ByVal pNode As SsDwTreNode Ptr) As Dword
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>SsDwTreNodeTag, LibErrH)
    Function = @pNode.V
End Function

Sub SsDwTreSetVal(ByVal pNode As SsDwTreNode Ptr, ByVal value As Dword)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>SsDwTreNodeTag, LibErrH)
    @pNode.V = value
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function SsDwTreClone(ByVal pTree As SsDwTre Ptr) As Long
    'create duplicate container
    Local h, clone As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    clone = SsDwTreNew() : If Err Then Exit Function
    h = SsDwTreFirst(pTree)
    While h
        SsDwTreSet clone, SsDwTreGetKey(h), SsDwTreGetVal(h)
        h = SsDwTreNext(h)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function SsDwTreStore(ByVal pTree As SsDwTre Ptr) As String
    'store container to string
    Local h, keys, vals, stor As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    keys = SsLstNew() : If Err Then Exit Function
    vals = DwLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        h = SsDwTreFirst(pTree)
        While h
            SsLstAdd keys, SsDwTreGetKey(h)
            DwLstAdd vals, SsDwTreGetVal(h)
            h = SsDwTreNext(h)
        Wend
        SsLstAdd stor, SsLstStore(keys)
        SsLstAdd stor, DwLstStore(vals)
        Function = SsLstStore(stor)
    End If
    keys = SsLstFinal(keys)
    vals = DwLstFinal(vals)
    stor = SsLstFinal(stor)
End Function

Sub SsDwTreRestore(ByVal pTree As SsDwTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, stor As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    SsDwTreClear pTree
    keys = SsLstNew() : If Err Then Exit Sub
    vals = DwLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>2, LibErrU)
        SsLstRestore keys, SsLstPopFirst(stor)
        DwLstRestore vals, SsLstPopFirst(stor)
        ExitS(SsLstCount(keys)<>DwLstCount(vals), LibErrU)
        While SsLstCount(keys)
            SsDwTreSet pTree, SsLstPopFirst(keys), DwLstPopFirst(vals)
        Wend
    End If
    keys = SsLstFinal(keys)
    vals = DwLstFinal(vals)
    stor = SsLstFinal(stor)
End Sub


'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub SsDwTreFileStore(ByVal pTree As SsDwTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    s = SsDwTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub SsDwTreFileRestore(ByVal pTree As SsDwTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>SsDwTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        SsDwTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub SsDwTreRemoveNode(ByVal p As SsDwTre Ptr, ByVal n As SsDwTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As SsDwTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, SsDwTreMaxLeft(n), SsDwTreMinRight(n))
        If @p.root = n Then @p.root = swapN
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        n = swapN
    Wend
    If n = @p.root Then
        SsDwTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = SsDwTreFreeNode(p, n)
        SsDwTreBalanceBranch p, nP
    End If
End Sub

Function SsDwTreAllocNode(ByVal p As SsDwTre Ptr) Private As Long
    Local n As SsDwTreNode Ptr
    n = MemAlloc(SizeOf(SsDwTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.tag = SsDwTreNodeTag
    @n.K = SsNew() : If Err Then Exit Function
    Incr @p.count
    Function = n
End Function

Function SsDwTreFreeNode(ByVal p As SsDwTre Ptr, ByVal n As SsDwTreNode Ptr) As Long
    If n Then
        @n.K = SsFinal(@n.K)
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub SsDwTreBalanceBranch(ByVal p As SsDwTre Ptr, ByVal n As SsDwTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = SsDwTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = SsDwTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function SsDwTreMaxLeft(ByVal n As SsDwTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function SsDwTreMinRight(ByVal n As SsDwTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function SsDwTreParentGreater(ByVal n As SsDwTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function SsDwTreParentLesser(ByVal n As SsDwTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function SsDwTreRotateLeft(ByVal p As SsDwTre Ptr, ByVal n As SsDwTreNode Ptr) Private As Long
    Local nR, nRL As SsDwTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function SsDwTreRotateRight(ByVal p As SsDwTre Ptr, ByVal n As SsDwTreNode Ptr) Private As Long
    Local nL, nLR As SsDwTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
