'BtArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\BtArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = BtArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        BtArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(BtArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    BtArrClear arr
    BtArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        BtArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(BtArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    BtArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        BtArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If BtArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    BtArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, BtArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, BtArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    BtArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, BtArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, BtArrCount(arr)))

    'test sort
    For i = 1 To BtArrCount(arr) - 1
        If BtArrGet(arr, i) > BtArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(BtArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If BtArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    BtArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        BtArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To BtArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    BtArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To BtArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = BtArrCount(arr) To 1 Step -1
        If BtArrGet(arr, i) Mod 2 Then BtArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To BtArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    BtArrClear arr
    BtArrStkPush arr, 1
    BtArrStkPush arr, 2
    BtArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While BtArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(BtArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(BtArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    BtArrClear arr
    BtArrQuePush arr, 1
    BtArrQuePush arr, 2
    BtArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While BtArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(BtArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(BtArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    BtArrClear arr
    BtArrPushFirst arr, 1
    BtArrPushFirst arr, 2
    BtArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    BtArrPushLast arr, 4
    BtArrPushLast arr, 5
    BtArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While BtArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(BtArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(BtArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(BtArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(BtArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    BtArrClear arr
    For i = 1 To 3
        BtArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = BtArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To BtArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(BtArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = BtArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    BtArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    BtArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To BtArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    BtArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    BtArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    BtArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To BtArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(BtArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = BtArrFinal(arr)
    clone = BtArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "BtArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
