'CuArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\CuArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = CuArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        CuArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CuArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    CuArrClear arr
    CuArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        CuArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CuArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    CuArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        CuArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If CuArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    CuArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, CuArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, CuArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    CuArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, CuArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, CuArrCount(arr)))

    'test sort
    For i = 1 To CuArrCount(arr) - 1
        If CuArrGet(arr, i) > CuArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(CuArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If CuArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    CuArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        CuArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CuArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    CuArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CuArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = CuArrCount(arr) To 1 Step -1
        If CuArrGet(arr, i) Mod 2 Then CuArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CuArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    CuArrClear arr
    CuArrStkPush arr, 1
    CuArrStkPush arr, 2
    CuArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While CuArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(CuArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(CuArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    CuArrClear arr
    CuArrQuePush arr, 1
    CuArrQuePush arr, 2
    CuArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While CuArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(CuArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(CuArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    CuArrClear arr
    CuArrPushFirst arr, 1
    CuArrPushFirst arr, 2
    CuArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    CuArrPushLast arr, 4
    CuArrPushLast arr, 5
    CuArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While CuArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(CuArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(CuArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(CuArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(CuArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    CuArrClear arr
    For i = 1 To 3
        CuArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = CuArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To CuArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(CuArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = CuArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    CuArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    CuArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CuArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    CuArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    CuArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    CuArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To CuArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(CuArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = CuArrFinal(arr)
    clone = CuArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "CuArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
