'DbArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\DbArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = DbArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        DbArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DbArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    DbArrClear arr
    DbArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        DbArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DbArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    DbArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        DbArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If DbArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    DbArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, DbArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, DbArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    DbArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, DbArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, DbArrCount(arr)))

    'test sort
    For i = 1 To DbArrCount(arr) - 1
        If DbArrGet(arr, i) > DbArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(DbArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If DbArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    DbArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        DbArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DbArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    DbArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DbArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = DbArrCount(arr) To 1 Step -1
        If DbArrGet(arr, i) Mod 2 Then DbArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DbArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    DbArrClear arr
    DbArrStkPush arr, 1
    DbArrStkPush arr, 2
    DbArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While DbArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(DbArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(DbArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    DbArrClear arr
    DbArrQuePush arr, 1
    DbArrQuePush arr, 2
    DbArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While DbArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(DbArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(DbArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    DbArrClear arr
    DbArrPushFirst arr, 1
    DbArrPushFirst arr, 2
    DbArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    DbArrPushLast arr, 4
    DbArrPushLast arr, 5
    DbArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While DbArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(DbArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(DbArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(DbArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(DbArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    DbArrClear arr
    For i = 1 To 3
        DbArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = DbArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To DbArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(DbArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = DbArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    DbArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    DbArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DbArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    DbArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    DbArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    DbArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To DbArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(DbArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = DbArrFinal(arr)
    clone = DbArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "DbArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
