'QdArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\QdArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = QdArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 1000000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        QdArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(QdArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    QdArrClear arr
    QdArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        QdArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(QdArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    QdArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        QdArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If QdArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    QdArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, QdArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, QdArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    QdArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, QdArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, QdArrCount(arr)))

    'test sort
    For i = 1 To QdArrCount(arr) - 1
        If QdArrGet(arr, i) > QdArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(QdArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If QdArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    QdArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        QdArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To QdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    QdArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To QdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = QdArrCount(arr) To 1 Step -1
        If QdArrGet(arr, i) Mod 2 Then QdArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To QdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    QdArrClear arr
    QdArrStkPush arr, 1
    QdArrStkPush arr, 2
    QdArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While QdArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(QdArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(QdArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    QdArrClear arr
    QdArrQuePush arr, 1
    QdArrQuePush arr, 2
    QdArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While QdArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(QdArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(QdArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    QdArrClear arr
    QdArrPushFirst arr, 1
    QdArrPushFirst arr, 2
    QdArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    QdArrPushLast arr, 4
    QdArrPushLast arr, 5
    QdArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While QdArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(QdArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(QdArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(QdArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(QdArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    QdArrClear arr
    For i = 1 To 3
        QdArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = QdArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To QdArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(QdArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = QdArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    QdArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    QdArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To QdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    QdArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    QdArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    QdArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To QdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(QdArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = QdArrFinal(arr)
    clone = QdArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "QdArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
