'SnArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\SnArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = SnArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        SnArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SnArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    SnArrClear arr
    SnArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        SnArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SnArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    SnArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        SnArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If SnArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    SnArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, SnArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, SnArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    SnArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, SnArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, SnArrCount(arr)))

    'test sort
    For i = 1 To SnArrCount(arr) - 1
        If SnArrGet(arr, i) > SnArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(SnArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If SnArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    SnArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        SnArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    SnArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = SnArrCount(arr) To 1 Step -1
        If SnArrGet(arr, i) Mod 2 Then SnArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    SnArrClear arr
    SnArrStkPush arr, 1
    SnArrStkPush arr, 2
    SnArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While SnArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(SnArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(SnArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    SnArrClear arr
    SnArrQuePush arr, 1
    SnArrQuePush arr, 2
    SnArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While SnArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(SnArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(SnArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    SnArrClear arr
    SnArrPushFirst arr, 1
    SnArrPushFirst arr, 2
    SnArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    SnArrPushLast arr, 4
    SnArrPushLast arr, 5
    SnArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While SnArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(SnArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(SnArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(SnArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(SnArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    SnArrClear arr
    For i = 1 To 3
        SnArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = SnArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To SnArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(SnArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = SnArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    SnArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    SnArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    SnArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    SnArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    SnArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To SnArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(SnArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = SnArrFinal(arr)
    clone = SnArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "SnArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
