'CuLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\CuLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = CuLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        CuLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CuLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = CuLstFirst(list)
    While node
        Incr i
        If CuLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = CuLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    CuLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        CuLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = CuLstLast(list)
    While node
        Incr i
        If CuLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = CuLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    CuLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    CuLstAdd list, 2
    CuLstAdd list, 4
    CuLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = CuLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : CuLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : CuLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = CuLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : CuLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : CuLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = CuLstFirst(list) : node = CuLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : CuLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : CuLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = CuLstLast(list) : node = CuLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : CuLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : CuLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = CuLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = CuLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = CuLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : CuLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CuLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : CuLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : CuLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : CuLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(CuLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : CuLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    CuLstClear list
    CuLstStkPush list, 1
    CuLstStkPush list, 2
    CuLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While CuLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(CuLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(CuLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    CuLstClear list
    CuLstQuePush list, 1
    CuLstQuePush list, 2
    CuLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While CuLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(CuLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(CuLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    CuLstPushFirst list, 1
    CuLstPushFirst list, 2
    CuLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    CuLstPushLast list, 4
    CuLstPushLast list, 5
    CuLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = CuLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(CuLstGet(node))
        node = CuLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While CuLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(CuLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(CuLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(CuLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(CuLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = CuLstFinal(list)
    clone = CuLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "CuLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
