'DwLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\DwLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = DwLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        DwLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DwLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = DwLstFirst(list)
    While node
        Incr i
        If DwLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = DwLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    DwLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        DwLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = DwLstLast(list)
    While node
        Incr i
        If DwLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = DwLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    DwLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    DwLstAdd list, 2
    DwLstAdd list, 4
    DwLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = DwLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : DwLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : DwLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = DwLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : DwLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : DwLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = DwLstFirst(list) : node = DwLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : DwLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : DwLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = DwLstLast(list) : node = DwLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : DwLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : DwLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = DwLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = DwLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = DwLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : DwLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DwLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : DwLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : DwLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : DwLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(DwLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : DwLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    DwLstClear list
    DwLstStkPush list, 1
    DwLstStkPush list, 2
    DwLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While DwLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(DwLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(DwLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    DwLstClear list
    DwLstQuePush list, 1
    DwLstQuePush list, 2
    DwLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While DwLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(DwLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(DwLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    DwLstPushFirst list, 1
    DwLstPushFirst list, 2
    DwLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    DwLstPushLast list, 4
    DwLstPushLast list, 5
    DwLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = DwLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(DwLstGet(node))
        node = DwLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While DwLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(DwLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(DwLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(DwLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(DwLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = DwLstFinal(list)
    clone = DwLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "DwLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
