'ExLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\ExLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = ExLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        ExLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(ExLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = ExLstFirst(list)
    While node
        Incr i
        If ExLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = ExLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    ExLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        ExLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = ExLstLast(list)
    While node
        Incr i
        If ExLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = ExLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    ExLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    ExLstAdd list, 2
    ExLstAdd list, 4
    ExLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = ExLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : ExLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : ExLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = ExLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : ExLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : ExLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = ExLstFirst(list) : node = ExLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : ExLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : ExLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = ExLstLast(list) : node = ExLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : ExLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : ExLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = ExLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = ExLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = ExLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : ExLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(ExLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : ExLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : ExLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : ExLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(ExLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : ExLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    ExLstClear list
    ExLstStkPush list, 1
    ExLstStkPush list, 2
    ExLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While ExLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(ExLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(ExLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    ExLstClear list
    ExLstQuePush list, 1
    ExLstQuePush list, 2
    ExLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While ExLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(ExLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(ExLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    ExLstPushFirst list, 1
    ExLstPushFirst list, 2
    ExLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    ExLstPushLast list, 4
    ExLstPushLast list, 5
    ExLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = ExLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(ExLstGet(node))
        node = ExLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While ExLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(ExLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(ExLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(ExLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(ExLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = ExLstFinal(list)
    clone = ExLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "ExLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
