'LnLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\LnLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = LnLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        LnLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = LnLstFirst(list)
    While node
        Incr i
        If LnLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = LnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    LnLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        LnLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = LnLstLast(list)
    While node
        Incr i
        If LnLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = LnLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    LnLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    LnLstAdd list, 2
    LnLstAdd list, 4
    LnLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = LnLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : LnLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : LnLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = LnLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : LnLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : LnLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = LnLstFirst(list) : node = LnLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : LnLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : LnLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = LnLstLast(list) : node = LnLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : LnLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : LnLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = LnLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = LnLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = LnLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : LnLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : LnLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : LnLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : LnLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(LnLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : LnLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    LnLstClear list
    LnLstStkPush list, 1
    LnLstStkPush list, 2
    LnLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While LnLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(LnLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(LnLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    LnLstClear list
    LnLstQuePush list, 1
    LnLstQuePush list, 2
    LnLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While LnLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(LnLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(LnLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    LnLstPushFirst list, 1
    LnLstPushFirst list, 2
    LnLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    LnLstPushLast list, 4
    LnLstPushLast list, 5
    LnLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = LnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(LnLstGet(node))
        node = LnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While LnLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(LnLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(LnLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(LnLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(LnLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = LnLstFinal(list)
    clone = LnLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "LnLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
