'QdLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\QdLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = QdLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 1000000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        QdLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(QdLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = QdLstFirst(list)
    While node
        Incr i
        If QdLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = QdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    QdLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        QdLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = QdLstLast(list)
    While node
        Incr i
        If QdLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = QdLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    QdLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    QdLstAdd list, 2
    QdLstAdd list, 4
    QdLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = QdLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : QdLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : QdLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = QdLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : QdLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : QdLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = QdLstFirst(list) : node = QdLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : QdLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : QdLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = QdLstLast(list) : node = QdLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : QdLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : QdLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = QdLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = QdLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = QdLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : QdLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(QdLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : QdLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : QdLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : QdLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(QdLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : QdLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    QdLstClear list
    QdLstStkPush list, 1
    QdLstStkPush list, 2
    QdLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While QdLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(QdLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(QdLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    QdLstClear list
    QdLstQuePush list, 1
    QdLstQuePush list, 2
    QdLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While QdLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(QdLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(QdLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    QdLstPushFirst list, 1
    QdLstPushFirst list, 2
    QdLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    QdLstPushLast list, 4
    QdLstPushLast list, 5
    QdLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = QdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(QdLstGet(node))
        node = QdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While QdLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(QdLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(QdLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(QdLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(QdLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = QdLstFinal(list)
    clone = QdLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "QdLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
