'SnLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\SnLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = SnLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 100000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        SnLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SnLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = SnLstFirst(list)
    While node
        Incr i
        If SnLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = SnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    SnLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        SnLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = SnLstLast(list)
    While node
        Incr i
        If SnLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = SnLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    SnLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    SnLstAdd list, 2
    SnLstAdd list, 4
    SnLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = SnLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : SnLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : SnLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = SnLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : SnLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : SnLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = SnLstFirst(list) : node = SnLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : SnLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : SnLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = SnLstLast(list) : node = SnLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : SnLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : SnLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = SnLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = SnLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = SnLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : SnLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SnLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : SnLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : SnLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : SnLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SnLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : SnLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    SnLstClear list
    SnLstStkPush list, 1
    SnLstStkPush list, 2
    SnLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While SnLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(SnLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(SnLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    SnLstClear list
    SnLstQuePush list, 1
    SnLstQuePush list, 2
    SnLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While SnLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(SnLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(SnLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    SnLstPushFirst list, 1
    SnLstPushFirst list, 2
    SnLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    SnLstPushLast list, 4
    SnLstPushLast list, 5
    SnLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SnLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(SnLstGet(node))
        node = SnLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While SnLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(SnLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(SnLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(SnLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(SnLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = SnLstFinal(list)
    clone = SnLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "SnLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
