'SsLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\SsLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String
    Local a() As String

    'get handle to new List container
    Local list As Long : list = SsLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 10000
    ReDim a(1 To Count)
    For i = 1 To Count
        a(i) = Format$(i, "0000000")
    Next i

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        SsLstAdd list, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = SsLstFirst(list)
    While node
        Incr i
        If SsLstGet(node) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = SsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    SsLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        SsLstIns list, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = SsLstLast(list)
    While node
        Incr i
        If SsLstGet(node) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = SsLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    SsLstClear list
    ListBox Add CbHndl, lbxID, "add B, D, F"
    SsLstAdd list, "B"
    SsLstAdd list, "D"
    SsLstAdd list, "F"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = SsLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert A before" : SsLstInsPrev list, node, "A"
    ListBox Add CbHndl, lbxID, "    insert C after"  : SsLstInsNext list, node, "C"
    ListBox Add CbHndl, lbxID, "move to last node"   : node = SsLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert E before" : SsLstInsPrev list, node, "E"
    ListBox Add CbHndl, lbxID, "    insert G after"  : SsLstInsNext list, node, "G"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = SsLstFirst(list) : node = SsLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : SsLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : SsLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = SsLstLast(list) : node = SsLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : SsLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : SsLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = SsLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = SsLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = SsLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : SsLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : SsLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : SsLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : SsLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(SsLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : SsLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push AAA, BBB, CCC on Stack"
    SsLstClear list
    SsLstStkPush list, "AAA"
    SsLstStkPush list, "BBB"
    SsLstStkPush list, "CCC"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While SsLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + SsLstStkPeek(list)
        ListBox Add CbHndl, lbxID, "Pop = " + SsLstStkPop(list)
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add AAA, BBB, CCC to Queue"
    SsLstClear list
    SsLstQuePush list, "AAA"
    SsLstQuePush list, "BBB"
    SsLstQuePush list, "CCC"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While SsLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + SsLstQuePeek(list)
        ListBox Add CbHndl, lbxID, "Pop = " + SsLstQuePop(list)
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add AAA, BBB, CCC to front of Deque"
    SsLstPushFirst list, "AAA"
    SsLstPushFirst list, "BBB"
    SsLstPushFirst list, "CCC"
    ListBox Add CbHndl, lbxID, "add XXX, YYY, ZZZ to end of Deque"
    SsLstPushLast list, "XXX"
    SsLstPushLast list, "YYY"
    SsLstPushLast list, "ZZZ"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = SsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, SsLstGet(node)
        node = SsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While SsLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + SsLstPeekFirst(list)
        ListBox Add CbHndl, lbxID, "PopFirst = " + SsLstPopFirst(list)
        ListBox Add CbHndl, lbxID, "PeekLast = " + SsLstPeekLast(list)
        ListBox Add CbHndl, lbxID, "PopLast = " + SsLstPopLast(list)
    Wend

    'must free handles before they go out of scope
    list = SsLstFinal(list)
    clone = SsLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "SsLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
