'WdLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\WdLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = WdLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 65000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        WdLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WdLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = WdLstFirst(list)
    While node
        Incr i
        If WdLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = WdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    WdLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        WdLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = WdLstLast(list)
    While node
        Incr i
        If WdLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = WdLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    WdLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    WdLstAdd list, 2
    WdLstAdd list, 4
    WdLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = WdLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : WdLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : WdLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = WdLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : WdLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : WdLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = WdLstFirst(list) : node = WdLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : WdLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : WdLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = WdLstLast(list) : node = WdLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : WdLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : WdLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = WdLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = WdLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = WdLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : WdLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WdLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : WdLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : WdLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : WdLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WdLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : WdLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    WdLstClear list
    WdLstStkPush list, 1
    WdLstStkPush list, 2
    WdLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While WdLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(WdLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(WdLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    WdLstClear list
    WdLstQuePush list, 1
    WdLstQuePush list, 2
    WdLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While WdLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(WdLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(WdLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    WdLstPushFirst list, 1
    WdLstPushFirst list, 2
    WdLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    WdLstPushLast list, 4
    WdLstPushLast list, 5
    WdLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WdLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(WdLstGet(node))
        node = WdLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While WdLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(WdLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(WdLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(WdLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(WdLstPopLast(list))
    Wend


    'must free handles before they go out of scope
    list = WdLstFinal(list)
    clone = WdLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "WdLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
