#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   CurrencyX Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = CxQueNew() 'get handle for new container
    '       h = CxQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro CxQueTag = -1401349845
Type CxQueNode
    next As CxQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As CurrencyX
End Type
Type CxQue
    tag As Long
    count As Long
    first As CxQueNode Ptr
    last As CxQueNode Ptr
End Type

Function CxQueNew() As Long
    'allocate new container - return handle
    Local p As CxQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = CxQueTag
    Function = p
End Function

Function CxQueFinal(ByVal p As CxQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>CxQueTag, LibErrH)
        CxQueClear p
        MemFree(p)
    End If
End Function

Function CxQueValidate(ByVal p As CxQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = CxQueTag Then Function = @p.tag
End Function

Sub CxQueClear(ByVal p As CxQue Ptr)
    'delete all data
    Local node As CxQueNode Ptr
    ExitS(p=0 Or @p.tag<>CxQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function CxQueCount(ByVal p As CxQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>CxQueTag, LibErrH)
    Function = @p.count
End Function

Sub CxQuePush(ByVal p As CxQue Ptr, ByVal value As CurrencyX)
    'add value to end of queue
    Local node As CxQueNode Ptr
    ExitS(p=0 Or @p.tag<>CxQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(CxQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(CxQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function CxQuePeek(ByVal p As CxQue Ptr) As CurrencyX
    'get first value in queue
    ExitF(p=0 Or @p.tag<>CxQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function CxQuePop(ByVal p As CxQue Ptr) As CurrencyX
    'get and remove first value in queue
    Local node As CxQueNode Ptr
    ExitF(p=0 Or @p.tag<>CxQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            CxQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
