#Include This Once
#Include Once "C:\HLib3\String\WsStr.inc"
#Include Once "C:\HLib3\Queue\LnQue.inc"

'++
    '----------------------------------------------------------------------------------------
    '   WString Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = WsQueNew() 'get handle for new container
    '       h = WsQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro WsQueTag = -905398734
Type WsQue
    tag As Long
    que As LnQue Ptr
End Type

Function WsQueNew() As Long
    'allocate new container - return handle
    Local p As WsQue Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsQueTag
    @p.que = LnQueNew() : If Err Then Exit Function
    Function = p
End Function

Function WsQueFinal(ByVal p As WsQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>WsQueTag, LibErrH)
        WsQueClear p
        @p.que = LnQueFinal(@p.que)
        MemFree(p)
    End If
End Function

Function WsQueValidate(ByVal p As WsQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = WsQueTag Then Function = @p.tag
End Function

Sub WsQueClear(ByVal p As WsQue Ptr)
    'delete all data
    ExitS(p=0 Or @p.tag<>WsQueTag, LibErrH)
    While @p.@que.count
        WsFinal(LnQuePop(@p.que))
    Wend
End Sub

Function WsQueCount(ByVal p As WsQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>WsQueTag, LibErrH)
    Function = @p.@que.count
End Function

Sub WsQuePush(ByVal p As WsQue Ptr, ByRef value As WString)
    'add value to end of queue
    ExitS(p=0 Or @p.tag<>WsQueTag, LibErrH)
    LnQuePush @p.que, WsSetNew(value)
End Sub

Function WsQuePeek(ByVal p As WsQue Ptr) As WString
    'get first value in queue
    ExitF(p=0 Or @p.tag<>WsQueTag, LibErrH)
    If @p.@que.count Then Function = WsGet(LnQuePeek(@p.que))
End Function

Function WsQuePop(ByVal p As WsQue Ptr) As WString
    'get and remove first value in queue
    Local h As Long
    ExitF(p=0 Or @p.tag<>WsQueTag, LibErrH)
    h = LnQuePop(@p.que)
    If h Then
        Function = WsGet(h)
        WsFinal(h)
    End If
End Function
