#Include This Once
#Include Once "C:\HLib3\List\DbLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Double Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = DbStkNew() 'get handle for new container
    '       h = DbStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro DbStkTag = 1406048983
Type DbStkNode
    prev As DbStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Double
End Type
Type DbStk
    tag As Long
    count As Long
    top As DbStkNode Ptr
End Type

Function DbStkNew() As Long
    'allocate new container - return handle
    Local p As DbStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = DbStkTag
    Function = p
End Function

Function DbStkFinal(ByVal p As DbStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>DbStkTag, LibErrH)
        DbStkClear p
        MemFree(p)
    End If
End Function

Function DbStkValidate(ByVal p As DbStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = DbStkTag Then Function = @p.tag
End Function

Sub DbStkClear(ByVal p As DbStk Ptr)
    'delete all data - Modifies Container Data
    Local node As DbStkNode Ptr
    ExitS(p=0 Or @p.tag<>DbStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function DbStkCount(ByVal p As DbStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>DbStkTag, LibErrH)
    Function = @p.count
End Function

Sub DbStkPush(ByVal p As DbStk Ptr, ByVal value As Double)
    'push value on top of stack
    Local node As DbStkNode Ptr
    ExitS(p=0 Or @p.tag<>DbStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(DbStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(DbStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function DbStkPeek(ByVal p As DbStk Ptr) As Double
    'get top value on stack
    ExitF(p=0 Or @p.tag<>DbStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function DbStkPop(ByVal p As DbStk Ptr) As Double
    'get and remove top value on stack
    Local node As DbStkNode Ptr
    ExitF(p=0 Or @p.tag<>DbStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
