#Include This Once
#Include Once "C:\HLib3\String\WsStr.inc"
#Include Once "C:\HLib3\Stack\LnStk.inc"

'++
    '----------------------------------------------------------------------------------------
    '   String Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = WsStkNew() 'get handle for new container
    '       h = WsStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro WsStkTag = -1119369189
Type WsStk
    tag As Long
    stk As LnStk Ptr
End Type

Function WsStkNew() As Long
    'allocate new container - return handle
    Local p As WsStk Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsStkTag
    @p.stk = LnStkNew() : If Err Then Exit Function
    Function = p
End Function

Function WsStkFinal(ByVal p As WsStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>WsStkTag, LibErrH)
        WsStkClear p
        @p.stk = LnStkFinal(@p.stk)
        MemFree(p)
    End If
End Function

Function WsStkValidate(ByVal p As WsStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = WsStkTag Then Function = @p.tag
End Function

Sub WsStkClear(ByVal p As WsStk Ptr)
    'delete all data - Modifies Container Data
    ExitS(p=0 Or @p.tag<>WsStkTag, LibErrH)
    While @p.@stk.count
        WsFinal(LnStkPop(@p.stk))
    Wend
End Sub

Function WsStkCount(ByVal p As WsStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>WsStkTag, LibErrH)
    Function = @p.@stk.count
End Function

Sub WsStkPush(ByVal p As WsStk Ptr, ByRef value As WString)
    'push value on top of stack
    ExitS(p=0 Or @p.tag<>WsStkTag, LibErrH)
    LnStkPush @p.stk, WsSetNew(value)
End Sub

Function WsStkPeek(ByVal p As WsStk Ptr) As WString
    'get top value on stack
    ExitF(p=0 Or @p.tag<>WsStkTag, LibErrH)
    If @p.@stk.count Then Function = WsGet(LnStkPeek(@p.stk))
End Function

Function WsStkPop(ByVal p As WsStk Ptr) As WString
    'get and remove top value on stack
    Local h As Long
    ExitF(p=0 Or @p.tag<>WsStkTag, LibErrH)
    If @p.@stk.count Then
        h = LnStkPop(@p.stk)
        Function = WsGet(h)
        WsFinal(h)
    End If
End Function
