#Dim All
#Compile Exe "BuildSLL.exe"
#Link "SsLst.sll"

Function IsProc(ByVal s As String) As Long
    If InStr(s, "=") = 0 Then
        s = Shrink$(LCase$(s), $WhiteSpace)
        If InStr(s, "sub ")=1 Or InStr(s, "function ")=1 Then
            If InStr(s, " private")=0 Then Function = 1
        End If
    End If
End Function
Function IsComment(ByVal s As String) As Long
    s = Shrink$(LCase$(s), $WhiteSpace)
    If InStr(s, "'") = 1 Then Function = 1
End Function
Function IsMarkerStart(ByVal s As String) As Long
    If InStr(s, "'++") = 1 Then Function = 1
End Function
Function IsMarkerEnd(ByVal s As String) As Long
    If InStr(s, "'--") = 1 Then Function = 1
End Function
Function IsInc(ByVal s As String) As Long
    If InStr(s, "#Include Once") = 1 And IsFalse InStr(s, "WIN32API.INC") And IsFalse InStr(s, "HLib.inc") Then Function = 1
End Function
Function IsIncWin32(ByVal s As String) As Long
    If InStr(s, "#Include Once") = 1 And InStr(s, "WIN32API.INC") Then Function = 1
End Function
Function IsType(ByVal s As String) As Long
    If InStr(s, "Type ") = 1 Then Function = 1
End Function
Function IsTypeEnd(ByVal s As String) As Long
    If InStr(s, "End Type") = 1 Then Function = 1
End Function
Function HaltOnError(ByVal s As String) As Long
    If InStr(s, "%HaltOnError") = 1 Then Function = 1
End Function
Function MustInc(ByVal s As String) As Long
    If InStr(s, "!!! must include !!!") Then Function = 1
End Function
Function GotPtr(ByVal s As String) As Long
    If InStr(s, " Ptr") Then Function = 1
End Function

Function PBMain()
    Local folders As Long

    folders = SsLstNew()
    SsLstAdd folders, "C:\HLib3\Array\"
    SsLstAdd folders, "C:\HLib3\DeepTree\"
    SsLstAdd folders, "C:\HLib3\Hash\"
    SsLstAdd folders, "C:\HLib3\List\"
    'SsLstAdd folders, "C:\HLib3\Locker\"
    SsLstAdd folders, "C:\HLib3\MultiHash\"
    SsLstAdd folders, "C:\HLib3\MultiSet\"
    SsLstAdd folders, "C:\HLib3\MultiTree\"
    SsLstAdd folders, "C:\HLib3\Queue\"
    SsLstAdd folders, "C:\HLib3\Set\"
    SsLstAdd folders, "C:\HLib3\Stack\"
    SsLstAdd folders, "C:\HLib3\String\"
    SsLstAdd folders, "C:\HLib3\Tree\"
    SsLstAdd folders, "C:\HLib3\Trie\"

    ClearSLL folders
    CompileFiles folders
    BuildIncFiles folders
    CopySamples folders

    FileCopy "C:\HLib3\ChangeLog.txt", "C:\HLibSLL3\ChangeLog.txt"
    FileCopy "C:\HLib3\LibErr.inc", "C:\HLibSLL3\LibErr.inc"
    ''FileCopy "C:\HLib3\ReadMe.txt", "C:\HLibSLL3\ReadMe.txt"

    ? "done..."

    folders = SsLstFinal(folders)
End Function

Sub CopySamples(ByVal folders As Long)
    Local inFile, outFile As String
    Local s As String
    Local folder As Long
    Local files, file As Long
    Local fileText, textLine As Long

    files = SsLstNew()
    fileText = SsLstNew()

    folder = SsLstFirst(folders)
    While folder
        SsLstGetPaths files, SsLstGet(folder) + "Samples\", "*.bas"
        file = SsLstFirst(files)
        While file
            inFile = SsLstGet(file)
            outFile = inFile
            Replace "\HLib3\" With "\HLibSLL3\" In outFile
            SsLstTextLoad fileText, inFile
            textLine = SsLstFirst(fileText)
            While textLine
                If HaltOnError(SsLstGet(textLine)) Then
                    textLine = SsLstPrev(textLine)
                    SsLstDelNext fileText, textLine
                ElseIf IsInc(SsLstGet(textLine)) Then
                    If MustInc(SsLstGet(textLine)) Then SsLstInsPrev fileText, textLine, SsLstGet(textLine)
                    s = SsLstGet(textLine)
                    If InStr(s, "'") Then s = Left$(s, InStr(s, "'") - 1)
                    Replace "#Include Once" With "#Link " In s
                    Replace ".inc" With ".sll" In s
                    SsLstSet textLine, s
                End If
                textLine = SsLstNext(textLine)
            Wend
            SsLstTextSave fileText, outFile
            file = SsLstNext(file)
        Wend
        folder = SsLstNext(folder)
    Wend
    files = SsLstFinal(files)
    fileText = SsLstFinal(fileText)
End Sub

Sub BuildIncFiles(ByVal folders As Long)
    Local inFile, outFile, sllFile As String
    Local s As String
    Local folder As Long
    Local files, file As Long
    Local inText, textLine, temp As Long
    Local outText As Long

    files = SsLstNew()
    inText = SsLstNew()
    outText = SsLstNew()

    folder = SsLstFirst(folders)
    While folder
        SsLstGetPaths files, SsLstGet(folder), "*.inc"
        file = SsLstFirst(files)
        While file
            inFile = SsLstGet(file)
            outFile = infile
            Replace "\HLib3\" With "\HLibSLL3\" In outFile
            sllFile = Mid$(inFile, InStr(-1, infile, "\") + 1)
            Replace ".inc" With ".sll" In sllFile
            SsLstTextLoad inText, inFile
            '
            SsLstClear outText
            SsLstAdd outText, "'don't need to include this file unless it contains a required UDT"
            SsLstAdd outText, "'build date: " + Date$
            SsLstAdd outText, "'errors added to log file in app folder: Exe.Path$+""HLib.log"""
            SsLstAdd outText, "'public domain - use at own risk"
            SsLstAdd outText, ""
            SsLstAdd outText, "    'Naming Convention"
            SsLstAdd outText, "    '    Variable Types:"
            SsLstAdd outText, "    '        Bt = Byte"
            SsLstAdd outText, "    '        In = Integer"
            SsLstAdd outText, "    '        Wd = Word"
            SsLstAdd outText, "    '        Ln = Long"
            SsLstAdd outText, "    '        Dw = Dword"
            SsLstAdd outText, "    '        Qd = Quad"
            SsLstAdd outText, "    '        Sn = Single"
            SsLstAdd outText, "    '        Db = Double"
            SsLstAdd outText, "    '        Cu = Currency"
            SsLstAdd outText, "    '        Cx = CurrencyX"
            SsLstAdd outText, "    '        Ex = Extended"
            SsLstAdd outText, "    '        Ss = String"
            SsLstAdd outText, "    '        Ws = WString"
            SsLstAdd outText, "    '        Sz = StringZ"
            SsLstAdd outText, "    '        Wz = WStringZ"
            SsLstAdd outText, "    '        Oj = Object"
            SsLstAdd outText, "    '        Ut = UDT"
            SsLstAdd outText, "    '        Sc = String Character"
            SsLstAdd outText, "    '        Wc = WString Character"
            SsLstAdd outText, "    '    Containers:"
            SsLstAdd outText, "    '        Str = String Buffer container"
            SsLstAdd outText, "    '        Arr = Array container"
            SsLstAdd outText, "    '        Lst = List container"
            SsLstAdd outText, "    '        Stk = Stack container"
            SsLstAdd outText, "    '        Que = Queue container"
            SsLstAdd outText, "    '        Dqu = Deque"
            SsLstAdd outText, "    '        Pri = Priority Queue"
            SsLstAdd outText, "    '        Tre = Tree Container"
            SsLstAdd outText, "    '        Tri = Tire Tree Containera - Radix Tree"
            SsLstAdd outText, "    '        Hsh = Hash Container"
            SsLstAdd outText, "    '        Set = Set Container"
            SsLstAdd outText, "    '        Cur = Currsor"
            SsLstAdd outText, "    '        Ech = For Each Cursor"
            SsLstAdd outText, "    '        MTre = MultiTree"
            SsLstAdd outText, "    '        MHsh = MultiHash"
            SsLstAdd outText, "    '        MSet = MultiSet"
            SsLstAdd outText, "    '        DTre = Deep Tree"
            SsLstAdd outText, ""
            '
            textLine = SsLstFirst(inText)
            While textLine
                If IsMarkerStart(SsLstGet(textLine)) Then
                    SsLstAdd outText, ""
                    temp = SsLstNext(textLine)
                    While temp And IsFalse IsMarkerEnd(SsLstGet(temp))
                        SsLstAdd outText, SsLstGet(temp)
                        temp = SsLstNext(temp)
                    Wend
                ElseIf IsProc(SsLstGet(textLine)) Then
                    SsLstAdd outText, ""
                    s = "Declare " + SsLstGet(textLine)
                    Replace " ThreadSafe" With "" In s
                    s = Shrink$(s, $WhiteSpace)
                    SsLstAdd outText, PtrToHandle(s)
                    temp = SsLstNext(textLine)
                    While temp
                        If IsFalse IsComment(SsLstGet(temp)) Then Exit Loop
                        SsLstAdd outText, SsLstGet(temp)
                        temp = SsLstNext(temp)
                    Wend
                End If
                textLine = SsLstNext(textLine)
            Wend
            SsLstTextSave outText, outFile
            file = SsLstNext(file)
        Wend
        folder = SsLstNext(folder)
    Wend
    files = SsLstFinal(files)
    inText = SsLstFinal(inText)
    outText = SsLstFinal(outText)
End Sub

Sub CompileFiles(ByVal folders As Long)
    Local folder As Long
    Local files, file As Long
    Local inText, thisText As Long
    Local outText As Long
    Local inFile, outFile, sllFile As String
    Local s As String
    Local x As Long

    files = SsLstNew()
    inText = SsLstNew()
    outText = SsLstNew()

    folder = SsLstFirst(folders)
    While folder
        SsLstGetPaths files, SsLstGet(folder), "*.inc"
        file = SsLstFirst(files)
        While file
            inFile = SsLstGet(file)
            outFile = RTrim$(inFile, ".inc") + "_Compile.bas"
            sllFile = RTrim$(inFile, ".inc") + ".sll"
            Replace "\HLib3\" With "\HLibSLL3\" In sllFile
            SsLstTextLoad inText, inFile
            '
            SsLstClear outText
            SsLstAdd outText, "#Dim All"
            SsLstAdd outText, "#Compile SLL " + $Dq + sllFile + $Dq
            SsLstAdd outText, "#Include Once " + $Dq + inFile + $Dq
            thisText = SsLstFirst(inText)
            While thisText
                If IsProc(SsLstGet(thisText)) Then
                    s = "Declare " + SsLstGet(thisText)
                    x = InStr(-1, s, ")")
                    s = Left$(s, x) + " common " + Mid$(s, x + 1)
                    Replace " ThreadSafe" With " " In s
                    Replace "  " With " " In s
                    Replace "  " With " " In s
                    SsLstAdd outText, s
                End If
                thisText = SsLstNext(thisText)
            Wend
            '
            SsLstTextSave outText, outFile
            Shell "C:\PBWin10\bin\PBWin.exe /IC:\PBWin10\WinAPI " + outFile
            Sleep 50
            Kill outFile
            '
            file = SsLstNext(file)
        Wend
        folder = SsLstNext(folder)
    Wend
    files = SsLstFinal(files)
    inText = SsLstFinal(inText)
    outText = SsLstFinal(outText)
End Sub

Sub ClearSLL(ByVal folders As Long)
    Local folder As Long
    Local files, file As Long
    Local thisFolder, thisSample As String

    files = SsLstNew()

    folder = SsLstFirst(folders)
    While folder
        thisFolder = SsLstGet(folder)
        Replace "\HLib3\" With "\HLibSLL3\" In thisFolder
        thisSample = thisFolder + "Samples\"
        If IsFalse IsFolder(thisFolder) Then MkDir thisFolder
        If IsFalse IsFolder(thisSample) Then MkDir thisSample
        'delete SLL files
        SsLstGetPaths files, thisFolder, "*.*"
        file = SsLstFirst(files)
        While file
            Kill SsLstGet(file)
            file = SsLstNext(file)
        Wend
        'delete thisSample
        SsLstGetPaths files, thisSample, "*.*"
        file = SsLstFirst(files)
        While file
            Kill SsLstGet(file)
            file = SsLstNext(file)
        Wend
        folder = SsLstNext(folder)
    Wend

    SsLstGetPaths files, "C:\TLibSLL\", "*.*"
    file = SsLstFirst(files)
    While file
        Kill SsLstGet(file)
        file = SsLstNext(file)
    Wend

    files = SsLstFinal(files)
End Sub

Function PtrToHandle(ByVal s As String) As String
    Local i, x, y As Long
    Local args As Long
    Local arg, arg2 As String
    Local a() As String
    x = InStr(s, "(") + 1
    y = InStr(-1, s, ")") - 1
    arg = Mid$(s, x, y - x + 1)
    arg2 = Shrink$(arg, $WhiteSpace)
    args = ParseCount(arg2, " ")
    If args > 4 Then
        ReDim a(1 To args)
        Parse arg2, a(), " "
        For i = 4 To args
            If a(i) = "Ptr" Or a(i) = "Ptr," Then
                Replace "Ptr" With "Long" In a(i)
                a(i-1) = ""
                a(i-3) = "h" + Mid$(a(i-3), 2)
            End If
        Next i
        arg2 = Join$(a(), " ")
        arg2 = Shrink$(arg2, $WhiteSpace)
        Replace arg With arg2 In s
    End If
    Function = s
End Function
