#Dim All
#Compile Exe "NoThreadSafe.exe"
#Link "SsLst.sll"

Function HasThreadSafe(ByVal s As String) As Long
    If IsFalse InStr(s, "=") Then
        s = Shrink$(LCase$(s), $WhiteSpace)
        If InStr(s, "sub ") = 1 Or InStr(s, "function ") = 1 Then
            If InStr(s, " threadsafe") Then Function = 1
        End If
    End If
End Function
Function Procedure(ByVal s As String) As Long
    If IsFalse InStr(s, "=") Then
        s = Shrink$(LCase$(s), $WhiteSpace)
        If InStr(s, "sub ") = 1 Or InStr(s, "function ") = 1 Then
            Function = 1
        End If
    End If
End Function


Function PBMain()
    Local counter As Long
    Local filePath As String
    Local x As Long
    Local s As String

    Local folders As Long
    Local files As Long
    Local codeText As Long
    Local codeNode As Long

    folders = SsLstNew()
    files = SsLstNew()
    codeText = SsLstNew()

    SsLstStkPush folders, "C:\HLib3\"
    SsLstStkPush folders, "C:\HLib3\Array\"
    SsLstStkPush folders, "C:\HLib3\Hash\"
    SsLstStkPush folders, "C:\HLib3\List\"
    'SsLstStkPush folders, "C:\HLib3\Locker\"
    SsLstStkPush folders, "C:\HLib3\MultiHash\"
    SsLstStkPush folders, "C:\HLib3\MultiTree\"
    SsLstStkPush folders, "C:\HLib3\Queue\"
    SsLstStkPush folders, "C:\HLib3\Stack\"
    SsLstStkPush folders, "C:\HLib3\String\"
    SsLstStkPush folders, "C:\HLib3\Tree\"
    SsLstStkPush folders, "C:\HLib3\Trie\"
    SsLstStkPush folders, "C:\HLib3\DeepTree\"

    While SsLstCount(folders)
        SsLstGetPaths files, SsLstStkPop(folders), "*.inc"
        While SsLstCount(files)
            filePath = SsLstStkPop(files)
            SsLstTextLoad codeText, filePath
            codeNode = SsLstFirst(codeText)
            While codeNode
                If SsLstMatch(codeNode, CodePtr(HasThreadSafe)) Then
                    Incr counter
                    s = SsLstGet(codeNode)
                    Replace " ThreadSafe" With "" In s
                    s = RTrim$(s)
                    SsLstSet codeNode, s
                ElseIf SsLstMatch(codeNode, CodePtr(Procedure)) Then
                    Incr counter
                    s = SsLstGet(codeNode)
                    While InStr(s, "  ")
                        Replace "  " With " " In s
                    Wend
                    s = RTrim$(s)
                    SsLstSet codeNode, s
                End If
                codeNode = SsLstNext(codeNode)
            Wend
            SsLstTextSave codeText, filePath
        Wend
    Wend

    ? "not ThreadSafe = " + Format$(counter, "#,") + $CrLf + "done..."

    folders = SsLstFinal(folders)
    files = SsLstFinal(files)
    codeText = SsLstFinal(codeText)
End Function
