#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\LnLst.inc"
#Include Once "C:\HLib3\List\SsLst.inc"
#Include Once "C:\HLib3\List\SsLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'Long/String ~ Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   - use MultiTree for one-to-many relationship
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = LnSsTreNew() 'get handle for new container
    '   h = LnSsTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--


Macro LnSsTreNodeTag = 513674861
Macro LnSsTreTag = 719713421
Type LnSsTreNode
    tag As Long
    P As LnSsTreNode Ptr
    L As LnSsTreNode Ptr
    R As LnSsTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As Long
End Type
Type LnSsTre
    tag As Long
    count As Long
    root As LnSsTreNode Ptr
End Type

Function LnSsTreNew() As Long
    'allocate new container - return handle
    Local p As LnSsTre Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = LnSsTreTag
    Function = p
End Function

Function LnSsTreFinal(ByVal pTree As LnSsTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>LnSsTreTag, LibErrH)
        LnSsTreClear pTree
        MemFree(pTree)
    End If
End Function

Function LnSsTreValidate(ByVal pTree As LnSsTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = LnSsTreTag Then Function = @pTree.tag
End Function

Sub LnSsTreClear(ByVal pTree As LnSsTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As LnSsTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = LnSsTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = LnSsTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            LnSsTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function LnSsTreCount(ByVal pTree As LnSsTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub LnSsTreSet(ByVal pTree As LnSsTre Ptr, ByVal key As Long, ByRef value As String, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local n As LnSsTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    If @pTree.root Then
        n = @pTree.root
        While 1
            If key > @n.K Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = LnSsTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    @n.@R.K = key
                    SsSet @n.@R.V, value
                    LnSsTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf key < @n.K Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = LnSsTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    @n.@L.K = key
                    SsSet @n.@L.V, value
                    LnSsTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then SsSet @n.V, value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = LnSsTreAllocNode(pTree) : If Err Then Exit Sub
        @pTree.@root.K = key
        SsSet @pTree.@root.V, value
        @pTree.count = 1
    End If
End Sub

Function LnSsTreGet(ByVal pTree As LnSsTre Ptr, ByVal key As Long) As String
    'get Key's associated Value
    Register k As Long : k = key
    Local n As LnSsTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    n = @pTree.root
    While n
        If k < @n.K Then
            n = @n.L
        ElseIf k > @n.K Then
            n = @n.R
        Else
            Function = SsGet(@n.V)
            Exit Loop
        End If
    Wend
End Function

Function LnSsTreGot(ByVal pTree As LnSsTre Ptr, ByVal key As Long) As Long
    'True/False if Key exist
    Register k As Long : k = key
    Local n As LnSsTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    n = @pTree.root
    While n
        If k < @n.K Then
            n = @n.L
        ElseIf k > @n.K Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
End Function

Sub LnSsTreDel(ByVal pTree As LnSsTre Ptr, ByVal key As Long)
    'remove Key and associated Value
    Local pNode As LnSsTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    pNode = LnSsTreGot(pTree, key)
    If pNode Then
        LnSsTreRemoveNode(pTree, pNode)
    End If
End Sub

Function LnSsTreFirst(ByVal pTree As LnSsTre Ptr) As Long
    'get handle to first node in tree
    Local n As LnSsTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function LnSsTreLast(ByVal pTree As LnSsTre Ptr) As Long
    'get handle to last node in tree
    Local n As LnSsTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function LnSsTreNext(ByVal pNode As LnSsTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As LnSsTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>LnSsTreNodeTag, LibErrH)
        minR = LnSsTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = LnSsTreParentGreater(pNode)
        End If
    End If
End Function

Function LnSsTrePrev(ByVal pNode As LnSsTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As LnSsTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>LnSsTreNodeTag, LibErrH)
        maxL = LnSsTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = LnSsTreParentLesser(pNode)
        End If
    End If
End Function

Function LnSsTreGetKey(ByVal pNode As LnSsTreNode Ptr) As Long
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>LnSsTreNodeTag, LibErrH)
    Function = @pNode.K
End Function

Function LnSsTreGetVal(ByVal pNode As LnSsTreNode Ptr) As String
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>LnSsTreNodeTag, LibErrH)
    Function = SsGet(@pNode.V)
End Function

Sub LnSsTreSetVal(ByVal pNode As LnSsTreNode Ptr, ByRef value As String)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>LnSsTreNodeTag, LibErrH)
    SsSet @pNode.V, value
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function LnSsTreClone(ByVal pTree As LnSsTre Ptr) As Long
    'create duplicate container
    Local h, clone As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    clone = LnSsTreNew() : If Err Then Exit Function
    h = LnSsTreFirst(pTree)
    While h
        LnSsTreSet clone, LnSsTreGetKey(h), LnSsTreGetVal(h)
        h = LnSsTreNext(h)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function LnSsTreStore(ByVal pTree As LnSsTre Ptr) As String
    'store container to string
    Local h, keys, vals, stor As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    keys = LnLstNew() : If Err Then Exit Function
    vals = SsLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        h = LnSsTreFirst(pTree)
        While h
            LnLstAdd keys, LnSsTreGetKey(h)
            SsLstAdd vals, LnSsTreGetVal(h)
            h = LnSsTreNext(h)
        Wend
        SsLstAdd stor, LnLstStore(keys)
        SsLstAdd stor, SsLstStore(vals)
        Function = SsLstStore(stor)
    End If
    keys = LnLstFinal(keys)
    vals = SsLstFinal(vals)
    stor = SsLstFinal(stor)
End Function

Sub LnSsTreRestore(ByVal pTree As LnSsTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, stor As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    LnSsTreClear pTree
    keys = LnLstNew() : If Err Then Exit Sub
    vals = SsLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>2, LibErrU)
        LnLstRestore keys, SsLstPopFirst(stor)
        SsLstRestore vals, SsLstPopFirst(stor)
        ExitS(LnLstCount(keys)<>SsLstCount(vals), LibErrU)
        While LnLstCount(keys)
            LnSsTreSet pTree, LnLstPopFirst(keys), SsLstPopFirst(vals)
        Wend
    End If
    keys = LnLstFinal(keys)
    vals = SsLstFinal(vals)
    stor = SsLstFinal(stor)
End Sub


'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub LnSsTreFileStore(ByVal pTree As LnSsTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    s = LnSsTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub LnSsTreFileRestore(ByVal pTree As LnSsTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnSsTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        LnSsTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub LnSsTreRemoveNode(ByVal p As LnSsTre Ptr, ByVal n As LnSsTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As LnSsTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, LnSsTreMaxLeft(n), LnSsTreMinRight(n))
        If @p.root = n Then @p.root = swapN
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        n = swapN
    Wend
    If n = @p.root Then
        LnSsTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = LnSsTreFreeNode(p, n)
        LnSsTreBalanceBranch p, nP
    End If
End Sub

Function LnSsTreAllocNode(ByVal p As LnSsTre Ptr) Private As Long
    Local n As LnSsTreNode Ptr
    n = MemAlloc(SizeOf(LnSsTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.V = SsNew() : If Err Then Exit Function
    @n.tag = LnSsTreNodeTag
    Incr @p.count
    Function = n
End Function

Function LnSsTreFreeNode(ByVal p As LnSsTre Ptr, ByVal n As LnSsTreNode Ptr) As Long
    If n Then
        @n.V = SsFinal(@n.V)
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub LnSsTreBalanceBranch(ByVal p As LnSsTre Ptr, ByVal n As LnSsTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = LnSsTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = LnSsTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function LnSsTreMaxLeft(ByVal n As LnSsTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function LnSsTreMinRight(ByVal n As LnSsTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function LnSsTreParentGreater(ByVal n As LnSsTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function LnSsTreParentLesser(ByVal n As LnSsTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function LnSsTreRotateLeft(ByVal p As LnSsTre Ptr, ByVal n As LnSsTreNode Ptr) Private As Long
    Local nR, nRL As LnSsTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function LnSsTreRotateRight(ByVal p As LnSsTre Ptr, ByVal n As LnSsTreNode Ptr) Private As Long
    Local nL, nLR As LnSsTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
