#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\SsLst.inc"
#Include Once "C:\HLib3\List\WsLst.inc"
#Include Once "C:\HLib3\List\LnLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'WString/Long ~ Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - no limit on Key length
    '   - use WsLnTreComparison() to change how Keys compared
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   - use MultiTree for one-to-many relationship
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = WsLnTreNew() 'get handle for new container
    '   h = WsLnTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--


Macro WsLnTreNodeTag = 1320870834
Macro WsLnTreTag = -212996673
Type WsLnTreNode
    tag As Long
    P As WsLnTreNode Ptr
    L As WsLnTreNode Ptr
    R As WsLnTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As Long
End Type
Type WsLnTre
    tag As Long
    count As Long
    root As WsLnTreNode Ptr
    compareCB As Long
    collation As WsStr Ptr
End Type

Function WsLnTreNew() As Long
    'allocate new container - return handle
    Local p As WsLnTre Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsLnTreTag
    @p.compareCB = CodePtr(WsCompare)
    @p.collation = WsNew() : If Err Then Exit Function
    Function = p
End Function

Function WsLnTreFinal(ByVal pTree As WsLnTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>WsLnTreTag, LibErrH)
        @pTree.collation = WsFinal(@pTree.collation)
        WsLnTreClear pTree
        MemFree(pTree)
    End If
End Function

Function WsLnTreValidate(ByVal pTree As WsLnTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = WsLnTreTag Then Function = @pTree.tag
End Function

Sub WsLnTreComparison(ByVal pTree As WsLnTre Ptr, ByVal compareUCase As Long, ByVal collationSequence As WString)
    'set how WStrings compared
    'default = case ignored
    'if collationSequence WString provided then
    '   WStrings are compared using the order of the collation sequence WString
    '   collation WString must be 65536 characters
    'else if compareUCase = True then
    '   WStrings compared UCase
    ExitS(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    @pTree.compareCB = CodePtr(WsCompare)
    WsClear @pTree.collation
    If Len(collationSequence) Then
        ExitS(Len(collationSequence)<>65536, LibErrS)
        WsSet @pTree.collation, collationSequence : If Err Then Exit Sub
        @pTree.compareCB = CodePtr(WsCompareCollate)
    ElseIf compareUCase Then
        @pTree.compareCB = CodePtr(WsCompareUCase)
    End If
End Sub

Sub WsLnTreClear(ByVal pTree As WsLnTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As WsLnTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = WsLnTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = WsLnTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            WsLnTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function WsLnTreCount(ByVal pTree As WsLnTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub WsLnTreSet(ByVal pTree As WsLnTre Ptr, ByRef key As WString, ByVal value As Long, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local compare, temp As Long
    Local n As WsLnTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Sub
    If @pTree.root Then
        n = @pTree.root
        While 1
            Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
            If compare > 0 Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = WsLnTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    WsSet @n.@R.K, key
                    @n.@R.V = value
                    WsLnTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf compare < 0 Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = WsLnTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    WsSet @n.@L.K, key
                    @n.@L.V = value
                    WsLnTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then @n.V = value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = WsLnTreAllocNode(pTree) : If Err Then Exit Sub
        WsSet @pTree.@root.K, key
        @pTree.@root.V = value
        @pTree.count = 1
    End If
    temp = WsFinal(temp)
End Sub

Function WsLnTreGet(ByVal pTree As WsLnTre Ptr, ByRef key As WString) As Long
    'get Key's associated Value
    Local compare, temp As Long
    Local n As WsLnTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = @n.V
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Function WsLnTreGot(ByVal pTree As WsLnTre Ptr, ByRef key As WString) As Long
    'True/False if Key exist
    Local compare, temp As Long
    Local n As WsLnTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Sub WsLnTreDel(ByVal pTree As WsLnTre Ptr, ByRef key As WString)
    'remove Key and associated Value
    Local pNode As WsLnTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    pNode = WsLnTreGot(pTree, key)
    If pNode Then
        WsLnTreRemoveNode(pTree, pNode)
    End If
End Sub

Function WsLnTreFirst(ByVal pTree As WsLnTre Ptr) As Long
    'get handle to first node in tree
    Local n As WsLnTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function WsLnTreLast(ByVal pTree As WsLnTre Ptr) As Long
    'get handle to last node in tree
    Local n As WsLnTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function WsLnTreNext(ByVal pNode As WsLnTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As WsLnTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsLnTreNodeTag, LibErrH)
        minR = WsLnTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = WsLnTreParentGreater(pNode)
        End If
    End If
End Function

Function WsLnTrePrev(ByVal pNode As WsLnTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As WsLnTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsLnTreNodeTag, LibErrH)
        maxL = WsLnTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = WsLnTreParentLesser(pNode)
        End If
    End If
End Function

Function WsLnTreGetKey(ByVal pNode As WsLnTreNode Ptr) As WString
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>WsLnTreNodeTag, LibErrH)
    Function = WsGet(@pNode.K)
End Function

Function WsLnTreGetVal(ByVal pNode As WsLnTreNode Ptr) As Long
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>WsLnTreNodeTag, LibErrH)
    Function = @pNode.V
End Function

Sub WsLnTreSetVal(ByVal pNode As WsLnTreNode Ptr, ByVal value As Long)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>WsLnTreNodeTag, LibErrH)
    @pNode.V = value
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function WsLnTreClone(ByVal pTree As WsLnTre Ptr) As Long
    'create duplicate container
    Local h, clone As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    clone = WsLnTreNew() : If Err Then Exit Function
    h = WsLnTreFirst(pTree)
    While h
        WsLnTreSet clone, WsLnTreGetKey(h), WsLnTreGetVal(h)
        h = WsLnTreNext(h)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function WsLnTreStore(ByVal pTree As WsLnTre Ptr) As String
    'store container to string
    Local h, keys, vals, stor As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    keys = WsLstNew() : If Err Then Exit Function
    vals = LnLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        h = WsLnTreFirst(pTree)
        While h
            WsLstAdd keys, WsLnTreGetKey(h)
            LnLstAdd vals, WsLnTreGetVal(h)
            h = WsLnTreNext(h)
        Wend
        SsLstAdd stor, WsLstStore(keys)
        SsLstAdd stor, LnLstStore(vals)
        Function = SsLstStore(stor)
    End If
    keys = WsLstFinal(keys)
    vals = LnLstFinal(vals)
    stor = SsLstFinal(stor)
End Function

Sub WsLnTreRestore(ByVal pTree As WsLnTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, stor As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    WsLnTreClear pTree
    keys = WsLstNew() : If Err Then Exit Sub
    vals = LnLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>2, LibErrU)
        WsLstRestore keys, SsLstPopFirst(stor)
        LnLstRestore vals, SsLstPopFirst(stor)
        ExitS(WsLstCount(keys)<>LnLstCount(vals), LibErrU)
        While WsLstCount(keys)
            WsLnTreSet pTree, WsLstPopFirst(keys), LnLstPopFirst(vals)
        Wend
    End If
    keys = WsLstFinal(keys)
    vals = LnLstFinal(vals)
    stor = SsLstFinal(stor)
End Sub


'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub WsLnTreFileStore(ByVal pTree As WsLnTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    s = WsLnTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub WsLnTreFileRestore(ByVal pTree As WsLnTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsLnTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        WsLnTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub WsLnTreRemoveNode(ByVal p As WsLnTre Ptr, ByVal n As WsLnTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As WsLnTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, WsLnTreMaxLeft(n), WsLnTreMinRight(n))
        If @p.root = n Then @p.root = swapN
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        n = swapN
    Wend
    If n = @p.root Then
        WsLnTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = WsLnTreFreeNode(p, n)
        WsLnTreBalanceBranch p, nP
    End If
End Sub

Function WsLnTreAllocNode(ByVal p As WsLnTre Ptr) Private As Long
    Local n As WsLnTreNode Ptr
    n = MemAlloc(SizeOf(WsLnTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.tag = WsLnTreNodeTag
    @n.K = WsNew() : If Err Then Exit Function
    Incr @p.count
    Function = n
End Function

Function WsLnTreFreeNode(ByVal p As WsLnTre Ptr, ByVal n As WsLnTreNode Ptr) As Long
    If n Then
        @n.K = WsFinal(@n.K)
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub WsLnTreBalanceBranch(ByVal p As WsLnTre Ptr, ByVal n As WsLnTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = WsLnTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = WsLnTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function WsLnTreMaxLeft(ByVal n As WsLnTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function WsLnTreMinRight(ByVal n As WsLnTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function WsLnTreParentGreater(ByVal n As WsLnTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsLnTreParentLesser(ByVal n As WsLnTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsLnTreRotateLeft(ByVal p As WsLnTre Ptr, ByVal n As WsLnTreNode Ptr) Private As Long
    Local nR, nRL As WsLnTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function WsLnTreRotateRight(ByVal p As WsLnTre Ptr, ByVal n As WsLnTreNode Ptr) Private As Long
    Local nL, nLR As WsLnTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
