'WdArr.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\WdArr.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    Local arr As Long
    Local clone As Long

    arr = WdArrNew() 'allocate new container

    Randomize
    ListBox Reset CbHndl, lbxID
    Count = 100000

    ListBox Add CbHndl, lbxID, "append 10,000 values to empty array - ReDim automatic"
    d = Timer
    For i = 1 To 10000
        WdArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WdArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "insert 10,000 values into empty array at index #1 - ReDim automatic"
    WdArrClear arr
    WdArrAdd arr, 0
    d = Timer
    For i = 1 To 10000
        WdArrIns arr, 1, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WdArrCount(arr), "#,")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "ReDim array to " + Format$(Count, "#,")
    WdArrReDim arr, Count

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "set all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        WdArrSet arr, i, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "get and test all "+Format$(Count, "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If WdArrGet(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'reverse array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "reverse array"
    d = Timer
    WdArrReverse arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, WdArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, WdArrCount(arr)))

    'sort array

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "sort array"
    d = Timer
    WdArrSort arr
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")
    ListBox Add CbHndl, lbxID, "-- first 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, 1))
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, 2))
    ListBox Add CbHndl, lbxID, "-- last 2 values ---"
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, WdArrCount(arr) - 1))
    ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, WdArrCount(arr)))

    'test sort
    For i = 1 To WdArrCount(arr) - 1
        If WdArrGet(arr, i) > WdArrGet(arr, i + 1) Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i

    'binary search

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "binary search for all "+Format$(WdArrCount(arr), "#,")+" values in array"
    d = Timer
    For i = 1 To Count
        If WdArrBinSearch(arr, i) <> i Then
            ? "fail at: " + Format$(i) : Exit For
        End If
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.00000")

    'binary insert - insert value in sort order

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear array"
    WdArrClear arr
    ListBox Add CbHndl, lbxID, "binary insert 10 random values: Rnd(1, 5)"
    For i = 1 To 10
        WdArrBinInsert arr, Rnd(1, 5)
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, i))
    Next i

    'unique - delete all duplicates

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "unique array"
    WdArrUniqueSort arr
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, i))
    Next i

    'remove

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "remove all odd numbers"
    For i = WdArrCount(arr) To 1 Step -1
        If WdArrGet(arr, i) Mod 2 Then WdArrDel arr, i
    Next i
    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, i))
    Next i

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack"
    ListBox Add CbHndl, lbxID, "Push 1, 2, 3 on Stack"
    WdArrClear arr
    WdArrStkPush arr, 1
    WdArrStkPush arr, 2
    WdArrStkPush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While WdArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek() = " + Format$(WdArrStkPeek(arr))
        ListBox Add CbHndl, lbxID, "Pop() = " + Format$(WdArrStkPop(arr))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Queue"
    WdArrClear arr
    WdArrQuePush arr, 1
    WdArrQuePush arr, 2
    WdArrQuePush arr, 3
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While WdArrCount(arr)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(WdArrQuePeek(arr))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(WdArrQuePop(arr))
    Wend

    'Deque - double-ended Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque - double-ended Queue"
    ListBox Add CbHndl, lbxID, "Add 1, 2, 3 to Front of Deque"
    WdArrClear arr
    WdArrPushFirst arr, 1
    WdArrPushFirst arr, 2
    WdArrPushFirst arr, 3
    ListBox Add CbHndl, lbxID, "Add 4, 5, 6 to End of Deque"
    WdArrPushLast arr, 4
    WdArrPushLast arr, 5
    WdArrPushLast arr, 6
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While WdArrCount(arr)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(WdArrPeekFirst(arr))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(WdArrPopFirst(arr))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(WdArrPeekLast(arr))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(WdArrPopLast(arr))
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Clone"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to array"
    WdArrClear arr
    For i = 1 To 3
        WdArrAdd arr, i
    Next i
    ListBox Add CbHndl, lbxID, "clone array"
    clone = WdArrClone(arr)
    ListBox Add CbHndl, lbxID, "display Clone"
    For i = 1 To WdArrCount(clone)
        ListBox Add CbHndl, lbxID, Format$(WdArrGet(clone, i))
    Next i

    'Store/Restore: store/restore container to/from string

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to String"
    s = WdArrStore(arr)

    ListBox Add CbHndl, lbxID, "clear array"
    WdArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from String"
    WdArrRestore arr, s

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, i))
    Next i

    'FileStore/FileRestore: store/restore container to/from file

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store array to File"
    WdArrFileStore arr, "test.data"

    ListBox Add CbHndl, lbxID, "clear array"
    WdArrClear arr

    ListBox Add CbHndl, lbxID, "restore array from File"
    WdArrFileRestore arr, "test.data"

    ListBox Add CbHndl, lbxID, "-- display array --"
    For i = 1 To WdArrCount(arr)
        ListBox Add CbHndl, lbxID, Str$(WdArrGet(arr, i))
    Next i

    If IsFile("test.data") Then Kill "test.data"

    'must free handles before they go out of scope
    arr = WdArrFinal(arr)
    clone = WdArrFinal(clone)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "WdArr.bas", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
