 #Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\SsLst.inc"
#Include Once "C:\HLib3\List\WsLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'WString/WString ~ Deep Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - no limit on Key length
    '   - use WsWsDTreComparison() to change how Keys compared
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = WsWsDTreNew() 'get handle for new container
    '   h = WsWsDTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Global gWsWsDTreCompareCB As Long

Macro WsWsDTreNodeTag = 1927764680
Macro WsWsDTreTag = -274384610
Type WsWsDTreNode
    tag As Long
    P As WsWsDTreNode Ptr
    L As WsWsDTreNode Ptr
    R As WsWsDTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As Long
    T As Long
End Type
Type WsWsDTre
    tag As Long
    count As Long
    root As WsWsDTreNode Ptr
End Type

Function WsWsDTreNew() As Long
    'allocate new container - return handle
    Local p As WsWsDTre Ptr
    Err = 0
    gWsWsDTreCompareCB = CodePtr(WsCompareUCase)
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsWsDTreTag
    Function = p
End Function

Function WsWsDTreFinal(ByVal pTree As WsWsDTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>WsWsDTreTag, LibErrH)
        WsWsDTreClear pTree
        MemFree(pTree)
    End If
End Function

Function WsWsDTreValidate(ByVal pTree As WsWsDTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = WsWsDTreTag Then Function = @pTree.tag
End Function

Sub WsWsDTreClear(ByVal pTree As WsWsDTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As WsWsDTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = WsWsDTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = WsWsDTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            WsWsDTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function WsWsDTreCount(ByVal pTree As WsWsDTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub WsWsDTreSet(ByVal pTree As WsWsDTre Ptr, ByRef key As WString, ByRef value As WString, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local compare, temp As Long
    Local n As WsWsDTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Sub
    If @pTree.root Then
        n = @pTree.root
        While 1
            Call Dword gWsWsDTreCompareCB Using WsCompareCB(temp, @n.K, 0) To compare
            If compare > 0 Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = WsWsDTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    WsSet @n.@R.K, key
                    WsSet @n.@R.V, value
                    WsWsDTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf compare < 0 Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = WsWsDTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    WsSet @n.@L.K, key
                    WsSet @n.@L.V, value
                    WsWsDTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then WsSet @n.V, value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = WsWsDTreAllocNode(pTree) : If Err Then Exit Sub
        WsSet @pTree.@root.K, key
        WsSet @pTree.@root.V, value
        @pTree.count = 1
    End If
    temp = WsFinal(temp)
End Sub

Function WsWsDTreGet(ByVal pTree As WsWsDTre Ptr, ByRef key As WString) As WString
    'get Key's associated Value
    Local compare, temp As Long
    Local n As WsWsDTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword gWsWsDTreCompareCB Using WsCompareCB(temp, @n.K, 0) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = WsGet(@n.V)
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Function WsWsDTreGot(ByVal pTree As WsWsDTre Ptr, ByRef key As WString) As Long
    'True/False if Key exist
    Local compare, temp As Long
    Local n As WsWsDTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword gWsWsDTreCompareCB Using WsCompareCB(temp, @n.K, 0) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Sub WsWsDTreDel(ByVal pTree As WsWsDTre Ptr, ByRef key As WString)
    'remove Key and associated Value
    Local pNode As WsWsDTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    pNode = WsWsDTreGot(pTree, key)
    If pNode Then
        WsWsDTreRemoveNode(pTree, pNode)
    End If
End Sub

Function WsWsDTreFirst(ByVal pTree As WsWsDTre Ptr) As Long
    'get handle to first node in tree
    Local n As WsWsDTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function WsWsDTreLast(ByVal pTree As WsWsDTre Ptr) As Long
    'get handle to last node in tree
    Local n As WsWsDTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function WsWsDTreNext(ByVal pNode As WsWsDTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As WsWsDTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsWsDTreNodeTag, LibErrH)
        minR = WsWsDTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = WsWsDTreParentGreater(pNode)
        End If
    End If
End Function

Function WsWsDTrePrev(ByVal pNode As WsWsDTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As WsWsDTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsWsDTreNodeTag, LibErrH)
        maxL = WsWsDTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = WsWsDTreParentLesser(pNode)
        End If
    End If
End Function

Function WsWsDTreGetKey(ByVal pNode As WsWsDTreNode Ptr) As WString
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>WsWsDTreNodeTag, LibErrH)
    Function = WsGet(@pNode.K)
End Function

Function WsWsDTreGetVal(ByVal pNode As WsWsDTreNode Ptr) As WString
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>WsWsDTreNodeTag, LibErrH)
    Function = WsGet(@pNode.V)
End Function

Sub WsWsDTreSetVal(ByVal pNode As WsWsDTreNode Ptr, ByRef value As WString)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>WsWsDTreNodeTag, LibErrH)
    WsSet @pNode.V, value
End Sub

Function WsWsDTreGetChild(ByVal pNode As WsWsDTreNode Ptr) As Long
    'get node's Child Tree - null if node doesn't have a Child Tree
    ExitF(pNode=0 Or @pNode.tag<>WsWsDTreNodeTag, LibErrH)
    Function = @pNode.T
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Deep Tree
    '----------------------------------------------------------------------------------------
'--

Function WsWsDTreAddChildFor(ByVal pTree As WsWsDTre Ptr, ByRef key As WString) As Long
    'add Child Tree associated with Key - return Child Tree's handle
    'note: Key will be added with a null value if it isn't in the Tree
    Local n As WsWsDTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    n = WsWsDTreGot(pTree, key)
    If n = 0 Then
        WsWsDTreSet pTree, key, ""
        n = WsWsDTreGot(pTree, key)
    End If
    ExitF(n=0, LibErrU)
    If @n.T = 0 Then
        @n.T = WsWsDTreNew()
    End If
    Function = @n.T
End Function

Function WsWsDTreGetChildFor(ByVal pTree As WsWsDTre Ptr, ByRef key As WString) As Long
    'get Child Tree associated with Key - fail if Key not in Tree or Key doesn't have a Child Tree4
    Local n As WsWsDTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    n = WsWsDTreGot(pTree, key)
    If n Then
        Function = @n.T
    End If
End Function

Sub WsWsDTreDropChildFor(ByVal pTree As WsWsDTre Ptr, ByRef key As WString)
    'remove Keys associated Child Tree
    Local n As WsWsDTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    n = WsWsDTreGot(pTree, key)
    If n And @n.T Then
        @n.T = WsWsDTreFinal(@n.T)
    End If
End Sub

Sub WsWsDTreDeepClear(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString)
    'delete all data in Child Tree for last Key in keyPath
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    Local i, items, h As Long
    Local a() As WString
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items - 1
            h = WsWsDTreGetChildFor(h, a(i))
            If h = 0 Then Exit Sub
        Next i
        WsWsDTreClear h
    End If
End Sub

Function WsWsDTreDeepCount(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString) As Long
    'get number of items in Child Tree for last Key in keyPath
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    Local i, items, h As Long
    Local a() As WString
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items - 1
            h = WsWsDTreGetChildFor(h, a(i))
            If h = 0 Then Exit Function
        Next i
        Function = WsWsDTreCount(h)
    End If
End Function

Function WsWsDTreDeepGet(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString) As WString
    'get Value stored one, or more, levels deep in Tree
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    'returns the associated Value of last Key in keyPath
    Local i, items, h As Long
    Local a() As WString
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items - 1
            h = WsWsDTreGetChildFor(h, a(i))
            If h = 0 Then Exit Function
        Next i
        Function = WsWsDTreGet(h, a(items))
    End If
End Function

Sub WsWsDTreDeepSet(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString, ByRef value As WString, Opt ByVal DontReplace As Long)
    'add Key/Value to last Key in keyPath - Value replaced if Key exist unless DontReplace = True
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    'all the Keys in keyPath will be added if they don't exist
    Local i, items, h As Long
    Local a() As WString
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items - 1
            h = WsWsDTreAddChildFor(h, a(i))
            If h = 0 Then Exit Sub
        Next i
        WsWsDTreSet h, a(items), value, DontReplace
    End If
End Sub

Function WsWsDTreDeepGot(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString) As Long
    'True/False if all Keys in keyPath are in Tree
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    Local i, items, h As Long
    Local a() As WString
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items - 1
            h = WsWsDTreGetChildFor(h, a(i))
            If h = 0 Then Exit Function
        Next i
        Function = WsWsDTreGot(h, a(items))
    End If
End Function

Sub WsWsDTreDeepDel(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString)
    'remove Key from last Key in keyPath
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    Local i, items, h As Long
    Local a() As WString
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items - 1
            h = WsWsDTreGetChildFor(h, a(i))
            If h = 0 Then Exit Sub
        Next i
        WsWsDTreDel h, a(items)
    End If
End Sub

Function WsWsDTreDeepFirst(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString) As Long
    'get handle to first node in last Child Tree in keyPath
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    Local i, items, h As Long
    Local a() As WString
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items
            h = WsWsDTreGetChildFor(h, a(i))
            If h = 0 Then Exit Function
        Next i
        Function = WsWsDTreFirst(h)
    End If
End Function

Function WsWsDTreDeepLast(ByVal pTree As WsWsDTre Ptr, ByVal keyPath As WString) As Long
    'get handle to last node in last Child Tree in keyPath
    'keyPath = $Nul spearated list of parent Keys; Chr$$(0)
    Local i, items, h As Long
    Local a() As WString
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    h = pTree
    If Len(keyPath) Then
        items = ParseCount(keyPath, $Nul) : ReDim a(1 To items) : Parse keyPath, a(), $Nul
        For i = 1 To items
            h = WsWsDTreGetChildFor(h, a(i))
            If h = 0 Then Exit Function
        Next i
        Function = WsWsDTreLast(h)
    End If
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function WsWsDTreClone(ByVal pTree As WsWsDTre Ptr) As Long
    'create duplicate container
    Local clone, hChild As Long
    Local node, childNode As WsWsDTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    clone = WsWsDTreNew() : If Err Then Exit Function
    node = WsWsDTreFirst(pTree)
    While node
        WsWsDTreSet clone, WsWsDTreGetKey(node), WsWsDTreGetVal(node)
        If @node.T Then
            childNode = WsWsDTreGot(clone, WsWsDTreGetKey(node))
            ExitF(childNode=0, LibErrU)
            @childNode.T = WsWsDTreClone(@node.T)
        End If
        node = WsWsDTreNext(node)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function WsWsDTreStore(ByVal pTree As WsWsDTre Ptr) As String
    'store container to string
    Local keys, vals, deep, stor As Long
    Local node As WsWsDTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    keys = WsLstNew() : If Err Then Exit Function
    vals = WsLstNew() : If Err Then Exit Function
    deep = SsLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        node = WsWsDTreFirst(pTree)
        While node
            WsLstAdd keys, WsWsDTreGetKey(node)
            WsLstAdd vals, WsWsDTreGetVal(node)
            If @node.T Then
                SsLstAdd deep, WsWsDTreStore(@node.T)
            Else
                SsLstAdd deep, ""
            End If
            '
            node = WsWsDTreNext(node)
        Wend
        SsLstAdd stor, WsLstStore(keys)
        SsLstAdd stor, WsLstStore(vals)
        SsLstAdd stor, SsLstStore(deep)
        Function = SsLstStore(stor)
    End If
    keys = WsLstFinal(keys)
    vals = WsLstFinal(vals)
    deep = SsLstFinal(deep)
    stor = SsLstFinal(stor)
End Function

Sub WsWsDTreRestore(ByVal pTree As WsWsDTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, deep, stor, deepTree As Long
    Local key As WString
    Local sDeep As String
    Local node As WsWsDTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    WsWsDTreClear pTree
    keys = WsLstNew() : If Err Then Exit Sub
    vals = WsLstNew() : If Err Then Exit Sub
    deep = SsLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>3, LibErrU)
        WsLstRestore keys, SsLstPopFirst(stor)
        WsLstRestore vals, SsLstPopFirst(stor)
        SsLstRestore deep, SsLstPopFirst(stor)
        ExitS(WsLstCount(keys)<>WsLstCount(vals) Or WsLstCount(keys)<>SsLstCount(deep), LibErrU)
        While WsLstCount(keys)
            key = WsLstPopFirst(keys)
            sDeep = SsLstPopFirst(deep)
            WsWsDTreSet pTree, key, WsLstPopFirst(vals)
            If Len(sDeep) Then
                deepTree = WsWsDTreAddChildFor(pTree, key) : If Err Then Exit Sub
                WsWsDTreRestore deepTree, sDeep
            End If
        Wend
    End If
    keys = WsLstFinal(keys)
    vals = WsLstFinal(vals)
    deep = SsLstFinal(deep)
    stor = SsLstFinal(stor)
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub WsWsDTreFileStore(ByVal pTree As WsWsDTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    s = WsWsDTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub WsWsDTreFileRestore(ByVal pTree As WsWsDTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsWsDTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        WsWsDTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub WsWsDTreRemoveNode(ByVal p As WsWsDTre Ptr, ByVal n As WsWsDTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As WsWsDTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, WsWsDTreMaxLeft(n), WsWsDTreMinRight(n))
        If @p.root = swapN Then @p.root = n
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        Swap @n.T, @swapN.T
        n = swapN
    Wend
    If n = @p.root Then
        WsWsDTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = WsWsDTreFreeNode(p, n)
        WsWsDTreBalanceBranch p, nP
    End If
End Sub

Function WsWsDTreAllocNode(ByVal p As WsWsDTre Ptr) Private As Long
    Local n As WsWsDTreNode Ptr
    n = MemAlloc(SizeOf(WsWsDTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.tag = WsWsDTreNodeTag
    @n.K = WsNew() : If Err Then Exit Function
    @n.V = WsNew() : If Err Then Exit Function
    Incr @p.count
    Function = n
End Function

Function WsWsDTreFreeNode(ByVal p As WsWsDTre Ptr, ByVal n As WsWsDTreNode Ptr) Private As Long
    If n Then
        @n.K = WsFinal(@n.K)
        @n.V = WsFinal(@n.V)
        If @n.T Then @n.T = WsWsDTreFinal(@n.T)
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub WsWsDTreBalanceBranch(ByVal p As WsWsDTre Ptr, ByVal n As WsWsDTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = WsWsDTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = WsWsDTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function WsWsDTreMaxLeft(ByVal n As WsWsDTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function WsWsDTreMinRight(ByVal n As WsWsDTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function WsWsDTreParentGreater(ByVal n As WsWsDTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsWsDTreParentLesser(ByVal n As WsWsDTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsWsDTreRotateLeft(ByVal p As WsWsDTre Ptr, ByVal n As WsWsDTreNode Ptr) Private As Long
    Local nR, nRL As WsWsDTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function WsWsDTreRotateRight(ByVal p As WsWsDTre Ptr, ByVal n As WsWsDTreNode Ptr) Private As Long
    Local nL, nLR As WsWsDTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
