#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\Hash.inc"
#Include Once "C:\HLib3\String\WsStr.inc"
#Include Once "C:\HLib3\List\SsLst.inc"
#Include Once "C:\HLib3\List\WsLst.inc"
#Include Once "C:\HLib3\List\DwLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   WString/Dword ~ Hash Table Container
    '       http://en.wikipedia.org/wiki/Hash_table
    '       Key must be unique WString
    '       Key is case sensitive - no nulls
    '       Value stored/retrieved/removed using unique lookup Key
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = WsDwHshNew() 'get handle for new container
    '       h = WsDwHshFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro WsDwHshTag = -1948894953
Type WsDwHshNode
    next As WsDwHshNode Ptr
    K As WsStr Ptr
    V As Dword
End Type
Type WsDwHsh
    tag As Long
    count As Long
    cap As Long
    arr As Long Ptr
End Type

Function WsDwHshNew(ByVal capacity As Long) As Long
    'allocate new container - return handle
    'capacity = number of expected Keys (minium 100)
    Local i As Long
    Local p As WsDwHsh Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsDwHshTag
    @p.cap = Max&(capacity, 10)
    @p.arr = MemAlloc(@p.cap * 4)
    ExitF(@p.arr=0, LibErrM)
    Function = p
End Function

Function WsDwHshFinal(ByVal p As WsDwHsh Ptr) As Long
    'free allocated container - return null
    Local i As Long
    Local n, x As WsDwHshNode Ptr
    If p Then
        ExitF(@p.tag<>WsDwHshTag, LibErrH)
        For i = 0 To @p.cap - 1
            n = @p.@arr[i] : @p.@arr[i] = 0
            While n
                x = n : n = @n.next
                WsFinal(@x.K)
                MemFree(x)
            Wend
        Next i
        @p.arr = MemFree(@p.arr)
    End If
End Function

Function WsDwHshValidate(ByVal p As WsDwHsh Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = WsDwHshTag Then Function = @p.tag
End Function

Sub WsDwHshClear(ByVal p As WsDwHsh Ptr)
    'delete all data
    Local i As Long
    Local n, x As WsDwHshNode Ptr
    ExitS(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    For i = 0 To  @p.cap - 1
        n = @p.@arr[i] : @p.@arr[i] = 0
        While n
            x = n : n = @n.next
            WsFinal(@x.K)
            MemFree(x)
        Wend
    Next i
    @p.count = 0
End Sub

Function WsDwHshCount(ByVal p As WsDwHsh Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    Function = @p.count
End Function

Function WsDwHshCapGet(ByVal p As WsDwHsh Ptr) As Long
    'get Hash Table capacity
    ExitF(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    Function = @p.cap
End Function

Sub WsDwHshCapSet(ByVal p As WsDwHsh Ptr, ByVal capacity As Long)
    'set Hash Table capacity
    'rebuild Hash Table with new capacity - data preserved
    'capacity should be about the same as number of stored Keys
    Local i, oldCap, newCap As Long
    Local arr As Long Ptr
    Local n, x As WsDwHshNode Ptr
    ExitS(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    oldCap = @p.cap
    newCap = Max&(capacity, 10)
    arr = MemAlloc(newCap * 4)
    ExitS(arr=0, LibErrM)
    Swap @p.arr, arr
    @p.cap = newCap
    @p.count = 0
    For i = 0 To oldCap - 1
        n = @arr[i] : @arr[i] = 0
        While n
            x = n : n = @n.next
            WsDwHshSet p, WsGet(@x.K), @x.V
            WsFinal(@x.K)
            MemFree(x)
        Wend
    Next i
    MemFree(arr)
End Sub

Sub WsDwHshSet(ByVal p As WsDwHsh Ptr, ByRef key As WString, ByVal value As Dword, Opt ByVal DontReplace As Byte)
    'add Key/Value to Tash Table - Value replaced if Key exist unless DontReplace = True
    Local i, equal As Long
    Local ps As WString Ptr : ps = StrPtr(key)
    Local n, nn As WsDwHshNode Ptr
    ExitS(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    i = WStrHash(ps, @p.cap)
    ExitS(i>=@p.cap, LibErrU)
    n = @p.@arr[i]
    If n Then
        Do
            equal = WsEqual(@n.@K.mem, ps)
            If equal Then
                If IsFalse DontReplace Then @n.V = value
                Exit Sub
            ElseIf @n.next Then
                n = @n.next
            Else
                Exit Loop
            End If
        Loop
        nn = MemAlloc(SizeOf(WsDwHshNode))
        ExitS(nn=0, LibErrM)
        @nn.K = WsSetNew(key)
        @nn.V = value
        @n.next = nn
        Incr @p.count
    Else
        nn = MemAlloc(SizeOf(WsDwHshNode))
        ExitS(nn=0, LibErrM)
        @nn.K = WsSetNew(key)
        @nn.V = value
        @p.@arr[i] = nn
        Incr @p.count
    End If
End Sub

Function WsDwHshGet(ByVal p As WsDwHsh Ptr, ByRef key As WString) As Dword
    'get Key's associated Value
    Local i, equal As Long
    Local ps As WString Ptr : ps = StrPtr(key)
    Local n As WsDwHshNode Ptr
    ExitF(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    i = WStrHash(ps, @p.cap)
    ExitF(i>=@p.cap, LibErrU)
    n = @p.@arr[i]
    While n
        equal = WsEqual(@n.@K.mem, ps)
        If equal Then
            Function = @n.V
            Exit Loop
        End If
        n = @n.next
    Wend
End Function

Function WsDwHshGot(ByVal p As WsDwHsh Ptr, ByRef key As WString) As Byte
    'True/False if Key in Hash Table
    Local i, equal As Long
    Local ps As WString Ptr : ps = StrPtr(key)
    Local n As WsDwHshNode Ptr
    ExitF(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    i = WStrHash(ps, @p.cap)
    ExitF(i>=@p.cap, LibErrU)
    n = @p.@arr[i]
    While n
        equal = WsEqual(@n.@K.mem, ps)
        If equal Then
            Function = 1
            Exit Loop
        End If
        n = @n.next
    Wend
End Function

Sub WsDwHshDel(ByVal p As WsDwHsh Ptr, ByRef key As WString)
    'remove Key and associated Value from Hash Table
    Local i, equal As Long
    Local ps As WString Ptr : ps = StrPtr(key)
    Local prev, n As WsDwHshNode Ptr
    ExitS(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    i = WStrHash(ps, @p.cap)
    ExitS(i>=@p.cap, LibErrU)
    prev = 0
    n = @p.@arr[i]
    While n
        equal = WsEqual(@n.@K.mem, ps)
        If equal Then
            If prev Then
                @prev.next = @n.next
            Else
                @p.@arr[i] = @n.next
            End If
            @n.K = WsFinal(@n.K)
            MemFree(n)
            ExitS(@p.count=0, LibErrU)
            Decr @p.count
            Exit Loop
        End If
        prev = n
        n = @n.next
    Wend
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function WsDwHshClone(ByVal p As WsDwHsh Ptr) As Long
    'create duplicate container - return handle to cloned container
    Local i As Long
    Local n As WsDwHshNode Ptr
    Local clone As Long
    Err = 0
    ExitF(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    clone = WsDwHshNew(@p.cap) : If Err Then Exit Function
    For i = 0 To @p.cap - 1
        n = @p.@arr[i]
        While n
            WsDwHshSet clone, WsGet(@n.K), @n.V
            n = @n.next
        Wend
    Next i
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function WsDwHshStore(ByVal p As WsDwHsh Ptr) As String
    'store container to string
    Local i As Long
    Local keys, vals, store As Long
    Local n As WsDwHshNode Ptr
    Err = 0
    ExitF(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    keys = WsLstNew() : If Err Then Exit Function
    vals = DwLstNew() : If Err Then Exit Function
    store = SsLstNew() : If Err Then Exit Function
    If @p.count Then
        For i = 0 To @p.cap - 1
            n = @p.@arr[i]
            While n
                WsLstAdd keys, WsGet(@n.K)
                DwLstAdd vals, @n.V
                n = @n.next
            Wend
        Next i
        SsLstAdd store, Mkl$(@p.cap)
        SsLstAdd store, WsLstStore(keys)
        SsLstAdd store, DwLstStore(vals)
        Function = SsLstStore(store)
    End If
    keys = WsLstFinal(keys)
    vals = DwLstFinal(vals)
    store = SsLstFinal(store)
End Function

Sub WsDwHshRestore(ByVal p As WsDwHsh Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, store As Long
    Err = 0
    ExitS(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    WsDwHshClear p
    keys = WsLstNew() : If Err Then Exit Sub
    vals = DwLstNew() : If Err Then Exit Sub
    store = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore store, s : If Err Then Exit Sub
        ExitS(SsLstCount(store)<>3, LibErrU)
        WsDwHshCapSet p, Cvl(SsLstPopFirst(store))
        WsLstRestore keys, SsLstPopFirst(store)
        DwLstRestore vals, SsLstPopFirst(store)
        ExitS(WsLstCount(keys)<>DwLstCount(vals), LibErrU)
        While WsLstCount(keys)
            WsDwHshSet p, WsLstPopFirst(keys), DwLstPopFirst(vals)
        Wend
    End If
    keys = WsLstFinal(keys)
    vals = DwLstFinal(vals)
    store = SsLstFinal(store)
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub WsDwHshFileStore(ByVal p As WsDwHsh Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    s = WsDwHshStore(p) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub WsDwHshFileRestore(ByVal p As WsDwHsh Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(p=0 Or @p.tag<>WsDwHshTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        WsDwHshRestore p, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub
