#Include This Once
#Include Once "C:\HLib3\Mem.inc"
#Include Once "C:\HLib3\Size.inc"

    'Long Stack Container
    'INTERNAL USE

Type LStkNode
    prev As LStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Long
End Type
Type LStk
    count As Long
    top As LStkNode Ptr
End Type


Sub LStkFinal(t As LStk)
    LStkClear t
End Sub

Sub LStkClear(t As LStk)
    Local hNode As Long
    While t.top
        hNode = t.top
        t.top = t.@top.prev
        MemFree(hNode)
    Wend
    t.count = 0
    t.top = 0
End Sub

Function LStkCount(t As LStk) As Long
    'get item count
    Function = t.count
End Function

Sub LStkPush(t As LStk, ByVal value As Long)
    'push value on top of stack
    Local node As LStkNode Ptr
    If t.count = 0 Then
        t.top = MemAlloc(SizeOf(LStkNode))
        If t.top Then
            t.@top.arr(1) = value
            t.@top.index = 1
            t.count = 1
        End If
    ElseIf t.@top.index < %StkMax Then
        Incr t.@top.index
        t.@top.arr(t.@top.index) = value
        Incr t.count
    Else
        node = MemAlloc(SizeOf(LStkNode))
        If node Then
            @node.arr(1) = value
            @node.index = 1
            @node.prev = t.top
            t.top = node
            Incr t.count
        End If
    End If
End Sub

Function LStkPeek(t As LStk) As Long
    'get top value on stack
    If t.count Then Function = t.@top.arr(t.@top.index)
End Function

Function LStkPop(t As LStk) As Long
    'get and remove top value on stack
    Local hNode As Long
    If t.count Then
        Function = t.@top.arr(t.@top.index)
        Decr t.@top.index
        Decr t.count
        If t.@top.index = 0 Then
            hNode = t.top
            t.top = t.@top.prev
            MemFree(hNode)
        End If
    End If
End Function
