'InLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\InLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String

    'get handle to new List container
    Local list As Long : list = InLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 32000

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        InLstAdd list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(InLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = InLstFirst(list)
    While node
        Incr i
        If InLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = InLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    InLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        InLstIns list, i
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = InLstLast(list)
    While node
        Incr i
        If InLstGet(node) <> i Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = InLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    InLstClear list
    ListBox Add CbHndl, lbxID, "add 2, 4, 6"
    InLstAdd list, 2
    InLstAdd list, 4
    InLstAdd list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = InLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert 1 before" : InLstInsPrev list, node, 1
    ListBox Add CbHndl, lbxID, "    insert 3 after"  : InLstInsNext list, node, 3
    ListBox Add CbHndl, lbxID, "move to last node"   : node = InLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert 5 before" : InLstInsPrev list, node, 5
    ListBox Add CbHndl, lbxID, "    insert 7 after"  : InLstInsNext list, node, 7
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = InLstFirst(list) : node = InLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : InLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : InLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = InLstLast(list) : node = InLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : InLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : InLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = InLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = InLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = InLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : InLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(InLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : InLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : InLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : InLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(InLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : InLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push 1, 2, 3 on Stack"
    InLstClear list
    InLstStkPush list, 1
    InLstStkPush list, 2
    InLstStkPush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While InLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(InLstStkPeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(InLstStkPop(list))
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to Queue"
    InLstClear list
    InLstQuePush list, 1
    InLstQuePush list, 2
    InLstQuePush list, 3
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While InLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + Format$(InLstQuePeek(list))
        ListBox Add CbHndl, lbxID, "Pop = " + Format$(InLstQuePop(list))
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add 1, 2, 3 to front of Deque"
    InLstPushFirst list, 1
    InLstPushFirst list, 2
    InLstPushFirst list, 3
    ListBox Add CbHndl, lbxID, "add 4, 5, 6 to end of Deque"
    InLstPushLast list, 4
    InLstPushLast list, 5
    InLstPushLast list, 6
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = InLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, Format$(InLstGet(node))
        node = InLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While InLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + Format$(InLstPeekFirst(list))
        ListBox Add CbHndl, lbxID, "PopFirst = " + Format$(InLstPopFirst(list))
        ListBox Add CbHndl, lbxID, "PeekLast = " + Format$(InLstPeekLast(list))
        ListBox Add CbHndl, lbxID, "PopLast = " + Format$(InLstPopLast(list))
    Wend

    'must free handles before they go out of scope
    list = InLstFinal(list)
    clone = InLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "InLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
