'WsLst.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
%HaltOnError = 1
#Include Once "..\WsLst.inc"

Macro lbxID = 1000
Macro btnID = 1001

CallBack Function BtnCB()
    Local i, Count As Long
    Local d As Double
    Local s As String
    Local a() As WString

    'get handle to new List container
    Local list As Long : list = WsLstNew()
    Local clone As Long
    Local node As Long

    ListBox Reset CbHndl, lbxID
    Randomize
    Count = 10000
    ReDim a(1 To Count)
    For i = 1 To Count
        a(i) = Format$(i, "0000000")
    Next i

    'append value to end of List

    ListBox Add CbHndl, lbxID, "Add "+Format$(Count, "#,")+" values to empty List"
    d = Timer
    For i = 1 To Count
        WsLstAdd list, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WsLstCount(list), "#,")

    'traverse forward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List forward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = WsLstFirst(list)
    While node
        Incr i
        If WsLstGet(node) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = WsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'insert value at front of empty List

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    WsLstClear list
    ListBox Add CbHndl, lbxID, "insert "+Format$(Count, "#,")+" values at front of List"
    d = Timer
    For i = 1 To Count
        WsLstIns list, a(i)
    Next i
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    'traverse backward - get value

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "traverse List backward - get and test all "+Format$(Count, "#,")+" values"
    i = 0
    d = Timer
    node = WsLstLast(list)
    While node
        Incr i
        If WsLstGet(node) <> a(i) Then
            ? "fail at: " + Format$(i) : Exit Loop
        End If
        node = WsLstPrev(node)
    Wend
    ListBox Add CbHndl, lbxID, "Time = " + Format$(Timer - d, "00.0000")

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clear List"
    WsLstClear list
    ListBox Add CbHndl, lbxID, "add B, D, F"
    WsLstAdd list, "B"
    WsLstAdd list, "D"
    WsLstAdd list, "F"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend

    'insert before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to first node"  : node = WsLstFirst(list)
    ListBox Add CbHndl, lbxID, "    insert A before" : WsLstInsPrev list, node, "A"
    ListBox Add CbHndl, lbxID, "    insert C after"  : WsLstInsNext list, node, "C"
    ListBox Add CbHndl, lbxID, "move to last node"   : node = WsLstLast(list)
    ListBox Add CbHndl, lbxID, "    insert E before" : WsLstInsPrev list, node, "E"
    ListBox Add CbHndl, lbxID, "    insert G after"  : WsLstInsNext list, node, "G"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend

    'remove before/after

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "move to second node in List"
    node = WsLstFirst(list) : node = WsLstNext(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : WsLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : WsLstDelNext list, node
    ListBox Add CbHndl, lbxID, "move to second node from end of  List"
    node = WsLstLast(list) : node = WsLstPrev(node)
    ListBox Add CbHndl, lbxID, "    remove value before node" : WsLstDelPrev list, node
    ListBox Add CbHndl, lbxID, "    remove value after node"  : WsLstDelNext list, node
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend

    'Clone

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "clone List"
    clone = WsLstClone(list)
    ListBox Add CbHndl, lbxID, "-- Display Cloned List --"
    node = WsLstFirst(clone)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend

    'Store/Restore To/From String

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to String"     : s = WsLstStore(list)
    ListBox Add CbHndl, lbxID, "clear List"               : WsLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WsLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from String" : WsLstRestore list, s
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend

    'Store/Restore To/From File

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "store List to File"     : WsLstFileStore list, "test.data"
    ListBox Add CbHndl, lbxID, "clear List"             : WsLstClear list
    ListBox Add CbHndl, lbxID, "Count = " + Format$(WsLstCount(list), "#,")
    ListBox Add CbHndl, lbxID, "restore List from File" : WsLstFileRestore list, "test.data"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend

    If IsFile("test.data") Then Kill "test.data"

    'Stack

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Stack:"
    ListBox Add CbHndl, lbxID, "push AAA, BBB, CCC on Stack"
    WsLstClear list
    WsLstStkPush list, "AAA"
    WsLstStkPush list, "BBB"
    WsLstStkPush list, "CCC"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Stack"
    While WsLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + WsLstStkPeek(list)
        ListBox Add CbHndl, lbxID, "Pop = " + WsLstStkPop(list)
    Wend

    'Queue

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Queue:"
    ListBox Add CbHndl, lbxID, "add AAA, BBB, CCC to Queue"
    WsLstClear list
    WsLstQuePush list, "AAA"
    WsLstQuePush list, "BBB"
    WsLstQuePush list, "CCC"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Queue"
    While WsLstCount(list)
        ListBox Add CbHndl, lbxID, "Peek = " + WsLstQuePeek(list)
        ListBox Add CbHndl, lbxID, "Pop = " + WsLstQuePop(list)
    Wend

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "Deque: (double-ended Queue)"
    ListBox Add CbHndl, lbxID, "add AAA, BBB, CCC to front of Deque"
    WsLstPushFirst list, "AAA"
    WsLstPushFirst list, "BBB"
    WsLstPushFirst list, "CCC"
    ListBox Add CbHndl, lbxID, "add XXX, YYY, ZZZ to end of Deque"
    WsLstPushLast list, "XXX"
    WsLstPushLast list, "YYY"
    WsLstPushLast list, "ZZZ"
    ListBox Add CbHndl, lbxID, "-- Display List --"
    node = WsLstFirst(list)
    While node
        ListBox Add CbHndl, lbxID, WsLstGet(node)
        node = WsLstNext(node)
    Wend
    ListBox Add CbHndl, lbxID, "Peek and Pop Deque"
    While WsLstCount(list)
        ListBox Add CbHndl, lbxID, "PeekFirst = " + WsLstPeekFirst(list)
        ListBox Add CbHndl, lbxID, "PopFirst = " + WsLstPopFirst(list)
        ListBox Add CbHndl, lbxID, "PeekLast = " + WsLstPeekLast(list)
        ListBox Add CbHndl, lbxID, "PopLast = " + WsLstPopLast(list)
    Wend


    'must free handles before they go out of scope
    list = WsLstFinal(list)
    clone = WsLstFinal(clone)


    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "WsLst", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
