#Include This Once

Declare Function GlobalAlloc Lib "Kernel32.dll" Alias "GlobalAlloc" (ByVal uFlags As Dword, ByVal dwBytes As Dword) As Dword

Declare Function GlobalReAlloc Lib "Kernel32.dll" Alias "GlobalReAlloc" (ByVal hMem As Dword, ByVal dwBytes As Dword, ByVal uFlags As Dword) As Dword

Declare Function GlobalFree Lib "Kernel32.dll" Alias "GlobalFree" (ByVal hMem As Dword) As Dword

%GMEM_FIXED_         = &H0000
%GMEM_MOVEABLE_      = &H0002
%GMEM_NOCOMPACT_     = &H0010
%GMEM_NODISCARD_     = &H0020
%GMEM_ZEROINIT_      = &H0040
%GMEM_MODIFY_        = &H0080
%GMEM_DISCARDABLE_   = &H0100
%GMEM_NOT_BANKED_    = &H1000
%GMEM_SHARE_         = &H2000
%GMEM_DDESHARE_      = &H2000
%GMEM_NOTIFY_        = &H4000
%GMEM_LOWER_         = %GMEM_NOT_BANKED_
%GMEM_VALID_FLAGS_   = &H7F72
%GMEM_INVALID_HANDLE_ = &H08000

%GHND_               = (%GMEM_ZEROINIT_ Or %GMEM_MOVEABLE_)
%GPTR_               = (%GMEM_ZEROINIT_ Or %GMEM_FIXED_)


FastProc MemAlloc(ByVal Count As Long) ThreadSafe As Long
    Static hMem As Long : hMem = 0
    If Count Then hMem = GlobalAlloc(ByVal %GPTR_, ByVal Count)
End FastProc = hMem

FastProc MemReAlloc(ByVal h As Long, ByVal Count As Long) ThreadSafe As Long
    Static hMem As Long : hMem = 0
    If h Then
        hMem = GlobalReAlloc(ByVal h, ByVal Count, ByVal %GMEM_MOVEABLE_ Or %GMEM_ZEROINIT_)
    Else
        hMem = GlobalAlloc(ByVal %GPTR_, ByVal Count)
    End If
End FastProc = hMem

FastProc MemFree(ByVal h As Long) ThreadSafe As Long
    If h Then GlobalFree(ByVal h)
End FastProc = 0

Function MemFreeObj(ByVal h As Long) As Long
    Local o As IUnknown
    If h Then
        Poke Long, VarPtr(o), h
        o = Nothing
    End If
End Function
