#Include This Once
#Include Once "C:\HLib3\HLib.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Quad Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = QdQueNew() 'get handle for new container
    '       h = QdQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro QdQueTag = 1927764680
Type QdQueNode
    next As QdQueNode Ptr
    first As Long
    last As Long
    arr(1 To %QueMax) As Quad
End Type
Type QdQue
    tag As Long
    count As Long
    first As QdQueNode Ptr
    last As QdQueNode Ptr
End Type

Function QdQueNew() As Long
    'allocate new container - return handle
    Local p As QdQue Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = QdQueTag
    Function = p
End Function

Function QdQueFinal(ByVal p As QdQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>QdQueTag, LibErrH)
        QdQueClear p
        MemFree(p)
    End If
End Function

Function QdQueValidate(ByVal p As QdQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = QdQueTag Then Function = @p.tag
End Function

Sub QdQueClear(ByVal p As QdQue Ptr)
    'delete all data
    Local node As QdQueNode Ptr
    ExitS(p=0 Or @p.tag<>QdQueTag, LibErrH)
    While @p.first
        node = @p.first
        @p.first = @node.next
        MemFree(node)
    Wend
    @p.first = 0
    @p.last = 0
    @p.count = 0
End Sub

Function QdQueCount(ByVal p As QdQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>QdQueTag, LibErrH)
    Function = @p.count
End Function

Sub QdQuePush(ByVal p As QdQue Ptr, ByVal value As Quad)
    'add value to end of queue
    Local node As QdQueNode Ptr
    ExitS(p=0 Or @p.tag<>QdQueTag, LibErrH)
    If @p.count = 0 Then
        @p.last = MemAlloc(SizeOf(QdQueNode))
        ExitS(@p.last=0, LibErrM)
        @p.@last.arr(1) = value
        @p.@last.first = 1
        @p.@last.last = 1
        @p.first = @p.last
        @p.count = 1
    Else
        ExitS(@p.last=0, LibErrU)
        If @p.@last.last < %QueMax Then
            Incr @p.@last.last
            @p.@last.arr(@p.@last.last) = value
            Incr @p.count
        Else
            node = MemAlloc(SizeOf(QdQueNode))
            ExitS(node=0, LibErrM)
            @node.arr(1) = value
            @node.first = 1
            @node.last = 1
            @p.@last.next = node
            @p.last = node
            Incr @p.count
        End If
    End If
End Sub


Function QdQuePeek(ByVal p As QdQue Ptr) As Quad
    'get first value in queue
    ExitF(p=0 Or @p.tag<>QdQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
    End If
End Function

Function QdQuePop(ByVal p As QdQue Ptr) As Quad
    'get and remove first value in queue
    Local node As QdQueNode Ptr
    ExitF(p=0 Or @p.tag<>QdQueTag, LibErrH)
    If @p.count Then
        ExitF(@p.first=0, LibErrU)
        Function = @p.@first.arr(@p.@first.first)
        Decr @p.count
        If @p.count = 0 Then
            QdQueClear p
        Else
            Incr @p.@first.first
            If @p.@first.first > @p.@first.last Then
                node = @p.first
                @p.first = @p.@first.next
                MemFree(node)
            End If
        End If
    End If
End Function
