#Include This Once
#Include Once "C:\HLib3\String\SsStr.inc"
#Include Once "C:\HLib3\Queue\LnQue.inc"

'++
    '----------------------------------------------------------------------------------------
    '   String Queue Container
    '       extremely fast, memory efficient and CPU Cache friendly Queue implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = SsQueNew() 'get handle for new container
    '       h = SsQueFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro SsQueTag = 217604277
Type SsQue
    tag As Long
    que As LnQue Ptr
End Type

Function SsQueNew() As Long
    'allocate new container - return handle
    Local p As SsQue Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = SsQueTag
    @p.que = LnQueNew() : If Err Then Exit Function
    Function = p
End Function

Function SsQueFinal(ByVal p As SsQue Ptr) As Long
    'free allocated container - return null
    If p Then
        ExitF(@p.tag<>SsQueTag, LibErrH)
        SsQueClear p
        @p.que = LnQueFinal(@p.que)
        MemFree(p)
    End If
End Function

Function SsQueValidate(ByVal p As SsQue Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = SsQueTag Then Function = @p.tag
End Function

Sub SsQueClear(ByVal p As SsQue Ptr)
    'delete all data
    ExitS(p=0 Or @p.tag<>SsQueTag, LibErrH)
    While @p.@que.count
        SsFinal(LnQuePop(@p.que))
    Wend
End Sub

Function SsQueCount(ByVal p As SsQue Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>SsQueTag, LibErrH)
    Function = @p.@que.count
End Function

Sub SsQuePush(ByVal p As SsQue Ptr, ByRef value As String)
    'add value to end of queue
    ExitS(p=0 Or @p.tag<>SsQueTag, LibErrH)
    LnQuePush @p.que, SsSetNew(value)
End Sub

Function SsQuePeek(ByVal p As SsQue Ptr) As String
    'get first value in queue
    ExitF(p=0 Or @p.tag<>SsQueTag, LibErrH)
    If @p.@que.count Then Function = SsGet(LnQuePeek(@p.que))
End Function

Function SsQuePop(ByVal p As SsQue Ptr) As String
    'get and remove first value in queue
    Local h As Long
    ExitF(p=0 Or @p.tag<>SsQueTag, LibErrH)
    h = LnQuePop(@p.que)
    If h Then
        Function = SsGet(h)
        SsFinal(h)
    End If
End Function
