#Include This Once
#Include Once "C:\HLib3\String\SsStr.inc"
#Include Once "C:\HLib3\Stack\LnStk.inc"

'++
    '----------------------------------------------------------------------------------------
    '   String Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = SsStkNew() 'get handle for new container
    '       h = SsStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro SsStkTag = 1320870834
Type SsStk
    tag As Long
    stk As LnStk Ptr
End Type

Function SsStkNew() As Long
    'allocate new container - return handle
    Local p As SsStk Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = SsStkTag
    @p.stk = LnStkNew() : If Err Then Exit Function
    Function = p
End Function

Function SsStkFinal(ByVal p As SsStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>SsStkTag, LibErrH)
        SsStkClear p
        @p.stk = LnStkFinal(@p.stk)
        MemFree(p)
    End If
End Function

Function SsStkValidate(ByVal p As SsStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = SsStkTag Then Function = @p.tag
End Function

Sub SsStkClear(ByVal p As SsStk Ptr)
    'delete all data - Modifies Container Data
    ExitS(p=0 Or @p.tag<>SsStkTag, LibErrH)
    While @p.@stk.count
        SsFinal(LnStkPop(@p.stk))
    Wend
End Sub

Function SsStkCount(ByVal p As SsStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>SsStkTag, LibErrH)
    Function = @p.@stk.count
End Function

Sub SsStkPush(ByVal p As SsStk Ptr, ByRef value As String)
    'push value on top of stack
    ExitS(p=0 Or @p.tag<>SsStkTag, LibErrH)
    LnStkPush @p.stk, SsSetNew(value)
End Sub

Function SsStkPeek(ByVal p As SsStk Ptr) As String
    'get top value on stack
    ExitF(p=0 Or @p.tag<>SsStkTag, LibErrH)
    If @p.@stk.count Then Function = SsGet(LnStkPeek(@p.stk))
End Function

Function SsStkPop(ByVal p As SsStk Ptr) As String
    'get and remove top value on stack
    Local h As Long
    ExitF(p=0 Or @p.tag<>SsStkTag, LibErrH)
    If @p.@stk.count Then
        h = LnStkPop(@p.stk)
        Function = SsGet(h)
        SsFinal(h)
    End If
End Function
