#Include This Once
#Include Once "C:\HLib3\List\WdLst.inc"

'++
    '----------------------------------------------------------------------------------------
    '   Word Stack Container
    '       extremely fast, memory efficient and CPU Cache friendly Stack implementation
    '       - each node has a fixed array of 500 items
    '       - memory allocation and deallocation only takes place every 500'th item
    '       - CPU Cache loves small arrays
    '       - way more efficient for small data types; Byte, Integer, Word, ...
    '
    '       container accessed with handle
    '       handle protected by hash tag
    '       h = WdStkNew() 'get handle for new container
    '       h = WdStkFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--

Macro WdStkTag = 1317754472
Type WdStkNode
    prev As WdStkNode Ptr
    index As Long
    arr(1 To %StkMax) As Word
End Type
Type WdStk
    tag As Long
    count As Long
    top As WdStkNode Ptr
End Type

Function WdStkNew() As Long
    'allocate new container - return handle
    Local p As WdStk Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WdStkTag
    Function = p
End Function

Function WdStkFinal(ByVal p As WdStk Ptr) As Long
    'free allocated container - return null - Modifies Container Data
    If p Then
        ExitF(@p.tag<>WdStkTag, LibErrH)
        WdStkClear p
        MemFree(p)
    End If
End Function

Function WdStkValidate(ByVal p As WdStk Ptr) As Long
    'True/False if valid handle for this container
    If p And @p.tag = WdStkTag Then Function = @p.tag
End Function

Sub WdStkClear(ByVal p As WdStk Ptr)
    'delete all data - Modifies Container Data
    Local node As WdStkNode Ptr
    ExitS(p=0 Or @p.tag<>WdStkTag, LibErrH)
    While @p.top
        node = @p.top
        @p.top = @node.prev
        MemFree(node)
    Wend
    @p.top = 0
    @p.count = 0
End Sub

Function WdStkCount(ByVal p As WdStk Ptr) As Long
    'get item count
    ExitF(p=0 Or @p.tag<>WdStkTag, LibErrH)
    Function = @p.count
End Function

Sub WdStkPush(ByVal p As WdStk Ptr, ByVal value As Word)
    'push value on top of stack
    Local node As WdStkNode Ptr
    ExitS(p=0 Or @p.tag<>WdStkTag, LibErrH)
    If @p.count = 0 Then
        @p.top = MemAlloc(SizeOf(WdStkNode))
        ExitS(@p.top=0, LibErrM)
        @p.@top.arr(1) = value
        @p.@top.index = 1
        @p.count = 1
    ElseIf @p.@top.index < %StkMax Then
        Incr @p.@top.index
        @p.@top.arr(@p.@top.index) = value
        Incr @p.count
    Else
        node = MemAlloc(SizeOf(WdStkNode))
        ExitS(node=0, LibErrM)
        @node.arr(1) = value
        @node.index = 1
        @node.prev = @p.top
        @p.top = node
        Incr @p.count
    End If
End Sub

Function WdStkPeek(ByVal p As WdStk Ptr) As Word
    'get top value on stack
    ExitF(p=0 Or @p.tag<>WdStkTag, LibErrH)
    If @p.count Then Function = @p.@top.arr(@p.@top.index)
End Function

Function WdStkPop(ByVal p As WdStk Ptr) As Word
    'get and remove top value on stack
    Local node As WdStkNode Ptr
    ExitF(p=0 Or @p.tag<>WdStkTag, LibErrH)
    If @p.count Then
        Function = @p.@top.arr(@p.@top.index)
        Decr @p.@top.index
        Decr @p.count
        If @p.@top.index = 0 Then
            node = @p.top
            @p.top = @p.@top.prev
            MemFree(node)
        End If
    End If
End Function
