'StringInUDT.bas
#Dim All
#Compile Exe
#Include Once "WIN32API.INC"
#Include Once "..\SsStr.inc"

Macro lbxID = 1000
Macro btnID = 1001

Type TestT
    s1 As Long
    s2 As Long
End Type

CallBack Function BtnCB()
    Local i As Long
    Threaded t As TestT

    ListBox Reset CbHndl, lbxID

    'must allocate handles before use
    t.s1 = SsNew()
    t.s2 = SsNew()

    'set strings
    SsSet t.s1, "This is String #1"
    SsSet t.s2, "And this is String #2"

    'get strings
    ListBox Add CbHndl, lbxID, $Dq + SsGet(t.s1) + $Dq
    ListBox Add CbHndl, lbxID, $Dq + SsGet(t.s2) + $Dq

    'string length
    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "String Length #1 = " + Format$(SsCount(t.s1))
    ListBox Add CbHndl, lbxID, "String Length #2 = " + Format$(SsCount(t.s2))

    'must free handles before they go out of scope
    t.s1 = SsFinal(t.s1)
    t.s2 = SsFinal(t.s2)

    ListBox Add CbHndl, lbxID, ""
    ListBox Add CbHndl, lbxID, "done..."
End Function

Function PBMain()
    Local hDlg As Long
    Dialog New 0, "StringInUDT", 67, 61, 341, 241, %WS_Caption Or %WS_ClipSiblings Or %WS_MinimizeBox Or %WS_SysMenu, %WS_Ex_AppWindow To hDlg
    Control Add ListBox, hDlg, lbxID, , 5, 5, 330, 210, %WS_Child Or %WS_HScroll Or %WS_VScroll Or %LBS_Notify Or %LBS_NoIntegralHeight, %WS_Ex_ClientEdge
    Control Add Button,  hDlg, btnID, "Test", 275, 220, 60, 15 Call BtnCB()
    Dialog Show Modal hDlg, Call DlgCB
End Function

CallBack Function DlgCB()
End Function
