#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\LnLst.inc"
#Include Once "C:\HLib3\List\LnLst.inc"
#Include Once "C:\HLib3\List\SsLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'Long/Long ~ Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   - use MultiTree for one-to-many relationship
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = LnLnTreNew() 'get handle for new container
    '   h = LnLnTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--


Macro LnLnTreNodeTag = 1695149631
Macro LnLnTreTag = 501260071
Type LnLnTreNode
    tag As Long
    P As LnLnTreNode Ptr
    L As LnLnTreNode Ptr
    R As LnLnTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As Long
End Type
Type LnLnTre
    tag As Long
    count As Long
    root As LnLnTreNode Ptr
End Type

Function LnLnTreNew() As Long
    'allocate new container - return handle
    Local p As LnLnTre Ptr
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = LnLnTreTag
    Function = p
End Function

Function LnLnTreFinal(ByVal pTree As LnLnTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>LnLnTreTag, LibErrH)
        LnLnTreClear pTree
        MemFree(pTree)
    End If
End Function

Function LnLnTreValidate(ByVal pTree As LnLnTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = LnLnTreTag Then Function = @pTree.tag
End Function

Sub LnLnTreClear(ByVal pTree As LnLnTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As LnLnTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = LnLnTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = LnLnTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            LnLnTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function LnLnTreCount(ByVal pTree As LnLnTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub LnLnTreSet(ByVal pTree As LnLnTre Ptr, ByVal key As Long, ByVal value As Long, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local n As LnLnTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    If @pTree.root Then
        n = @pTree.root
        While 1
            If key > @n.K Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = LnLnTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    @n.@R.K = key
                    @n.@R.V = value
                    LnLnTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf key < @n.K Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = LnLnTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    @n.@L.K = key
                    @n.@L.V = value
                    LnLnTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then @n.V = value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = LnLnTreAllocNode(pTree) : If Err Then Exit Sub
        @pTree.@root.K = key
        @pTree.@root.V = value
        @pTree.count = 1
    End If
End Sub

Function LnLnTreGet(ByVal pTree As LnLnTre Ptr, ByVal key As Long) As Long
    'get Key's associated Value
    Register k As Long : k = key
    Local n As LnLnTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    n = @pTree.root
    While n
        If k < @n.K Then
            n = @n.L
        ElseIf k > @n.K Then
            n = @n.R
        Else
            Function = @n.V
            Exit Loop
        End If
    Wend
End Function

Function LnLnTreGot(ByVal pTree As LnLnTre Ptr, ByVal key As Long) As Long
    'True/False if Key exist
    Register k As Long : k = key
    Local n As LnLnTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    n = @pTree.root
    While n
        If k < @n.K Then
            n = @n.L
        ElseIf k > @n.K Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
End Function

Sub LnLnTreDel(ByVal pTree As LnLnTre Ptr, ByVal key As Long)
    'remove Key and associated Value
    Local pNode As LnLnTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    pNode = LnLnTreGot(pTree, key)
    If pNode Then
        LnLnTreRemoveNode(pTree, pNode)
    End If
End Sub

Function LnLnTreFirst(ByVal pTree As LnLnTre Ptr) As Long
    'get handle to first node in tree
    Local n As LnLnTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function LnLnTreLast(ByVal pTree As LnLnTre Ptr) As Long
    'get handle to last node in tree
    Local n As LnLnTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function LnLnTreNext(ByVal pNode As LnLnTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As LnLnTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>LnLnTreNodeTag, LibErrH)
        minR = LnLnTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = LnLnTreParentGreater(pNode)
        End If
    End If
End Function

Function LnLnTrePrev(ByVal pNode As LnLnTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As LnLnTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>LnLnTreNodeTag, LibErrH)
        maxL = LnLnTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = LnLnTreParentLesser(pNode)
        End If
    End If
End Function

Function LnLnTreGetKey(ByVal pNode As LnLnTreNode Ptr) As Long
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>LnLnTreNodeTag, LibErrH)
    Function = @pNode.K
End Function

Function LnLnTreGetVal(ByVal pNode As LnLnTreNode Ptr) As Long
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>LnLnTreNodeTag, LibErrH)
    Function = @pNode.V
End Function

Sub LnLnTreSetVal(ByVal pNode As LnLnTreNode Ptr, ByVal value As Long)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>LnLnTreNodeTag, LibErrH)
    @pNode.V = value
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function LnLnTreClone(ByVal pTree As LnLnTre Ptr) As Long
    'create duplicate container
    Local h, clone As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    clone = LnLnTreNew() : If Err Then Exit Function
    h = LnLnTreFirst(pTree)
    While h
        LnLnTreSet clone, LnLnTreGetKey(h), LnLnTreGetVal(h)
        h = LnLnTreNext(h)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function LnLnTreStore(ByVal pTree As LnLnTre Ptr) As String
    'store container to string
    Local h, keys, vals, stor As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    keys = LnLstNew() : If Err Then Exit Function
    vals = LnLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        h = LnLnTreFirst(pTree)
        While h
            LnLstAdd keys, LnLnTreGetKey(h)
            LnLstAdd vals, LnLnTreGetVal(h)
            h = LnLnTreNext(h)
        Wend
        SsLstAdd stor, LnLstStore(keys)
        SsLstAdd stor, LnLstStore(vals)
        Function = SsLstStore(stor)
    End If
    keys = LnLstFinal(keys)
    vals = LnLstFinal(vals)
    stor = SsLstFinal(stor)
End Function

Sub LnLnTreRestore(ByVal pTree As LnLnTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, stor As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    LnLnTreClear pTree
    keys = LnLstNew() : If Err Then Exit Sub
    vals = LnLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>2, LibErrU)
        LnLstRestore keys, SsLstPopFirst(stor)
        LnLstRestore vals, SsLstPopFirst(stor)
        ExitS(LnLstCount(keys)<>LnLstCount(vals), LibErrU)
        While LnLstCount(keys)
            LnLnTreSet pTree, LnLstPopFirst(keys), LnLstPopFirst(vals)
        Wend
    End If
    keys = LnLstFinal(keys)
    vals = LnLstFinal(vals)
    stor = SsLstFinal(stor)
End Sub


'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub LnLnTreFileStore(ByVal pTree As LnLnTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    s = LnLnTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub LnLnTreFileRestore(ByVal pTree As LnLnTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>LnLnTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        LnLnTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub LnLnTreRemoveNode(ByVal p As LnLnTre Ptr, ByVal n As LnLnTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As LnLnTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, LnLnTreMaxLeft(n), LnLnTreMinRight(n))
        If @p.root = n Then @p.root = swapN
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        n = swapN
    Wend
    If n = @p.root Then
        LnLnTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = LnLnTreFreeNode(p, n)
        LnLnTreBalanceBranch p, nP
    End If
End Sub

Function LnLnTreAllocNode(ByVal p As LnLnTre Ptr) Private As Long
    Local n As LnLnTreNode Ptr
    n = MemAlloc(SizeOf(LnLnTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.tag = LnLnTreNodeTag
    Incr @p.count
    Function = n
End Function

Function LnLnTreFreeNode(ByVal p As LnLnTre Ptr, ByVal n As LnLnTreNode Ptr) As Long
    If n Then
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub LnLnTreBalanceBranch(ByVal p As LnLnTre Ptr, ByVal n As LnLnTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = LnLnTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = LnLnTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function LnLnTreMaxLeft(ByVal n As LnLnTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function LnLnTreMinRight(ByVal n As LnLnTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function LnLnTreParentGreater(ByVal n As LnLnTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function LnLnTreParentLesser(ByVal n As LnLnTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function LnLnTreRotateLeft(ByVal p As LnLnTre Ptr, ByVal n As LnLnTreNode Ptr) Private As Long
    Local nR, nRL As LnLnTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function LnLnTreRotateRight(ByVal p As LnLnTre Ptr, ByVal n As LnLnTreNode Ptr) Private As Long
    Local nL, nLR As LnLnTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
