#Include This Once
#Include Once "C:\HLib3\HLib.inc"
#Include Once "C:\HLib3\List\SsLst.inc"
#Include Once "C:\HLib3\List\WsLst.inc"
#Include Once "C:\HLib3\List\QdLst.inc"

'++
    '----------------------------------------------------------------------------------------
    'WString/Quad ~ Tree Container
    '   - also called: Tree/Map/Dictionary/Associative Array
    '   - AVL Self-Balanced Binary Tree
    '   - one-to-one relationship
    '   - Key/Value data structure
    '   - Values stored/retrieved/removed using unique lookup Key
    '   - Keys must be unique
    '   - no limit on Key length
    '   - use WsQdTreComparison() to change how Keys compared
    '   - Value replaced if Key exist unless DontReplace = True
    '   - Tree always stays in Key order
    '   - Tree may be traversed forward/backward in Key order
    '   - Tree is self-balanced to maintain shortest average path to each Key
    '
    '   - use MultiTree for one-to-many relationship
    '
    '   container accessed with handle
    '   handle protected by hash tag
    '   h = WsQdTreNew() 'get handle for new container
    '   h = WsQdTreFinal(h) 'free handle before it goes out of scope
    '----------------------------------------------------------------------------------------
'--


Macro WsQdTreNodeTag = -1215465874
Macro WsQdTreTag = -252380731
Type WsQdTreNode
    tag As Long
    P As WsQdTreNode Ptr
    L As WsQdTreNode Ptr
    R As WsQdTreNode Ptr
    HL As Word
    HR As Word
    K As Long
    V As Quad
End Type
Type WsQdTre
    tag As Long
    count As Long
    root As WsQdTreNode Ptr
    compareCB As Long
    collation As WsStr Ptr
End Type

Function WsQdTreNew() As Long
    'allocate new container - return handle
    Local p As WsQdTre Ptr
    Err = 0
    p = MemAlloc(SizeOf(@p))
    ExitF(p=0, LibErrM)
    @p.tag = WsQdTreTag
    @p.compareCB = CodePtr(WsCompare)
    @p.collation = WsNew() : If Err Then Exit Function
    Function = p
End Function

Function WsQdTreFinal(ByVal pTree As WsQdTre Ptr) As Long
    'free allocated container - return null
    If pTree Then
        ExitF(@pTree.tag<>WsQdTreTag, LibErrH)
        @pTree.collation = WsFinal(@pTree.collation)
        WsQdTreClear pTree
        MemFree(pTree)
    End If
End Function

Function WsQdTreValidate(ByVal pTree As WsQdTre Ptr) As Long
    'True/False if valid handle for this container
    If pTree And @pTree.tag = WsQdTreTag Then Function = @pTree.tag
End Function

Sub WsQdTreComparison(ByVal pTree As WsQdTre Ptr, ByVal compareUCase As Long, ByVal collationSequence As WString)
    'set how WStrings compared
    'default = case ignored
    'if collationSequence WString provided then
    '   WStrings are compared using the order of the collation sequence WString
    '   collation WString must be 65536 characters
    'else if compareUCase = True then
    '   WStrings compared UCase
    ExitS(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    @pTree.compareCB = CodePtr(WsCompare)
    WsClear @pTree.collation
    If Len(collationSequence) Then
        ExitS(Len(collationSequence)<>65536, LibErrS)
        WsSet @pTree.collation, collationSequence : If Err Then Exit Sub
        @pTree.compareCB = CodePtr(WsCompareCollate)
    ElseIf compareUCase Then
        @pTree.compareCB = CodePtr(WsCompareUCase)
    End If
End Sub

Sub WsQdTreClear(ByVal pTree As WsQdTre Ptr)
    'delete all data
    Local i As Long
    Local pNode As WsQdTreNode Ptr
    Local nodes() As Long
    ExitS(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    If @pTree.count Then
        ReDim nodes(1 To @pTree.count)
        i = 0
        pNode = WsQdTreFirst(pTree)
        While pNode
            Incr i
            nodes(i) = pNode
            pNode = WsQdTreNext(pNode)
        Wend
        For i = 1 To @pTree.count
            WsQdTreFreeNode(pTree, nodes(i))
        Next i
    End If
    @pTree.count = 0
    @pTree.root = 0
End Sub

Function WsQdTreCount(ByVal pTree As WsQdTre Ptr) As Long
    'get item count
    If pTree Then Function = @pTree.count
End Function

Sub WsQdTreSet(ByVal pTree As WsQdTre Ptr, ByRef key As WString, ByVal value As Quad, Opt ByVal DontReplace As Long)
    'add Key/Value to tree - Value replaced if Key exist unless DontReplace = True
    Local compare, temp As Long
    Local n As WsQdTreNode Ptr
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Sub
    If @pTree.root Then
        n = @pTree.root
        While 1
            Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
            If compare > 0 Then
                If @n.R Then
                    n = @n.R
                Else
                    @n.R = WsQdTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@R.P = n
                    WsSet @n.@R.K, key
                    @n.@R.V = value
                    WsQdTreBalanceBranch pTree, n
                    Exit Loop
                End If
            ElseIf compare < 0 Then
                If @n.L Then
                    n = @n.L
                Else
                    @n.L = WsQdTreAllocNode(pTree) : If Err Then Exit Sub
                    @n.@L.P = n
                    WsSet @n.@L.K, key
                    @n.@L.V = value
                    WsQdTreBalanceBranch pTree, n
                    Exit Loop
                End If
            Else
                If IsFalse DontReplace Then @n.V = value
                Exit Loop
            End If
        Wend
    Else
        @pTree.root = WsQdTreAllocNode(pTree) : If Err Then Exit Sub
        WsSet @pTree.@root.K, key
        @pTree.@root.V = value
        @pTree.count = 1
    End If
    temp = WsFinal(temp)
End Sub

Function WsQdTreGet(ByVal pTree As WsQdTre Ptr, ByRef key As WString) As Quad
    'get Key's associated Value
    Local compare, temp As Long
    Local n As WsQdTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = @n.V
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Function WsQdTreGot(ByVal pTree As WsQdTre Ptr, ByRef key As WString) As Long
    'True/False if Key exist
    Local compare, temp As Long
    Local n As WsQdTreNode Ptr
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    temp = WsSetNew(key) : If Err Then Exit Function
    n = @pTree.root
    While n
        Call Dword @pTree.compareCB Using WsCompareCB(temp, @n.K, @pTree.collation) To compare
        If compare < 0 Then
            n = @n.L
        ElseIf compare > 0 Then
            n = @n.R
        Else
            Function = n
            Exit Loop
        End If
    Wend
    temp = WsFinal(temp)
End Function

Sub WsQdTreDel(ByVal pTree As WsQdTre Ptr, ByRef key As WString)
    'remove Key and associated Value
    Local pNode As WsQdTreNode Ptr
    ExitS(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    pNode = WsQdTreGot(pTree, key)
    If pNode Then
        WsQdTreRemoveNode(pTree, pNode)
    End If
End Sub

Function WsQdTreFirst(ByVal pTree As WsQdTre Ptr) As Long
    'get handle to first node in tree
    Local n As WsQdTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.L
            n = @n.L
        Wend
    End If
    Function = n
End Function

Function WsQdTreLast(ByVal pTree As WsQdTre Ptr) As Long
    'get handle to last node in tree
    Local n As WsQdTreNode Ptr
    ExitF(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    n = @pTree.root
    If n Then
        While @n.R
            n = @n.R
        Wend
    End If
    Function = n
End Function

Function WsQdTreNext(ByVal pNode As WsQdTreNode Ptr) As Long
    'get handle to next node in tree
    Local minR As WsQdTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsQdTreNodeTag, LibErrH)
        minR = WsQdTreMinRight(pNode)
        If pNode <> minR Then
            Function = minR
        Else
            Function = WsQdTreParentGreater(pNode)
        End If
    End If
End Function

Function WsQdTrePrev(ByVal pNode As WsQdTreNode Ptr) As Long
    'get handle to previous node in tree
    Local maxL As WsQdTreNode Ptr
    If pNode Then
        ExitF(@pNode.tag<>WsQdTreNodeTag, LibErrH)
        maxL = WsQdTreMaxLeft(pNode)
        If pNode <> maxL Then
            Function = maxL
        Else
            Function = WsQdTreParentLesser(pNode)
        End If
    End If
End Function

Function WsQdTreGetKey(ByVal pNode As WsQdTreNode Ptr) As WString
    'get node's Key
    ExitF(pNode=0 Or @pNode.tag<>WsQdTreNodeTag, LibErrH)
    Function = WsGet(@pNode.K)
End Function

Function WsQdTreGetVal(ByVal pNode As WsQdTreNode Ptr) As Quad
    'get node's Value
    ExitF(pNode=0 Or @pNode.tag<>WsQdTreNodeTag, LibErrH)
    Function = @pNode.V
End Function

Sub WsQdTreSetVal(ByVal pNode As WsQdTreNode Ptr, ByVal value As Quad)
    'get node's Value
    ExitS(pNode=0 Or @pNode.tag<>WsQdTreNodeTag, LibErrH)
    @pNode.V = value
End Sub

'++
    '----------------------------------------------------------------------------------------
    '   Clone Container
    '----------------------------------------------------------------------------------------
'--

Function WsQdTreClone(ByVal pTree As WsQdTre Ptr) As Long
    'create duplicate container
    Local h, clone As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    clone = WsQdTreNew() : If Err Then Exit Function
    h = WsQdTreFirst(pTree)
    While h
        WsQdTreSet clone, WsQdTreGetKey(h), WsQdTreGetVal(h)
        h = WsQdTreNext(h)
    Wend
    Function = clone
End Function

'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From String
    '----------------------------------------------------------------------------------------
'--

Function WsQdTreStore(ByVal pTree As WsQdTre Ptr) As String
    'store container to string
    Local h, keys, vals, stor As Long
    Err = 0
    ExitF(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    keys = WsLstNew() : If Err Then Exit Function
    vals = QdLstNew() : If Err Then Exit Function
    stor = SsLstNew() : If Err Then Exit Function
    If @pTree.count Then
        h = WsQdTreFirst(pTree)
        While h
            WsLstAdd keys, WsQdTreGetKey(h)
            QdLstAdd vals, WsQdTreGetVal(h)
            h = WsQdTreNext(h)
        Wend
        SsLstAdd stor, WsLstStore(keys)
        SsLstAdd stor, QdLstStore(vals)
        Function = SsLstStore(stor)
    End If
    keys = WsLstFinal(keys)
    vals = QdLstFinal(vals)
    stor = SsLstFinal(stor)
End Function

Sub WsQdTreRestore(ByVal pTree As WsQdTre Ptr, ByVal s As String)
    'restore container from string
    Local keys, vals, stor As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    WsQdTreClear pTree
    keys = WsLstNew() : If Err Then Exit Sub
    vals = QdLstNew() : If Err Then Exit Sub
    stor = SsLstNew() : If Err Then Exit Sub
    If Len(s) Then
        SsLstRestore stor, s : If Err Then Exit Sub
        ExitS(SsLstCount(stor)<>2, LibErrU)
        WsLstRestore keys, SsLstPopFirst(stor)
        QdLstRestore vals, SsLstPopFirst(stor)
        ExitS(WsLstCount(keys)<>QdLstCount(vals), LibErrU)
        While WsLstCount(keys)
            WsQdTreSet pTree, WsLstPopFirst(keys), QdLstPopFirst(vals)
        Wend
    End If
    keys = WsLstFinal(keys)
    vals = QdLstFinal(vals)
    stor = SsLstFinal(stor)
End Sub


'++
    '----------------------------------------------------------------------------------------
    '   Store/Restore Container To/From File
    '----------------------------------------------------------------------------------------
'--

Sub WsQdTreFileStore(ByVal pTree As WsQdTre Ptr, ByVal file As String)
    'store container to file
    Local s As String
    Local f As Long
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    s = WsQdTreStore(pTree) : If Err Then Exit Sub
    Try
        f = FreeFile
        Open file For Binary As f
        SetEof f
        Put$ f, s
        Close f
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

Sub WsQdTreFileRestore(ByVal pTree As WsQdTre Ptr, ByVal file As String)
    'restore container from file - Modifies Container Data
    Local f As Long
    Local s As String
    Err = 0
    ExitS(pTree=0 Or @pTree.tag<>WsQdTreTag, LibErrH)
    Try
        f = FreeFile
        Open file For Binary As f
        Get$ f, Lof(f), s
        WsQdTreRestore pTree, s
    Catch
        ExitLogErr(LibErrF)
    Finally
        If f Then Close f
    End Try
End Sub

    '----------------------------------------------------------------------------------------
    '   PRIVATE
    '----------------------------------------------------------------------------------------

Sub WsQdTreRemoveNode(ByVal p As WsQdTre Ptr, ByVal n As WsQdTreNode Ptr) Private
    ExitS(n=0, LibErrP)
    Local nP, swapN As WsQdTreNode Ptr
    While @n.L Or @n.R
        swapN = IIf&(@n.HL >= @n.HR, WsQdTreMaxLeft(n), WsQdTreMinRight(n))
        If @p.root = n Then @p.root = swapN
        Swap @n.K, @swapN.K
        Swap @n.V, @swapN.V
        n = swapN
    Wend
    If n = @p.root Then
        WsQdTreClear p
    Else
        nP = @n.P
        ExitS(nP=0, LibErrP)
        If @nP.L = n Then @nP.L = 0 Else @nP.R = 0
        n = WsQdTreFreeNode(p, n)
        WsQdTreBalanceBranch p, nP
    End If
End Sub

Function WsQdTreAllocNode(ByVal p As WsQdTre Ptr) Private As Long
    Local n As WsQdTreNode Ptr
    n = MemAlloc(SizeOf(WsQdTreNode))
    ExitF(n=0, LIbErrM)
    @n.HL = 1
    @n.HR = 1
    @n.tag = WsQdTreNodeTag
    @n.K = WsNew() : If Err Then Exit Function
    Incr @p.count
    Function = n
End Function

Function WsQdTreFreeNode(ByVal p As WsQdTre Ptr, ByVal n As WsQdTreNode Ptr) As Long
    If n Then
        @n.K = WsFinal(@n.K)
        MemFree(n)
        ExitF(@p.count=0, LibErrU)
        Decr @p.count
    End If
End Function

Sub WsQdTreBalanceBranch(ByVal p As WsQdTre Ptr, ByVal n As WsQdTreNode Ptr) Private
    While n
        @n.HL = IIf&(@n.L, Max&(@n.@L.HL, @n.@L.HR) + 1, 1)
        @n.HR = IIf&(@n.R, Max&(@n.@R.HL, @n.@R.HR) + 1, 1)
        If @n.HL > @n.HR + 1 Then
            n = WsQdTreRotateRight(p, n)
        ElseIf @n.HR > @n.HL + 1 Then
            n = WsQdTreRotateLeft(p, n)
        Else
            n = @n.P
        End If
    Wend
End Sub

Function WsQdTreMaxLeft(ByVal n As WsQdTreNode Ptr) Private As Long
    If n Then
        If @n.L Then
            n = @n.L
            While @n.R
                n = @n.R
            Wend
        End If
    End If
    Function = n
End Function

Function WsQdTreMinRight(ByVal n As WsQdTreNode Ptr) Private As Long
    If n Then
        If @n.R Then
            n = @n.R
            While @n.L
                n = @n.L
            Wend
        End If
    End If
    Function = n
End Function

Function WsQdTreParentGreater(ByVal n As WsQdTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.L = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsQdTreParentLesser(ByVal n As WsQdTreNode Ptr) Private As Long
    If n Then
        While @n.P
            If @n.@P.R = n Then
                Function = @n.P
                Exit Function
            Else
                n = @n.P
            End If
        Wend
    End If
End Function

Function WsQdTreRotateLeft(ByVal p As WsQdTre Ptr, ByVal n As WsQdTreNode Ptr) Private As Long
    Local nR, nRL As WsQdTreNode Ptr
    nR = @n.R
    If @nR.HL > @nR.HR Then
        nRL = @nR.L
        @n.R = nRL : @nRL.P = n
        @nR.L = @nRL.R : If @nR.L Then @nR.@L.P = nR
        @nRL.R = nR : @nR.P = nRL
        @nR.HL = IIf&(@nR.L, Max&(@nR.@L.HL, @nR.@L.HR) + 1, 1)
        @nR.HR = IIf&(@nR.R, Max&(@nR.@R.HL, @nR.@R.HR) + 1, 1)
        nR = @n.R
    End If
    If @p.root = n Then @p.root = @n.R
    @n.R = @nR.L : If @n.R Then @n.@R.P = n
    @nR.P = @n.P : @n.P = nR : @nR.L = n
    If @nR.P Then
        If @nR.@P.L = n Then @nR.@P.L = nR Else @nR.@P.R = nR
    End If
    Function = n
End Function

Function WsQdTreRotateRight(ByVal p As WsQdTre Ptr, ByVal n As WsQdTreNode Ptr) Private As Long
    Local nL, nLR As WsQdTreNode Ptr
    nL = @n.L
    If @nL.HR > @nL.HL Then
        nLR = @nL.R
        @n.L = nLR : @nLR.P = n
        @nL.R = @nLR.L : If @nL.R Then @nL.@R.P = nL
        @nLR.L = nL : @nL.P = nLR
        @nL.HL = IIf&(@nL.L, Max&(@nL.@L.HL, @nL.@L.HR) + 1, 1)
        @nL.HR = IIf&(@nL.R, Max&(@nL.@R.HL, @nL.@R.HR) + 1, 1)
        nL = @n.L
    End If
    If @p.root = n Then @p.root = @n.L
    @n.L = @nL.R : If @n.L Then @n.@L.P = n
    @nL.P = @n.P : @n.P = nL : @nL.R = n
    If @nL.P Then
        If @nL.@P.L = n Then @nL.@P.L = nL Else @nL.@P.R = nL
    End If
    Function = n
End Function
