#Include This Once
#Include Once "C:\HLib2\Array\LnArr.inc"

Macro LnQdDuxNodeMax = 2000

Macro LnQdDuxTag = -174970846
Type LnQdDuxItm
    key As Long
    val As Quad
End Type
Type LnQdDux
    tag As Long
    count As Long
    arr As LnArr Ptr
End Type

Function LnQdDuxNew() As Long
    'allocate new container - return handle
    Local pDux As LnQdDux Ptr
    Err = 0
    pDux = MemAlloc(SizeOf(@pDux))
    ExitF(pDux=0, LibErrM)
    @pDux.tag = LnQdDuxTag
    @pDux.arr = LnArrNew() : If Err Then Exit Function
    Function = pDux
End Function

Function LnQdDuxCount(ByVal pDux As LnQdDux Ptr) ThreadSafe As Long
    'get item count (number of characters)
    ExitF(pDux=0 Or @pDux.tag<>LnQdDuxTag, LibErrH)
    Function = @pDux.count
End Function

Sub LnQdDuxSet(ByVal pDux As LnQdDux Ptr, ByVal key As Long, ByVal value As Quad, Opt ByVal DontReplace As Byte)
    Local i, j, compare As Long
    Local itm As LnQdDuxItm Ptr
    Err = 0
    ExitS(pDux=0 Or @pDux.tag<>LnQdDuxTag, LibErrH)
    itm = MemAlloc(SizeOf(@itm))
    ExitS(itm=0, LibErrM)
    @itm.key = key
    @itm.val = value
    i = LnArrBinPosUsing(@pDux.arr, key, compare, CodePtr(LnQdDuxRootCompareCB), 0) : If Err Then Exit Sub
    If i = 0 Then
        LnArrAdd @pDux.arr, LnArrNew() : If Err Then Exit Sub
        LnArrAdd @pDux.@arr.@arr[1], itm : If Err Then Exit Sub
        @pDux.count = 1
    ElseIf compare < 0 Then
        LnArrIns @pDux.@arr.@arr[i], 1, itm
        '''split'''
        Incr @pDux.count
    ElseIf compare > 0 Then
        LnArrAdd @pDux.@arr.@arr[i], itm
        '''split'''
        Incr @pDux.count
    Else
        j = LnArrBinPosUsing(@pDux.@arr.@arr[i], key, compare, CodePtr(LnQdDuxItemCompareCB), 0) : If Err Then Exit Sub
        If compare = 0 Then
            itm = MemFree(itm)
            If IsFalse DontReplace Then
                itm = LnArrGet(@pDux.@arr.@arr[i], j)
                ExitS(itm=0, LibErrU)
                @itm.val = value
            End If
        Else
            LnArrBinInsertUsing(@pDux.@arr.@arr[i], itm, CodePtr(LnQdDuxItemCompareCB), 0)
            '''split'''
            Incr @pDux.count
        End If
    End If
End Sub

Function LnQdDuxGet(ByVal pDux As LnQdDux Ptr, ByVal key As Long) As Quad
    'get Key's associated Value
    Local i, j, compare As Long
    Local arr As LnArr Ptr
    Local itm As LnQdDuxItm Ptr
    ExitF(pDux=0 Or @pDux.tag<>LnQdDuxTag, LibErrH)
    i = LnArrBinSearchUsing(@pDux.arr, key, CodePtr(LnQdDuxRootCompareCB), 0)
    If i Then
            ? "'''''''''''''''''''''''''''''''"
        j = LnArrBinSearchUsing(@pDux.@arr.@arr[i], key, CodePtr(LnQdDuxItemCompareCB), 0)
        If j Then
            ? "'''''''''''''''''''''''''''''''"
            arr = @pDux.@arr.@arr[i]
            itm = @arr.@arr[j]
            ExitF(itm=0, LibErrU)
            Function = @itm.val
        End If
    End If
End Function

Function LnQdDuxRootCompareCB(ByVal key As Long, ByVal itmArr As LnArr Ptr, ByVal collation As Long) As Long
    Local pItms As LnQdDuxItm Ptr
    ExitF(itmArr=0, LibErrP)
    pItms = @itmArr.arr
    If key < @pItms[1].key Then
        Function = -1
    ElseIf key > @pItms[@itmArr.count].key Then
        Function = 1
    End If
End Function

Function LnQdDuxItemCompareCB(ByVal key As Long, ByVal itm As LnQdDuxItm Ptr, ByVal collation As Long) As Long
    ExitF(itm=0, LibErrP)
    If key < @itm.key Then
        Function = -1
    ElseIf key > @itm.key Then
        Function = 1
    End If
End Function
